/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.suits.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.types.Suit;
import com.yapzhenyie.GadgetsMenu.utils.BlockUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class SuitWarrior
extends Suit {
    private boolean activated = false;
    private boolean clicked = false;
    private ArrayList<FallingBlock> fallingBlocks = new ArrayList();

    public SuitWarrior(UUID uuid) {
        super(uuid, SuitType.WARRIOR);
    }

    @Override
    public void onUpdate() {
        if (this.clicked && !this.isBeingCooldown()) {
            this.activated = true;
            this.spawnFallingBlock(this.getPlayer());
            Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), new Runnable(){

                @Override
                public void run() {
                    try {
                        SuitWarrior.this.clearAll();
                    }
                    catch (Exception e) {
                        SuitWarrior.this.onClear();
                        e.printStackTrace();
                    }
                    SoundEffect.BLOCK_GRASS_STEP.playSound(SuitWarrior.this.getPlayer().getLocation());
                    SuitWarrior.this.fallingBlocks.remove(SuitWarrior.this.getPlayer().getUniqueId());
                }
            }, 22L);
            this.clicked = false;
            this.addCooldownTimer();
        }
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (FallingBlock fallingblock : this.fallingBlocks) {
            if (fallingblock == null) continue;
            fallingblock.remove();
        }
        this.fallingBlocks.clear();
        this.clicked = false;
        this.activated = false;
    }

    private void spawnFallingBlock(final Player player) {
        final Location loc = player.getLocation();
        SoundEffect.ENTITY_GENERIC_EXPLODE.playSound(player.getLocation(), 2.0f, 1.0f);
        new BukkitRunnable(){
            int step = 1;

            public void run() {
                if (!player.isOnline() || GadgetsMenu.getPlayerManager(SuitWarrior.this.getPlayer()).getCurrentSuit() == null || GadgetsMenu.getPlayerManager(SuitWarrior.this.getPlayer()).getCurrentSuit().getType() != SuitWarrior.this.getType() || !SuitWarrior.this.activated) {
                    this.step = 7;
                    SuitWarrior.this.clearAll();
                    this.cancel();
                    return;
                }
                if (this.step >= 7) {
                    this.cancel();
                }
                for (FallingBlock fallingblock : SuitWarrior.this.fallingBlocks) {
                    if (fallingblock.getTicksLived() <= 2) continue;
                    fallingblock.remove();
                }
                for (Block b : BlockUtil.getBlocksInRadius(loc.clone().add(1.5, -1.5, 1.5), this.step, true)) {
                    if (b.getType() == Material.AIR || b.getType().toString().toLowerCase().contains("banner") || b.getType() == EnumMaterial.BARRIER.getType() || b.getType().toString().toLowerCase().contains("bed") || b.getType() == EnumMaterial.BREWING_STAND.getType() || b.getType() == EnumMaterial.BROWN_MUSHROOM.getType() || b.getType() == EnumMaterial.CACTUS.getType() || b.getType() == EnumMaterial.CAKE.getType() || b.getType().toString().toLowerCase().contains("cake_block") || b.getType() == EnumMaterial.CARROT.getType() || b.getType() == EnumMaterial.CARROTS.getType() || b.getType().toString().toLowerCase().contains("carpet") || b.getType() == EnumMaterial.CHEST.getType() || b.getType() == EnumMaterial.COCOA.getType() || b.getType().toString().toLowerCase().contains("crops") || b.getType() == EnumMaterial.DANDELION.getType() || b.getType() == EnumMaterial.DEAD_BUSH.getType() || b.getType().toString().toLowerCase().contains("double_plant") || b.getType() == EnumMaterial.DRAGON_EGG.getType() || b.getType() == EnumMaterial.END_PORTAL.getType() || b.getType() == EnumMaterial.END_PORTAL_FRAME.getType() || b.getType() == EnumMaterial.FARMLAND.getType() || b.getType() == EnumMaterial.FERN.getType() || b.getType() == EnumMaterial.FIRE.getType() || b.getType() == EnumMaterial.FLOWER_POT.getType() || b.getType().toString().toLowerCase().contains("flower_pot") || b.getType() == EnumMaterial.GRASS.getType() || b.getType().toString().toLowerCase().contains("head") || b.getType() == EnumMaterial.LADDER.getType() || b.getType() == EnumMaterial.LARGE_FERN.getType() || b.getType().toString().toLowerCase().endsWith("lava") || b.getType() == EnumMaterial.LILY_PAD.getType() || b.getType() == EnumMaterial.LILAC.getType() || b.getType().toString().toLowerCase().contains("long_grass") || b.getType() == EnumMaterial.MELON_STEM.getType() || b.getType() == EnumMaterial.MUSHROOM_STEM.getType() || b.getType() == EnumMaterial.NETHER_PORTAL.getType() || b.getType() == EnumMaterial.NETHER_WART.getType() || b.getType() == EnumMaterial.PEONY.getType() || b.getType().toString().toLowerCase().contains("piston_") || b.getType() == EnumMaterial.POTATO.getType() || b.getType() == EnumMaterial.POTATOES.getType() || b.getType().toString().toLowerCase().contains("potted_") || b.getType() == EnumMaterial.PUMPKIN_STEM.getType() || b.getType() == EnumMaterial.RED_MUSHROOM.getType() || b.getType().toString().toLowerCase().contains("redstone_lamp") || b.getType().toString().toLowerCase().contains("redstone_torch") || b.getType().toString().toLowerCase().contains("red_rose") || b.getType() == EnumMaterial.REDSTONE_WIRE.getType() || b.getType() == EnumMaterial.ROSE_BUSH.getType() || b.getType().toString().toLowerCase().contains("sapling") || b.getType().toString().toLowerCase().contains("seeds") || b.getType().toString().toLowerCase().contains("sign") || b.getType().toString().toLowerCase().contains("skull") || b.getType() == EnumMaterial.SNOW.getType() || b.getType() == EnumMaterial.SUGAR_CANE.getType() || b.getType().toString().toLowerCase().contains("sugar_cane_block") || b.getType() == EnumMaterial.SUNFLOWER.getType() || b.getType() == EnumMaterial.TALL_GRASS.getType() || b.getType() == EnumMaterial.TORCH.getType() || b.getType() == EnumMaterial.TRIPWIRE.getType() || b.getType() == EnumMaterial.TRIPWIRE_HOOK.getType() || b.getType().toString().toLowerCase().contains("tulip") || b.getType() == EnumMaterial.VINE.getType() || b.getType().toString().toLowerCase().endsWith("water") || b.getType() == EnumMaterial.WHEAT.getType() || b.getType().toString().toLowerCase().contains("_button") || b.getType().toString().toLowerCase().contains("_plate") || b.hasMetadata(GadgetsMenu.getInstance().getPluginName()) || !b.getType().isSolid() || b.getRelative(BlockFace.UP).getType() != Material.AIR) continue;
                    FallingBlock fb = loc.getWorld().spawnFallingBlock(b.getLocation().clone().add(0.0, (double)1.1f, 0.0), b.getType(), b.getData());
                    fb.setVelocity(new Vector(0.0f, 0.3f, 0.0f));
                    fb.setDropItem(false);
                    fb.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                    SuitWarrior.this.fallingBlocks.add(fb);
                }
                ++this.step;
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 3L);
    }

    @EventHandler
    public void onPlayerClick(PlayerInteractEvent e) {
        if (!(e.getAction() != Action.LEFT_CLICK_AIR && e.getAction() != Action.LEFT_CLICK_BLOCK || e.getPlayer() != this.getPlayer() || this.clicked)) {
            if (e.getPlayer().getItemInHand().getType() != Material.AIR) {
                return;
            }
            if (this.isBeingCooldown()) {
                e.setCancelled(true);
                return;
            }
            if (this.activated) {
                this.getPlayer().sendMessage(MessageType.SUIT_ABILITY_IS_ACTIVATED.getFormatMessage().replace("{SUIT}", this.getType().getDisplayNameStripColor()));
                e.setCancelled(true);
                return;
            }
            this.clicked = true;
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onBlockChange(EntityChangeBlockEvent event) {
        FallingBlock fb;
        if (event.getEntityType() == EntityType.FALLING_BLOCK && (fb = (FallingBlock)event.getEntity()).hasMetadata(GadgetsMenu.getInstance().getPluginName())) {
            event.setCancelled(true);
        }
    }
}

