/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.custom;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.standard.HatType;
import com.yapzhenyie.GadgetsMenu.utils.GMaterial;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Rarity;
import java.util.List;
import org.bukkit.inventory.ItemStack;

public class CustomHatType {
    private String name;
    private String displayName;
    private GMaterial material;
    private String permission;
    private int mysteryDust;
    private Rarity rarity;
    private List<String> lore;
    private boolean isEnable;
    private boolean canBeFound;
    private boolean purchasable;
    private ItemStack itemStack;

    public static void initCustomHats() {
        FileManager customHatsFile = FileManager.getCustomHatsFile();
        if (customHatsFile.get("Custom-Hats") != null) {
            for (String s : customHatsFile.getConfigurationSection("Custom-Hats").getKeys(false)) {
                new CustomHatType(s, "&a" + s.toLowerCase() + " Hat", new GMaterial("head:eb7af9e4411217c7de9c60acbd3c3fd6519783332a1b3bc56fbfce90721ef35"), "gadgetsmenu.hats." + s.toLowerCase().replace(" ", ""), 12, Rarity.COMMON, null);
            }
        } else {
            customHatsFile.addDefault("Custom-Hats.Steve.Name", "&aSteve Hat");
            customHatsFile.addDefault("Custom-Hats.Steve.Mystery Dust", 12);
            customHatsFile.addDefault("Custom-Hats.Steve.Rarity", Rarity.COMMON.getName());
            customHatsFile.addDefault("Custom-Hats.Steve.Material", "head:eb7af9e4411217c7de9c60acbd3c3fd6519783332a1b3bc56fbfce90721ef35");
            customHatsFile.addDefault("Custom-Hats.Steve.Enabled", false);
            customHatsFile.addDefault("Custom-Hats.Steve.CanBeFound", true);
            customHatsFile.addDefault("Custom-Hats.Steve.Purchasable", true);
            customHatsFile.addDefault("Custom-Hats.Steve.Lore", "");
            customHatsFile.addDefault("Custom-Hats.Sponge.Name", "&aSponge Hat");
            customHatsFile.addDefault("Custom-Hats.Sponge.Mystery Dust", 12);
            customHatsFile.addDefault("Custom-Hats.Sponge.Rarity", Rarity.COMMON.getName());
            customHatsFile.addDefault("Custom-Hats.Sponge.Material", "SPONGE");
            customHatsFile.addDefault("Custom-Hats.Sponge.Enabled", false);
            customHatsFile.addDefault("Custom-Hats.Sponge.CanBeFound", true);
            customHatsFile.addDefault("Custom-Hats.Sponge.Purchasable", true);
            customHatsFile.addDefault("Custom-Hats.Sponge.Lore", "");
        }
    }

    public CustomHatType(String name, String displayName, GMaterial material, String permission, int mysteryDust, Rarity rarity, List<String> lore) {
        this.name = name;
        if (FileManager.getCustomHatsFile().get("Custom-Hats." + this.name + ".Name") == null) {
            this.displayName = displayName;
            FileManager.getCustomHatsFile().set("Custom-Hats." + this.name + ".Name", this.displayName);
        } else {
            this.displayName = FileManager.getCustomHatsFile().getString("Custom-Hats." + this.name + ".Name");
        }
        if (FileManager.getCustomHatsFile().get("Custom-Hats." + this.name + ".Texture") != null) {
            FileManager.getCustomHatsFile().set("Custom-Hats." + this.name + ".Material", "head:" + FileManager.getCustomHatsFile().get("Custom-Hats." + this.name + ".Texture"));
            FileManager.getCustomHatsFile().set("Custom-Hats." + this.name + ".Texture", null);
        }
        this.material = FileManager.getCustomHatsFile().get("Custom-Hats." + this.name + ".Material") == null ? material : new GMaterial(FileManager.getCustomHatsFile().getString("Custom-Hats." + this.name + ".Material"));
        this.permission = permission;
        if (FileManager.getCustomHatsFile().get("Custom-Hats." + this.name + ".Mystery Dust") == null) {
            this.mysteryDust = mysteryDust;
            FileManager.getCustomHatsFile().set("Custom-Hats." + this.name + ".Mystery Dust", this.mysteryDust);
        } else {
            this.mysteryDust = FileManager.getCustomHatsFile().getInt("Custom-Hats." + this.name + ".Mystery Dust");
        }
        if (FileManager.getCustomHatsFile().get("Custom-Hats." + this.name + ".Rarity") == null) {
            this.rarity = rarity;
            FileManager.getCustomHatsFile().set("Custom-Hats." + this.name + ".Rarity", this.rarity.getName());
        } else {
            this.rarity = Rarity.getName(FileManager.getCustomHatsFile().getString("Custom-Hats." + this.name + ".Rarity"));
        }
        if (FileManager.getCustomHatsFile().get("Custom-Hats." + this.name + ".Enabled") == null) {
            FileManager.getCustomHatsFile().set("Custom-Hats." + this.name + ".Enabled", true);
            this.isEnable = true;
        } else {
            this.isEnable = FileManager.getCustomHatsFile().getBoolean("Custom-Hats." + this.name + ".Enabled");
        }
        if (FileManager.getCustomHatsFile().get("Custom-Hats." + this.name + ".CanBeFound") == null) {
            FileManager.getCustomHatsFile().set("Custom-Hats." + this.name + ".CanBeFound", true);
            this.canBeFound = true;
        } else {
            this.canBeFound = FileManager.getCustomHatsFile().getBoolean("Custom-Hats." + this.name + ".CanBeFound");
        }
        if (FileManager.getCustomHatsFile().get("Custom-Hats." + this.name + ".Purchasable") == null) {
            FileManager.getCustomHatsFile().set("Custom-Hats." + this.name + ".Purchasable", true);
            this.purchasable = true;
        } else {
            this.purchasable = FileManager.getCustomHatsFile().getBoolean("Custom-Hats." + this.name + ".Purchasable");
        }
        if (FileManager.getCustomHatsFile().get("Custom-Hats." + this.name + ".Lore") == null) {
            this.lore = lore;
            if (lore == null) {
                FileManager.getCustomHatsFile().set("Custom-Hats." + this.name + ".Lore", "");
            } else {
                FileManager.getCustomHatsFile().set("Custom-Hats." + this.name + ".Lore", this.lore);
            }
        } else {
            this.lore = FileManager.getCustomHatsFile().getStringList("Custom-Hats." + this.name + ".Lore");
        }
        this.itemStack = ItemUtils.item(this.displayName, this.material);
        this.itemStack = GadgetsMenu.getNMSManager().setNBTTag(this.itemStack, "Cosmetics", "true");
        this.itemStack = GadgetsMenu.getNMSManager().setNBTTag(this.itemStack, "Category", "Hat");
        new HatType(this.name, this.displayName, this.material, this.permission, this.mysteryDust, this.rarity, this.lore, this.isEnable, this.canBeFound, this.purchasable, this.itemStack);
    }

    public String toString() {
        return this.name;
    }
}

