/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.menu.menus;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.api.GadgetsMenuAPI;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.banners.BannerManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.banners.BannerType;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.GInventory;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.StringUtils;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.discount.DiscountManager;
import com.yapzhenyie.GadgetsMenu.utils.discount.ItemCostDiscount;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class BannersMenu
implements Listener {
    public static void openBannersMenu(Player player, int page) {
        int size = BannerType.enabled().size();
        int maxPages = GInventory.getMaxPagesAmount(21, size);
        if (page <= 0) {
            page = 1;
        }
        if (page > 1 && maxPages < page) {
            page = 1;
        }
        Inventory invBanners = Bukkit.createInventory(null, (int)54, (String)ChatUtil.format(Category.BANNERS.getGUIName() + StringUtils.addPlaceholders(EnumItem.PAGES.getDisplayName(), Arrays.asList("{CURRENT_PAGE}", "{MAX_PAGES}"), Arrays.asList(String.valueOf(page), String.valueOf(maxPages)))));
        int i = 0;
        int from = 1;
        if (page > 1) {
            from = 21 * (page - 1) + 1;
        }
        int to = 21;
        if (size < 21) {
            to = size;
        }
        if (page > 1) {
            to = size >= 21 * page ? 21 * page : size;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        for (int h = from; h <= to; ++h) {
            try {
                if (h > size) break;
                BannerType banners = BannerType.enabled().get(h - 1);
                if (PermissionUtils.noPermission(player, banners.getPermission(), EnumPermission.BANNERS.getPermission(), false)) {
                    DiscountManager discountManager = new DiscountManager(pManager, Category.BANNERS.isPurchasable() && banners.isPurchasable(), banners.getMysteryDust());
                    if (EnumItem.NO_PERMISSION.showCustomItem()) {
                        InventoryUtils.inventory(invBanners, banners.getDisplayName(), EnumItem.NO_PERMISSION.getCustomItem(), banners.getLore(), EnumItem.NO_PERMISSION.isShowInLore() ? EnumItem.NO_PERMISSION.getLore() : null, discountManager.getLore(), GInventory.LAY_OUT_21.getLayOut()[i++]);
                        continue;
                    }
                    InventoryUtils.inventory(invBanners, banners.getDisplayName(), banners.getMaterial(), banners.getLore(), EnumItem.NO_PERMISSION.isShowInLore() ? EnumItem.NO_PERMISSION.getLore() : null, discountManager.getLore(), GInventory.LAY_OUT_21.getLayOut()[i++]);
                    continue;
                }
                InventoryUtils.inventoryAddGlow(invBanners, banners.getDisplayName(), banners.getMaterial(), banners.getLore(), EnumItem.HAS_PERMISSION.isShowInLore() ? EnumItem.HAS_PERMISSION.getLore() : null, GInventory.LAY_OUT_21.getLayOut()[i++], pManager.getSelectedBanner() == null ? null : pManager.getSelectedBanner().getDisplayName());
                continue;
            }
            catch (Exception Ex) {
                Ex.printStackTrace();
                player.sendMessage(MessageType.ERROR.getFormatMessage());
                return;
            }
        }
        if (EnumItem.RESET_BANNER.show()) {
            InventoryUtils.inventory(invBanners, EnumItem.RESET_BANNER.getItemStack(), EnumItem.RESET_BANNER.getSlot());
        }
        if (page == 1) {
            if (EnumItem.GO_BACK.show()) {
                InventoryUtils.inventory(invBanners, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot());
            }
        } else {
            InventoryUtils.inventory(invBanners, EnumItem.PREVIOUS_PAGE.getItemStack(), "{PAGE}", String.valueOf(page - 1), EnumItem.PREVIOUS_PAGE.getSlot());
        }
        if (page < maxPages) {
            InventoryUtils.inventory(invBanners, EnumItem.NEXT_PAGE.getItemStack(), "{PAGE}", String.valueOf(page + 1), EnumItem.NEXT_PAGE.getSlot());
        }
        if (EnumItem.MAIN_MENU_ITEM.show()) {
            InventoryUtils.mainMenuButton(pManager, invBanners, EnumItem.MAIN_MENU_ITEM.getSlot());
        }
        InventoryUtils.fillItems(invBanners);
        player.openInventory(invBanners);
        pManager.setCurrentBannersPage(page);
    }

    @EventHandler
    public void onInvClickBanners(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getView().getTitle().startsWith(Category.BANNERS.getGUIName())) {
            if (event.getClickedInventory() == null || event.getClickedInventory().getSize() != 54 || event.getClickedInventory().getType() != InventoryType.CHEST) {
                event.setCancelled(true);
                return;
            }
            if (!Category.BANNERS.isEnabled() || !WorldUtils.isWorldEnabled(player, true)) {
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || event.getCurrentItem().getItemMeta().getDisplayName() == null) {
                event.setCancelled(true);
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT || event.getClick() == ClickType.NUMBER_KEY || event.getClick() == ClickType.UNKNOWN) {
                player.updateInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot())) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                event.setCancelled(true);
                return;
            }
            PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
            if (ItemUtils.getCurrentItem(event, EnumItem.RESET_BANNER.getItemStack(), EnumItem.RESET_BANNER.getSlot())) {
                pManager.unequipBanner();
                player.sendMessage(MessageType.RESET_BANNER.getFormatMessage());
                if (EnumItem.RESET_BANNER.isPlaySoundEnabled()) {
                    EnumItem.RESET_BANNER.getSound().playSound(player, 1.0f, 2.0f);
                }
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.PREVIOUS_PAGE.getDisplayName(), EnumItem.PREVIOUS_PAGE.getSlot())) {
                BannersMenu.openBannersMenu(player, pManager.getCurrentBannersPage() - 1);
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.NEXT_PAGE.getDisplayName(), EnumItem.NEXT_PAGE.getSlot())) {
                BannersMenu.openBannersMenu(player, pManager.getCurrentBannersPage() + 1);
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.MAIN_MENU_ITEM.getDisplayName(), EnumItem.MAIN_MENU_ITEM.getSlot())) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                event.setCancelled(true);
                return;
            }
            for (BannerType banner : BannerType.values()) {
                if (!event.getCurrentItem().getItemMeta().getDisplayName().equals(ChatUtil.format(banner.getDisplayName()))) continue;
                if (PermissionUtils.noPermission(player, banner.getPermission(), EnumPermission.BANNERS.getPermission(), false)) {
                    if (Category.BANNERS.isPurchasable()) {
                        if (!banner.isPurchasable()) {
                            player.sendMessage(MessageType.ITEM_UNPURCHASABLE.getFormatMessage());
                            if (EnumItem.ITEM_UNPURCHASABLE.isPlaySoundEnabled()) {
                                EnumItem.ITEM_UNPURCHASABLE.getSound().playSound(player, 1.0f, 0.5f);
                            }
                            player.closeInventory();
                            event.setCancelled(true);
                            return;
                        }
                        ItemCostDiscount discount = pManager.getItemCostDiscount();
                        int discountedPrice = banner.getMysteryDust();
                        if (discount != null) {
                            discountedPrice = discount.getPriceAfterDiscount(banner.getMysteryDust());
                        }
                        if (pManager.getMysteryDust() >= discountedPrice) {
                            pManager.purchaseData().setData(Category.BANNERS, banner.getName(), banner.getDisplayName(), discount, banner.getMysteryDust(), banner.getPermission());
                            pManager.openItemPurchaseMenu();
                        } else {
                            player.sendMessage(MessageType.NOT_ENOUGH_MYSTERY_DUST_TO_PURCHASE.getFormatMessage());
                            if (EnumItem.NOT_ENOUGH_MYSTERY_DUST.isPlaySoundEnabled()) {
                                EnumItem.NOT_ENOUGH_MYSTERY_DUST.getSound().playSound(player, 1.0f, 0.5f);
                            }
                            player.closeInventory();
                        }
                        event.setCancelled(true);
                        return;
                    }
                    if (!PermissionUtils.noPermission(player, banner.getPermission(), EnumPermission.BANNERS.getPermission(), true)) continue;
                    if (EnumItem.NO_PERMISSION.isPlaySoundEnabled()) {
                        EnumItem.NO_PERMISSION.getSound().playSound(player, 1.0f, 0.5f);
                    }
                    if (EnumItem.NO_PERMISSION.isCloseGUIMenuAfterSelect()) {
                        player.closeInventory();
                    }
                    event.setCancelled(true);
                    return;
                }
                try {
                    if (pManager.getSelectedBanner() != null && ChatUtil.format(banner.getDisplayName()).equals(pManager.getSelectedBanner().getDisplayName())) {
                        pManager.unequipBanner();
                        player.sendMessage(MessageType.RESET_BANNER.getFormatMessage());
                        if (EnumItem.RESET_BANNER.isPlaySoundEnabled()) {
                            EnumItem.RESET_BANNER.getSound().playSound(player, 1.0f, 2.0f);
                        }
                        player.closeInventory();
                        event.setCancelled(true);
                        return;
                    }
                    if (!BannerManager.checkRequirement(player, banner)) {
                        player.closeInventory();
                        event.setCancelled(true);
                        return;
                    }
                    pManager.equipBanner(banner);
                    player.sendMessage(MessageType.SELECT_BANNER.getFormatMessage().replace("{BANNER}", banner.getDisplayNameStripColor()));
                    if (EnumItem.HAS_PERMISSION.isPlaySoundEnabled()) {
                        EnumItem.HAS_PERMISSION.getSound().playSound(player, 1.0f, 2.0f);
                    }
                    if (EnumItem.HAS_PERMISSION.isCloseGUIMenuAfterSelect()) {
                        player.closeInventory();
                    } else {
                        BannersMenu.openBannersMenu(player, pManager.getCurrentBannersPage());
                    }
                    event.setCancelled(true);
                    return;
                }
                catch (Exception Ex) {
                    player.sendMessage(MessageType.ERROR.getFormatMessage());
                    Ex.printStackTrace();
                }
            }
            event.setCancelled(true);
            return;
        }
    }
}

