/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.menu.menus;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.api.GadgetsMenuAPI;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetCategoryType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.menu.menus.GadgetTypesMenu;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.GInventory;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class GadgetCategoriesMenu
implements Listener {
    public static void openCategoryGadgetsMenu(Player player) {
        int size = GadgetCategoryType.enabled().size();
        Inventory invGadgets = Bukkit.createInventory(null, (int)54, (String)Category.GADGETS.getGUIName());
        int i = 0;
        int from = 1;
        int to = 21;
        if (size < 21) {
            to = size;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        for (int h = from; h <= to; ++h) {
            try {
                if (h > size) break;
                GadgetCategoryType type = GadgetCategoryType.enabled().get(h - 1);
                if (GadgetType.getGroup(type.getName()).size() == 0) continue;
                if (!PermissionUtils.containsPermission(player, type.getPermission())) {
                    if (EnumItem.NO_PERMISSION.showCustomItem()) {
                        InventoryUtils.inventoryCategory(player, invGadgets, type.getDisplayName(), EnumItem.NO_PERMISSION.getCustomItem(), type.getLore(), null, GInventory.LAY_OUT_21.getLayOut()[i++], GadgetCategoriesMenu.hasPermission(player, type.getName()), GadgetType.getGroup(type.getName()).size());
                        continue;
                    }
                    InventoryUtils.inventoryCategory(player, invGadgets, type.getDisplayName(), type.getMaterial(), type.getLore(), null, GInventory.LAY_OUT_21.getLayOut()[i++], GadgetCategoriesMenu.hasPermission(player, type.getName()), GadgetType.getGroup(type.getName()).size());
                    continue;
                }
                InventoryUtils.inventoryCategoryAddGlow(player, invGadgets, type.getDisplayName(), type.getMaterial(), type.getLore(), null, GInventory.LAY_OUT_21.getLayOut()[i++], pManager.getSelectedCategoryGadget() == null ? null : pManager.getSelectedCategoryGadget().getDisplayName(), GadgetCategoriesMenu.hasPermission(player, type.getName()), GadgetType.getGroup(type.getName()).size());
                continue;
            }
            catch (Exception e) {
                player.sendMessage(MessageType.ERROR.getFormatMessage());
                e.printStackTrace();
                return;
            }
        }
        if (EnumItem.RESET_GADGET.show()) {
            InventoryUtils.inventory(invGadgets, EnumItem.RESET_GADGET.getItemStack(), EnumItem.RESET_GADGET.getSlot());
        }
        if (EnumItem.GO_BACK.show()) {
            InventoryUtils.inventory(invGadgets, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot());
        }
        if (EnumItem.MAIN_MENU_ITEM.show()) {
            InventoryUtils.mainMenuButton(pManager, invGadgets, EnumItem.MAIN_MENU_ITEM.getSlot());
        }
        InventoryUtils.fillItems(invGadgets);
        player.openInventory(invGadgets);
    }

    @EventHandler
    public void onInvClickCategoryGadgets(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getView().getTitle().equals(Category.GADGETS.getGUIName())) {
            if (event.getClickedInventory() == null || event.getClickedInventory().getSize() != 54 || event.getClickedInventory().getType() != InventoryType.CHEST) {
                event.setCancelled(true);
                return;
            }
            if (!Category.GADGETS.isEnabled() || !WorldUtils.isWorldEnabled(player, true)) {
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || event.getCurrentItem().getItemMeta().getDisplayName() == null) {
                event.setCancelled(true);
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT || event.getClick() == ClickType.NUMBER_KEY || event.getClick() == ClickType.UNKNOWN) {
                event.setCancelled(true);
                player.updateInventory();
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot())) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.RESET_GADGET.getItemStack(), EnumItem.RESET_GADGET.getSlot())) {
                GadgetsMenu.getPlayerManager(player).unequipGadget();
                player.sendMessage(MessageType.RESET_GADGET.getFormatMessage());
                if (EnumItem.RESET_GADGET.isPlaySoundEnabled()) {
                    EnumItem.RESET_GADGET.getSound().playSound(player, 1.0f, 2.0f);
                }
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.MAIN_MENU_ITEM.getDisplayName(), EnumItem.MAIN_MENU_ITEM.getSlot())) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                event.setCancelled(true);
                return;
            }
            for (GadgetCategoryType gadget : GadgetCategoryType.values()) {
                if (!event.getCurrentItem().getItemMeta().getDisplayName().equals(ChatUtil.format(gadget.getDisplayName()))) continue;
                GadgetTypesMenu.openGadgetTypesMenu(player, gadget.getName(), 1);
                event.setCancelled(true);
                return;
            }
            event.setCancelled(true);
            return;
        }
    }

    private static int hasPermission(Player player, String category) {
        if (!GadgetCategoryType.valueOf(category).isEnabled()) {
            return 0;
        }
        if (player.hasPermission(EnumPermission.GADGETS.getPermission())) {
            return GadgetType.getGroup(category).size();
        }
        int size = 0;
        for (GadgetType types : GadgetType.getGroup(category)) {
            if (!types.isEnabled() || !player.hasPermission(types.getPermission())) continue;
            ++size;
        }
        return size;
    }
}

