/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.menu.menus;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.MainMenuType;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.GCommandHandler;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.PurchaseData;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class ItemPurchaseMenu
implements Listener {
    public static void openItemPurchaseMenu(Player player) {
        Inventory invItemPurchase = Bukkit.createInventory(null, (int)27, (String)GadgetsMenu.getGadgetsMenuData().getItemPurchaseGUIName());
        InventoryUtils.inventory(invItemPurchase, EnumItem.CONFIRM_PURCHASE_ITEM.getItemStack(), EnumItem.CONFIRM_PURCHASE_ITEM.getSlot());
        InventoryUtils.inventory(invItemPurchase, EnumItem.CANCEL_PURCHASE_ITEM.getItemStack(), EnumItem.CANCEL_PURCHASE_ITEM.getSlot());
        InventoryUtils.fillItems(invItemPurchase);
        player.openInventory(invItemPurchase);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void InvClickPurchaseMenu(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getView().getTitle().equals(GadgetsMenu.getGadgetsMenuData().getItemPurchaseGUIName())) {
            if (!GadgetsMenu.getGadgetsMenuData().isCosmeticItemPurchasable() || !WorldUtils.isWorldEnabled(player, true)) {
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || event.getCurrentItem().getItemMeta().getDisplayName() == null) {
                event.setCancelled(true);
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT || event.getClick() == ClickType.NUMBER_KEY || event.getClick() == ClickType.UNKNOWN) {
                event.setCancelled(true);
                player.updateInventory();
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.CONFIRM_PURCHASE_ITEM.getItemStack(), EnumItem.CONFIRM_PURCHASE_ITEM.getSlot())) {
                PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
                if (pManager.purchaseData() == null || pManager.purchaseData().getPrice() == -1 || pManager.purchaseData().getPermission() == null) {
                    player.sendMessage(MessageType.FAILED_TO_PURCHASE.getFormatMessage());
                    if (EnumItem.FAILED_TO_PURCHASE.isPlaySoundEnabled()) {
                        EnumItem.FAILED_TO_PURCHASE.getSound().playSound(player, 1.0f, 0.5f);
                    }
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
                PurchaseData purchaseData = pManager.purchaseData();
                if (!PermissionUtils.noPermission(player, purchaseData.getPermission(), false)) {
                    player.sendMessage(MessageType.FAILED_TO_PURCHASE.getFormatMessage());
                    if (GadgetsMenu.getGadgetsMenuData().isReopenGUIMenuAfterPurchase()) {
                        MainMenuType menu = MainMenuType.valueOf(purchaseData.getCategory().getName());
                        if (menu.isEnabled()) {
                            purchaseData.getCategory().openMenu(player, pManager.getCurrentMenuPageByCategory(purchaseData.getCategory()));
                        }
                    } else {
                        player.closeInventory();
                    }
                    event.setCancelled(true);
                    return;
                }
                if (pManager.getMysteryDust() < purchaseData.getPrice()) {
                    player.sendMessage(MessageType.NOT_ENOUGH_MYSTERY_DUST_TO_PURCHASE.getFormatMessage());
                    if (EnumItem.NOT_ENOUGH_MYSTERY_DUST.isPlaySoundEnabled()) {
                        EnumItem.NOT_ENOUGH_MYSTERY_DUST.getSound().playSound(player, 1.0f, 0.5f);
                    }
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
                boolean isSuccessful = pManager.removeMysteryDust(purchaseData.getPrice());
                if (!isSuccessful) {
                    player.sendMessage(MessageType.FAILED_TO_DEDUCT_MYSTERY_DUST.getFormatMessage());
                    if (EnumItem.FAILED_TO_DEDUCT_MYSTERY_DUST.isPlaySoundEnabled()) {
                        EnumItem.FAILED_TO_DEDUCT_MYSTERY_DUST.getSound().playSound(player, 1.0f, 0.5f);
                    }
                    player.closeInventory();
                    return;
                }
                GCommandHandler.executeCommand(GadgetsMenu.getGadgetsMenuData().getCosmeticItemPurchaseCommand().replace("{PLAYER}", pManager.getPlayer().getName()).replace("{PERMISSION}", purchaseData.getPermission()));
                if (GadgetsMenu.getGadgetsMenuData().isAutoEquipAfterPurchaseEnabled() || !PermissionUtils.noPermission(player, EnumPermission.AUTO_EQUIP_AFTER_PURCHASE.getPermission(), false)) {
                    purchaseData.equip(player);
                }
                if (EnumItem.ENOUGH_MYSTERY_DUST.isPlaySoundEnabled()) {
                    EnumItem.ENOUGH_MYSTERY_DUST.getSound().playSound(player, 1.0f, 2.0f);
                }
                player.sendMessage(ChatUtil.format(ItemPurchaseMenu.getMessage(player)));
                if (GadgetsMenu.getGadgetsMenuData().isReopenGUIMenuAfterPurchase()) {
                    MainMenuType menu = MainMenuType.valueOf(purchaseData.getCategory().getName());
                    if (menu.isEnabled()) {
                        purchaseData.getCategory().openMenu(player, pManager.getCurrentMenuPageByCategory(purchaseData.getCategory()));
                    }
                } else {
                    player.closeInventory();
                }
                pManager.resetPurchaseData();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.CANCEL_PURCHASE_ITEM.getItemStack(), EnumItem.CANCEL_PURCHASE_ITEM.getSlot())) {
                GadgetsMenu.getPlayerManager(player).resetPurchaseData();
                SoundEffect.ENTITY_ENDERMAN_TELEPORT.playSound(player, 1.0f, 0.5f);
                player.sendMessage(MessageType.PURCHASE_CANCELLED.getFormatMessage());
                event.setCancelled(true);
                player.closeInventory();
                return;
            }
            event.setCancelled(true);
            return;
        }
    }

    private static String getMessage(Player player) {
        Category category = GadgetsMenu.getPlayerManager(player).purchaseData().getCategory();
        String itemDisplayName = GadgetsMenu.getPlayerManager(player).purchaseData().getDisplayName();
        if (category == Category.HATS) {
            return MessageType.PURCHASED_HAT.getFormatMessage().replace("{ITEM}", itemDisplayName);
        }
        if (category == Category.ANIMATED_HATS) {
            return MessageType.PURCHASED_ANIMATED_HAT.getFormatMessage().replace("{ITEM}", itemDisplayName);
        }
        if (category == Category.PARTICLES) {
            return MessageType.PURCHASED_PARTICLE.getFormatMessage().replace("{ITEM}", itemDisplayName);
        }
        if (category == Category.SUITS) {
            return MessageType.PURCHASED_SUIT.getFormatMessage().replace("{ITEM}", itemDisplayName);
        }
        if (category == Category.GADGETS) {
            return MessageType.PURCHASED_GADGET.getFormatMessage().replace("{ITEM}", itemDisplayName);
        }
        if (category == Category.PETS) {
            return MessageType.PURCHASED_PET.getFormatMessage().replace("{ITEM}", itemDisplayName);
        }
        if (category == Category.MORPHS) {
            return MessageType.PURCHASED_MORPH.getFormatMessage().replace("{ITEM}", itemDisplayName);
        }
        if (category == Category.BANNERS) {
            return MessageType.PURCHASED_BANNER.getFormatMessage().replace("{ITEM}", itemDisplayName);
        }
        if (category == Category.EMOTES) {
            return MessageType.PURCHASED_EMOTE.getFormatMessage().replace("{ITEM}", itemDisplayName);
        }
        if (category == Category.CLOAKS) {
            return MessageType.PURCHASED_CLOAK.getFormatMessage().replace("{ITEM}", itemDisplayName);
        }
        return MessageType.FAILED_TO_PURCHASE.getFormatMessage();
    }
}

