/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.menu.menus;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.api.GadgetsMenuAPI;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.MainMenuType;
import com.yapzhenyie.GadgetsMenu.cosmetics.banners.BannerType;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.CloakType;
import com.yapzhenyie.GadgetsMenu.cosmetics.emotes.EmoteType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.animated.AnimatedHatType;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.standard.HatType;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.MorphType;
import com.yapzhenyie.GadgetsMenu.cosmetics.particles.ParticleType;
import com.yapzhenyie.GadgetsMenu.cosmetics.pets.PetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitType;
import com.yapzhenyie.GadgetsMenu.menu.menus.SettingsMenu;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.GDyeColor;
import com.yapzhenyie.GadgetsMenu.utils.GMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.banners.GPattern;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.banners.GPatternType;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.banners.GPatterns;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class MainMenu
implements Listener {
    private static int[] layout;
    private static int invSlot;
    private static int size;

    public MainMenu() {
        size = MainMenuType.enabled().size();
        switch (size) {
            case 11: {
                layout = new int[]{11, 12, 13, 14, 15, 19, 20, 31, 22, 24, 25};
                break;
            }
            case 10: {
                layout = new int[]{9, 11, 13, 15, 17, 27, 29, 31, 33, 35};
                break;
            }
            case 9: {
                layout = new int[]{10, 12, 14, 16, 27, 29, 31, 33, 35};
                break;
            }
            case 8: {
                layout = new int[]{10, 12, 14, 16, 28, 30, 32, 34};
                break;
            }
            case 7: {
                layout = new int[]{11, 13, 15, 28, 30, 32, 34};
                break;
            }
            case 6: {
                layout = new int[]{11, 15, 28, 30, 32, 34};
                break;
            }
            case 5: {
                layout = new int[]{11, 15, 28, 31, 34};
                break;
            }
            case 4: {
                invSlot = 27;
                layout = new int[]{10, 12, 14, 16};
                break;
            }
            case 3: {
                invSlot = 27;
                layout = new int[]{11, 13, 15};
                break;
            }
            case 2: {
                invSlot = 27;
                layout = new int[]{11, 15};
                break;
            }
            case 1: {
                invSlot = 27;
                layout = new int[]{13};
                break;
            }
            default: {
                layout = new int[0];
            }
        }
    }

    public static void openMainMenu(Player player) {
        if (layout.length == MainMenuType.getLayout().length && MainMenu.isSlotAbleToPlace(invSlot, MainMenuType.getLayout())) {
            layout = MainMenuType.getLayout();
        } else {
            FileManager.getMainMenuFile().set("Slot-Layout", MainMenuType.getDefaultLayout());
        }
        int i = 0;
        Inventory invMain = Bukkit.createInventory(null, (int)invSlot, (String)GadgetsMenu.getGadgetsMenuData().getMainMenuGUIName());
        for (int h = 1; h <= size && h <= size; ++h) {
            MainMenuType mainmenu = MainMenuType.enabled().get(h - 1);
            if (mainmenu.getMaterial().getEnumMaterial() == EnumMaterial.CUSTOM_MATERIAL_1) {
                InventoryUtils.inventory(invMain, mainmenu.getDisplayName(), new GMaterial(new GPatterns(GDyeColor.BLACK, Arrays.asList(new GPattern(GDyeColor.YELLOW, GPatternType.STRIPE_RIGHT), new GPattern(GDyeColor.YELLOW, GPatternType.STRIPE_BOTTOM), new GPattern(GDyeColor.YELLOW, GPatternType.STRIPE_MIDDLE), new GPattern(GDyeColor.YELLOW, GPatternType.STRIPE_TOP), new GPattern(GDyeColor.BLACK, GPatternType.CURLY_BORDER), new GPattern(GDyeColor.YELLOW, GPatternType.SQUARE_TOP_LEFT), new GPattern(GDyeColor.YELLOW, GPatternType.SQUARE_BOTTOM_LEFT), new GPattern(GDyeColor.YELLOW, GPatternType.STRIPE_LEFT), new GPattern(GDyeColor.BLACK, GPatternType.BORDER)))), mainmenu.getLore(), MainMenu.getSize(player, mainmenu.getCategory(), EnumItem.UNLOCKED.getLore()), layout[i++]);
                continue;
            }
            InventoryUtils.inventory(invMain, mainmenu.getDisplayName(), mainmenu.getMaterial(), mainmenu.getLore(), MainMenu.getSize(player, mainmenu.getCategory(), EnumItem.UNLOCKED.getLore()), layout[i++]);
        }
        if (EnumItem.RESET_COSMETICS.show()) {
            InventoryUtils.inventory(invMain, EnumItem.RESET_COSMETICS.getItemStack(), invSlot == 54 ? (EnumItem.MAIN_MENU_ITEM.show() ? 50 : 49) : (EnumItem.MAIN_MENU_ITEM.show() ? 23 : 22));
        }
        if (EnumItem.SETTINGS.show()) {
            InventoryUtils.inventory(invMain, EnumItem.SETTINGS.getDisplayName(), EnumItem.SETTINGS.getMaterial(), EnumItem.SETTINGS.getLore(), invSlot == 54 ? 53 : 26);
        }
        if (EnumItem.MAIN_MENU_ITEM.show()) {
            InventoryUtils.mainMenuButton(GadgetsMenu.getPlayerManager(player), invMain, invSlot == 54 ? 49 : 22);
        }
        InventoryUtils.fillItems(invMain);
        player.openInventory(invMain);
    }

    @EventHandler
    public void onInvClickMainMenu(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getView().getTitle().equals(GadgetsMenu.getGadgetsMenuData().getMainMenuGUIName())) {
            if (event.getClickedInventory() == null || event.getClickedInventory().getSize() != invSlot || event.getClickedInventory().getType() != InventoryType.CHEST) {
                event.setCancelled(true);
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || event.getCurrentItem().getItemMeta().getDisplayName() == null) {
                event.setCancelled(true);
                return;
            }
            if (!WorldUtils.isWorldEnabled(player, true)) {
                event.setCancelled(true);
                player.closeInventory();
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT || event.getClick() == ClickType.NUMBER_KEY || event.getClick() == ClickType.UNKNOWN) {
                event.setCancelled(true);
                player.updateInventory();
                return;
            }
            if (event.getCurrentItem().getItemMeta().getDisplayName().equals(EnumItem.RESET_COSMETICS.getDisplayName())) {
                GadgetsMenu.getPlayerManager(player).unequipActiveCosmetics();
                player.sendMessage(MessageType.RESET_COSMETICS.getFormatMessage());
                if (EnumItem.RESET_COSMETICS.isPlaySoundEnabled()) {
                    EnumItem.RESET_COSMETICS.getSound().playSound(player, 1.0f, 2.0f);
                }
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (event.getCurrentItem().getItemMeta().getDisplayName().equals(EnumItem.MAIN_MENU_ITEM.getDisplayName())) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                event.setCancelled(true);
                return;
            }
            if (event.getCurrentItem().getItemMeta().getDisplayName().equals(EnumItem.SETTINGS.getDisplayName())) {
                SettingsMenu.openSettingsMenu(player);
                event.setCancelled(true);
                return;
            }
            for (MainMenuType mainMenu : MainMenuType.values()) {
                if (!event.getCurrentItem().getItemMeta().getDisplayName().equals(ChatUtil.format(mainMenu.getDisplayName()))) continue;
                if (mainMenu.isEnabled()) {
                    mainMenu.getCategory().openMenu(player, 1);
                    continue;
                }
                player.sendMessage(mainMenu.getCategory().getDisabledMessage().getFormatMessage());
            }
            event.setCancelled(true);
            return;
        }
    }

    private static List<String> getSize(Player player, Category category, List<String> lore) {
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        ArrayList<String> itemLore = new ArrayList<String>();
        try {
            for (String s1 : lore) {
                if (s1.contains("{HASPERMISSION}") || s1.contains("{SIZE}") || s1.contains("{PERCENTAGE}")) {
                    int unlocked = 0;
                    int size = 0;
                    switch (category) {
                        case HATS: {
                            unlocked = pManager.getUnlockedHats();
                            size = HatType.enabled().size();
                            break;
                        }
                        case ANIMATED_HATS: {
                            unlocked = pManager.getUnlockedAnimatedHats();
                            size = AnimatedHatType.enabled().size();
                            break;
                        }
                        case PARTICLES: {
                            unlocked = pManager.getUnlockedParticles();
                            size = ParticleType.enabled().size();
                            break;
                        }
                        case SUITS: {
                            unlocked = pManager.getUnlockedSuits();
                            size = SuitType.enabled().size() * 4;
                            break;
                        }
                        case GADGETS: {
                            unlocked = pManager.getUnlockedGadgets();
                            size = GadgetType.enabled().size();
                            break;
                        }
                        case PETS: {
                            unlocked = pManager.getUnlockedPets();
                            size = PetType.enabled().size();
                            break;
                        }
                        case MORPHS: {
                            if (!GadgetsMenu.getGadgetsMenuData().isLibsDisguiseEnabled() && !GadgetsMenu.getGadgetsMenuData().isIDisguiseEnabled()) break;
                            unlocked = pManager.getUnlockedMorphs();
                            size = MorphType.enabled().size();
                            break;
                        }
                        case BANNERS: {
                            unlocked = pManager.getUnlockedBanners();
                            size = BannerType.enabled().size();
                            break;
                        }
                        case EMOTES: {
                            unlocked = pManager.getUnlockedEmotes();
                            size = EmoteType.enabled().size();
                            break;
                        }
                        case CLOAKS: {
                            unlocked = pManager.getUnlockedCloaks();
                            size = CloakType.enabled().size();
                        }
                    }
                    itemLore.add(ChatUtil.format(s1.replace("{HASPERMISSION}", String.valueOf(unlocked)).replace("{SIZE}", String.valueOf(size)).replace("{PERCENTAGE}", String.valueOf(unlocked * 100 / size))));
                    continue;
                }
                itemLore.add(ChatUtil.format(s1));
            }
        }
        catch (ArithmeticException e) {
            for (String s1 : lore) {
                itemLore.add(ChatUtil.format(s1.replace("{HASPERMISSION}", String.valueOf(0)).replace("{SIZE}", String.valueOf(0)).replace("{PERCENTAGE}", String.valueOf(0))));
            }
        }
        return itemLore;
    }

    private static boolean isSlotAbleToPlace(int inventorySize, int[] layout) {
        for (int slot = 0; slot < layout.length; ++slot) {
            if (layout[slot] <= inventorySize - 1) continue;
            return false;
        }
        return true;
    }

    static {
        invSlot = 54;
    }
}

