/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.menu.menus;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.api.GadgetsMenuAPI;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.MorphManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.MorphType;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.GInventory;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.discount.DiscountManager;
import com.yapzhenyie.GadgetsMenu.utils.discount.ItemCostDiscount;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import me.libraryaddict.disguise.DisguiseAPI;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class MorphsMenu
implements Listener {
    public static void openMorphsMenu(Player player) {
        int size = MorphType.enabled().size();
        Inventory invMorphs = Bukkit.createInventory(null, (int)54, (String)Category.MORPHS.getGUIName());
        int i = 0;
        int from = 1;
        int to = 21;
        if (size < 21) {
            to = size;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        for (int h = from; h <= to; ++h) {
            try {
                if (h > size) break;
                MorphType morphs = MorphType.enabled().get(h - 1);
                if (PermissionUtils.noPermission(player, morphs.getPermission(), EnumPermission.MORPHS.getPermission(), false)) {
                    DiscountManager discountManager = new DiscountManager(pManager, Category.MORPHS.isPurchasable() && morphs.isPurchasable(), morphs.getMysteryDust());
                    if (EnumItem.NO_PERMISSION.showCustomItem()) {
                        InventoryUtils.inventory(invMorphs, morphs.getDisplayName(), EnumItem.NO_PERMISSION.getCustomItem(), morphs.getLore(), EnumItem.NO_PERMISSION.isShowInLore() ? EnumItem.NO_PERMISSION.getLore() : null, discountManager.getLore(), GInventory.LAY_OUT_21.getLayOut()[i++]);
                        continue;
                    }
                    InventoryUtils.inventory(invMorphs, morphs.getDisplayName(), morphs.getMaterial(), morphs.getLore(), EnumItem.NO_PERMISSION.isShowInLore() ? EnumItem.NO_PERMISSION.getLore() : null, discountManager.getLore(), GInventory.LAY_OUT_21.getLayOut()[i++]);
                    continue;
                }
                InventoryUtils.inventoryAddGlow(invMorphs, morphs.getDisplayName(), morphs.getMaterial(), morphs.getLore(), EnumItem.HAS_PERMISSION.isShowInLore() ? EnumItem.HAS_PERMISSION.getLore() : null, GInventory.LAY_OUT_21.getLayOut()[i++], pManager.getSelectedMorph() == null ? null : pManager.getSelectedMorph().getDisplayName());
                continue;
            }
            catch (Exception e) {
                player.sendMessage(MessageType.ERROR.getFormatMessage());
                e.printStackTrace();
                return;
            }
        }
        if (EnumItem.RESET_MORPH.show()) {
            InventoryUtils.inventory(invMorphs, EnumItem.RESET_MORPH.getItemStack(), EnumItem.RESET_MORPH.getSlot());
        }
        if (EnumItem.GO_BACK.show()) {
            InventoryUtils.inventory(invMorphs, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot());
        }
        if (EnumItem.SELF_MORPH_VIEW.show() && GadgetsMenu.getGadgetsMenuData().isLibsDisguiseEnabled() && GadgetsMenu.getGadgetsMenuData().isSelfMorphViewEnabled()) {
            InventoryUtils.inventory(invMorphs, EnumItem.SELF_MORPH_VIEW.getItemStack(), "{STATUS}", pManager.canSeeSelfMorph() ? MessageType.ENABLED.getFormatMessage() : MessageType.DISABLED.getFormatMessage(), EnumItem.SELF_MORPH_VIEW.getSlot());
        }
        if (EnumItem.MAIN_MENU_ITEM.show()) {
            InventoryUtils.mainMenuButton(pManager, invMorphs, EnumItem.MAIN_MENU_ITEM.getSlot());
        }
        InventoryUtils.fillItems(invMorphs);
        player.openInventory(invMorphs);
    }

    @EventHandler
    public void onInvClickMorphs(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getView().getTitle().equals(Category.MORPHS.getGUIName())) {
            if (event.getClickedInventory() == null || event.getClickedInventory().getSize() != 54 || event.getClickedInventory().getType() != InventoryType.CHEST) {
                event.setCancelled(true);
                return;
            }
            if (!Category.MORPHS.isEnabled() || !WorldUtils.isWorldEnabled(player, true)) {
                event.setCancelled(true);
                player.closeInventory();
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || event.getCurrentItem().getItemMeta().getDisplayName() == null) {
                event.setCancelled(true);
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT || event.getClick() == ClickType.NUMBER_KEY || event.getClick() == ClickType.UNKNOWN) {
                event.setCancelled(true);
                player.updateInventory();
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot())) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                event.setCancelled(true);
                return;
            }
            PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
            if (ItemUtils.getCurrentItem(event, EnumItem.RESET_MORPH.getItemStack(), EnumItem.RESET_MORPH.getSlot())) {
                if (GadgetsMenu.getGadgetsMenuData().isLibsDisguiseEnabled() && !DisguiseAPI.isDisguised((Entity)player)) {
                    player.sendMessage(MessageType.IS_NOT_MORPHED.getFormatMessage());
                    if (EnumItem.NO_PERMISSION.isPlaySoundEnabled()) {
                        EnumItem.NO_PERMISSION.getSound().playSound(player, 1.0f, 0.5f);
                    }
                } else {
                    pManager.unequipMorph();
                    player.sendMessage(MessageType.RESET_MORPH.getFormatMessage());
                    if (EnumItem.RESET_MORPH.isPlaySoundEnabled()) {
                        EnumItem.RESET_MORPH.getSound().playSound(player, 1.0f, 2.0f);
                    }
                }
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.MAIN_MENU_ITEM.getDisplayName(), EnumItem.MAIN_MENU_ITEM.getSlot())) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.SELF_MORPH_VIEW.getDisplayName(), EnumItem.SELF_MORPH_VIEW.getSlot())) {
                if (!GadgetsMenu.getGadgetsMenuData().isSelfMorphViewEnabled()) {
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
                pManager.setSeeSelfMorph(!pManager.canSeeSelfMorph());
                MorphsMenu.openMorphsMenu(player);
                event.setCancelled(true);
                return;
            }
            for (MorphType morph : MorphType.values()) {
                if (!event.getCurrentItem().getItemMeta().getDisplayName().equals(ChatUtil.format(morph.getDisplayName()))) continue;
                if (PermissionUtils.noPermission(player, morph.getPermission(), EnumPermission.MORPHS.getPermission(), false)) {
                    if (Category.MORPHS.isPurchasable()) {
                        if (!morph.isPurchasable()) {
                            player.sendMessage(MessageType.ITEM_UNPURCHASABLE.getFormatMessage());
                            if (EnumItem.ITEM_UNPURCHASABLE.isPlaySoundEnabled()) {
                                EnumItem.ITEM_UNPURCHASABLE.getSound().playSound(player, 1.0f, 0.5f);
                            }
                            player.closeInventory();
                            event.setCancelled(true);
                            return;
                        }
                        ItemCostDiscount discount = pManager.getItemCostDiscount();
                        int discountedPrice = morph.getMysteryDust();
                        if (discount != null) {
                            discountedPrice = discount.getPriceAfterDiscount(morph.getMysteryDust());
                        }
                        if (pManager.getMysteryDust() >= discountedPrice) {
                            pManager.purchaseData().setData(Category.MORPHS, morph.getName(), morph.getDisplayName(), discount, morph.getMysteryDust(), morph.getPermission());
                            pManager.openItemPurchaseMenu();
                        } else {
                            player.sendMessage(MessageType.NOT_ENOUGH_MYSTERY_DUST_TO_PURCHASE.getFormatMessage());
                            if (EnumItem.NOT_ENOUGH_MYSTERY_DUST.isPlaySoundEnabled()) {
                                EnumItem.NOT_ENOUGH_MYSTERY_DUST.getSound().playSound(player, 1.0f, 0.5f);
                            }
                            player.closeInventory();
                        }
                        event.setCancelled(true);
                        return;
                    }
                    if (!PermissionUtils.noPermission(player, morph.getPermission(), EnumPermission.MORPHS.getPermission(), true)) continue;
                    if (EnumItem.NO_PERMISSION.isPlaySoundEnabled()) {
                        EnumItem.NO_PERMISSION.getSound().playSound(player, 1.0f, 0.5f);
                    }
                    if (EnumItem.NO_PERMISSION.isCloseGUIMenuAfterSelect()) {
                        player.closeInventory();
                    }
                    event.setCancelled(true);
                    continue;
                }
                try {
                    if (pManager.getSelectedMorph() != null && ChatUtil.format(morph.getDisplayName()).equals(pManager.getSelectedMorph().getDisplayName())) {
                        pManager.unequipMorph();
                        player.sendMessage(MessageType.RESET_MORPH.getFormatMessage());
                        if (EnumItem.RESET_MORPH.isPlaySoundEnabled()) {
                            EnumItem.RESET_MORPH.getSound().playSound(player, 1.0f, 2.0f);
                        }
                        player.closeInventory();
                        event.setCancelled(true);
                        return;
                    }
                    if (!MorphManager.checkRequirement(player, morph)) {
                        player.closeInventory();
                        event.setCancelled(true);
                        return;
                    }
                    pManager.equipMorph(morph);
                    player.sendMessage(MessageType.SELECT_MORPH.getFormatMessage().replace("{MORPH}", morph.getDisplayNameStripColor()));
                    if (EnumItem.HAS_PERMISSION.isPlaySoundEnabled()) {
                        EnumItem.HAS_PERMISSION.getSound().playSound(player, 1.0f, 2.0f);
                    }
                    if (EnumItem.HAS_PERMISSION.isCloseGUIMenuAfterSelect()) {
                        player.closeInventory();
                    } else {
                        MorphsMenu.openMorphsMenu(player);
                    }
                    event.setCancelled(true);
                    return;
                }
                catch (Exception Ex) {
                    player.sendMessage(MessageType.ERROR.getFormatMessage());
                    Ex.printStackTrace();
                }
            }
            event.setCancelled(true);
            return;
        }
    }
}

