/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.menu.menus;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.api.GadgetsMenuAPI;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.particles.ParticleManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.particles.ParticleType;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.GInventory;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.StringUtils;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.discount.DiscountManager;
import com.yapzhenyie.GadgetsMenu.utils.discount.ItemCostDiscount;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class ParticlesMenu
implements Listener {
    public static void openParticlesMenu(Player player, int page) {
        int size = ParticleType.enabled().size();
        int maxPages = GInventory.getMaxPagesAmount(21, size);
        if (page <= 0) {
            page = 1;
        }
        if (page > 1 && maxPages < page) {
            page = 1;
        }
        Inventory invParticles = Bukkit.createInventory(null, (int)54, (String)ChatUtil.format(Category.PARTICLES.getGUIName() + StringUtils.addPlaceholders(EnumItem.PAGES.getDisplayName(), Arrays.asList("{CURRENT_PAGE}", "{MAX_PAGES}"), Arrays.asList(String.valueOf(page), String.valueOf(maxPages)))));
        int i = 0;
        int from = 1;
        if (page > 1) {
            from = 21 * (page - 1) + 1;
        }
        int to = 21;
        if (size < 21) {
            to = size;
        }
        if (page > 1) {
            to = size >= 21 * page ? 21 * page : size;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        for (int h = from; h <= to; ++h) {
            try {
                if (h > size) break;
                ParticleType particles = ParticleType.enabled().get(h - 1);
                if (PermissionUtils.noPermission(player, particles.getPermission(), EnumPermission.PARTICLES.getPermission(), false)) {
                    DiscountManager discountManager = new DiscountManager(pManager, Category.PARTICLES.isPurchasable() && particles.isPurchasable(), particles.getMysteryDust());
                    if (EnumItem.NO_PERMISSION.showCustomItem()) {
                        InventoryUtils.inventory(invParticles, particles.getDisplayName(), EnumItem.NO_PERMISSION.getCustomItem(), particles.getLore(), EnumItem.NO_PERMISSION.isShowInLore() ? EnumItem.NO_PERMISSION.getLore() : null, discountManager.getLore(), GInventory.LAY_OUT_21.getLayOut()[i++]);
                        continue;
                    }
                    InventoryUtils.inventory(invParticles, particles.getDisplayName(), particles.getMaterial(), particles.getLore(), EnumItem.NO_PERMISSION.isShowInLore() ? EnumItem.NO_PERMISSION.getLore() : null, discountManager.getLore(), GInventory.LAY_OUT_21.getLayOut()[i++]);
                    continue;
                }
                InventoryUtils.inventoryAddGlow(invParticles, particles.getDisplayName(), particles.getMaterial(), particles.getLore(), EnumItem.HAS_PERMISSION.isShowInLore() ? EnumItem.HAS_PERMISSION.getLore() : null, GInventory.LAY_OUT_21.getLayOut()[i++], pManager.getSelectedParticle() == null ? null : pManager.getSelectedParticle().getDisplayName());
                continue;
            }
            catch (Exception Ex) {
                player.sendMessage(MessageType.ERROR.getFormatMessage());
                Ex.printStackTrace();
                return;
            }
        }
        if (EnumItem.RESET_PARTICLE.show()) {
            InventoryUtils.inventory(invParticles, EnumItem.RESET_PARTICLE.getItemStack(), EnumItem.RESET_PARTICLE.getSlot());
        }
        if (page == 1) {
            if (EnumItem.GO_BACK.show()) {
                InventoryUtils.inventory(invParticles, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot());
            }
        } else {
            InventoryUtils.inventory(invParticles, EnumItem.PREVIOUS_PAGE.getItemStack(), "{PAGE}", String.valueOf(page - 1), EnumItem.PREVIOUS_PAGE.getSlot());
        }
        if (page < maxPages) {
            InventoryUtils.inventory(invParticles, EnumItem.NEXT_PAGE.getItemStack(), "{PAGE}", String.valueOf(page + 1), EnumItem.NEXT_PAGE.getSlot());
        }
        if (EnumItem.MAIN_MENU_ITEM.show()) {
            InventoryUtils.mainMenuButton(pManager, invParticles, EnumItem.MAIN_MENU_ITEM.getSlot());
        }
        InventoryUtils.fillItems(invParticles);
        player.openInventory(invParticles);
        pManager.setCurrentParticlesPage(page);
    }

    @EventHandler
    public void onInvClickParticles(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getView().getTitle().startsWith(Category.PARTICLES.getGUIName())) {
            if (event.getClickedInventory() == null || event.getClickedInventory().getSize() != 54 || event.getClickedInventory().getType() != InventoryType.CHEST) {
                event.setCancelled(true);
                return;
            }
            if (!Category.PARTICLES.isEnabled() || !WorldUtils.isWorldEnabled(player, true)) {
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || event.getCurrentItem().getItemMeta().getDisplayName() == null) {
                event.setCancelled(true);
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT || event.getClick() == ClickType.NUMBER_KEY || event.getClick() == ClickType.UNKNOWN) {
                player.updateInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot())) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                event.setCancelled(true);
                return;
            }
            PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
            if (ItemUtils.getCurrentItem(event, EnumItem.RESET_PARTICLE.getItemStack(), EnumItem.RESET_PARTICLE.getSlot())) {
                pManager.unequipParticle();
                player.sendMessage(MessageType.RESET_PARTICLE.getFormatMessage());
                if (EnumItem.RESET_PARTICLE.isPlaySoundEnabled()) {
                    EnumItem.RESET_PARTICLE.getSound().playSound(player, 1.0f, 2.0f);
                }
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.PREVIOUS_PAGE.getDisplayName(), EnumItem.PREVIOUS_PAGE.getSlot())) {
                ParticlesMenu.openParticlesMenu(player, pManager.getCurrentParticlesPage() - 1);
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.NEXT_PAGE.getDisplayName(), EnumItem.NEXT_PAGE.getSlot())) {
                ParticlesMenu.openParticlesMenu(player, pManager.getCurrentParticlesPage() + 1);
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.MAIN_MENU_ITEM.getDisplayName(), EnumItem.MAIN_MENU_ITEM.getSlot())) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                event.setCancelled(true);
                return;
            }
            for (ParticleType particle : ParticleType.values()) {
                if (!event.getCurrentItem().getItemMeta().getDisplayName().equals(ChatUtil.format(particle.getDisplayName()))) continue;
                if (PermissionUtils.noPermission(player, particle.getPermission(), EnumPermission.PARTICLES.getPermission(), false)) {
                    if (Category.PARTICLES.isPurchasable()) {
                        if (!particle.isPurchasable()) {
                            player.sendMessage(MessageType.ITEM_UNPURCHASABLE.getFormatMessage());
                            if (EnumItem.ITEM_UNPURCHASABLE.isPlaySoundEnabled()) {
                                EnumItem.ITEM_UNPURCHASABLE.getSound().playSound(player, 1.0f, 0.5f);
                            }
                            player.closeInventory();
                            event.setCancelled(true);
                            return;
                        }
                        ItemCostDiscount discount = pManager.getItemCostDiscount();
                        int discountedPrice = particle.getMysteryDust();
                        if (discount != null) {
                            discountedPrice = discount.getPriceAfterDiscount(particle.getMysteryDust());
                        }
                        if (pManager.getMysteryDust() >= discountedPrice) {
                            pManager.purchaseData().setData(Category.PARTICLES, particle.getName(), particle.getDisplayName(), discount, particle.getMysteryDust(), particle.getPermission());
                            pManager.openItemPurchaseMenu();
                        } else {
                            player.sendMessage(MessageType.NOT_ENOUGH_MYSTERY_DUST_TO_PURCHASE.getFormatMessage());
                            if (EnumItem.NOT_ENOUGH_MYSTERY_DUST.isPlaySoundEnabled()) {
                                EnumItem.NOT_ENOUGH_MYSTERY_DUST.getSound().playSound(player, 1.0f, 0.5f);
                            }
                            player.closeInventory();
                        }
                        event.setCancelled(true);
                        return;
                    }
                    if (PermissionUtils.noPermission(player, particle.getPermission(), EnumPermission.PARTICLES.getPermission(), true)) {
                        if (EnumItem.NO_PERMISSION.isPlaySoundEnabled()) {
                            EnumItem.NO_PERMISSION.getSound().playSound(player, 1.0f, 0.5f);
                        }
                        if (EnumItem.NO_PERMISSION.isCloseGUIMenuAfterSelect()) {
                            player.closeInventory();
                        }
                    }
                    event.setCancelled(true);
                    return;
                }
                try {
                    if (pManager.getSelectedParticle() != null && ChatUtil.format(particle.getDisplayName()).equals(pManager.getSelectedParticle().getDisplayName())) {
                        pManager.unequipParticle();
                        player.sendMessage(MessageType.RESET_PARTICLE.getFormatMessage());
                        if (EnumItem.RESET_PARTICLE.isPlaySoundEnabled()) {
                            EnumItem.RESET_PARTICLE.getSound().playSound(player, 1.0f, 2.0f);
                        }
                        player.closeInventory();
                        event.setCancelled(true);
                        return;
                    }
                    if (!ParticleManager.checkRequirement(player, particle)) {
                        player.closeInventory();
                        event.setCancelled(true);
                        return;
                    }
                    pManager.equipParticle(particle);
                    player.sendMessage(MessageType.SELECT_PARTICLE.getFormatMessage().replace("{PARTICLE}", particle.getDisplayNameStripColor()));
                    if (EnumItem.HAS_PERMISSION.isPlaySoundEnabled()) {
                        EnumItem.HAS_PERMISSION.getSound().playSound(player, 1.0f, 2.0f);
                    }
                    if (EnumItem.HAS_PERMISSION.isCloseGUIMenuAfterSelect()) {
                        player.closeInventory();
                    } else {
                        ParticlesMenu.openParticlesMenu(player, pManager.getCurrentParticlesPage());
                    }
                    event.setCancelled(true);
                    return;
                }
                catch (Exception Ex) {
                    player.sendMessage(MessageType.ERROR.getFormatMessage());
                    Ex.printStackTrace();
                }
            }
            event.setCancelled(true);
            return;
        }
    }
}

