/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.menu.menus;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.api.GadgetsMenuAPI;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class SettingsMenu
implements Listener {
    public static void openSettingsMenu(Player player) {
        Inventory invSettings = Bukkit.createInventory(null, (int)54, (String)GadgetsMenu.getGadgetsMenuData().getSettingGUIName());
        if (EnumItem.SETTINGS_IGNORE_COOLDOWN.show()) {
            InventoryUtils.inventory(invSettings, EnumItem.SETTINGS_IGNORE_COOLDOWN.getItemStack(), EnumItem.SETTINGS_IGNORE_COOLDOWN.getSlot());
            InventoryUtils.inventory(invSettings, GadgetsMenu.getPlayerManager(player).isBypassCooldown() ? EnumItem.SETTINGS_ENABLED.getItemStack() : EnumItem.SETTINGS_DISABLED.getItemStack(), InventoryUtils.findSlotBelowItem(EnumItem.SETTINGS_IGNORE_COOLDOWN.getSlot(), 54));
        }
        if (EnumItem.SETTINGS_SELF_MORPH_VIEW.show()) {
            InventoryUtils.inventory(invSettings, EnumItem.SETTINGS_SELF_MORPH_VIEW.getItemStack(), EnumItem.SETTINGS_SELF_MORPH_VIEW.getSlot());
            InventoryUtils.inventory(invSettings, GadgetsMenu.getPlayerManager(player).canSeeSelfMorph() ? EnumItem.SETTINGS_ENABLED.getItemStack() : EnumItem.SETTINGS_DISABLED.getItemStack(), InventoryUtils.findSlotBelowItem(EnumItem.SETTINGS_SELF_MORPH_VIEW.getSlot(), 54));
        }
        if (EnumItem.GO_BACK.show()) {
            InventoryUtils.inventory(invSettings, EnumItem.GO_BACK.getItemStack(), 45);
        }
        if (EnumItem.MAIN_MENU_ITEM.show()) {
            InventoryUtils.mainMenuButton(GadgetsMenu.getPlayerManager(player), invSettings, EnumItem.MAIN_MENU_ITEM.getSlot());
        }
        InventoryUtils.fillItems(invSettings);
        player.openInventory(invSettings);
    }

    @EventHandler
    public void onInvClickSettingsMenu(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getView().getTitle().equals(GadgetsMenu.getGadgetsMenuData().getSettingGUIName())) {
            if (event.getClickedInventory() == null || event.getClickedInventory().getSize() != 54 || event.getClickedInventory().getType() != InventoryType.CHEST) {
                event.setCancelled(true);
                return;
            }
            if (!WorldUtils.isWorldEnabled(player, true)) {
                event.setCancelled(true);
                player.closeInventory();
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || event.getCurrentItem().getItemMeta().getDisplayName() == null) {
                event.setCancelled(true);
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT || event.getClick() == ClickType.NUMBER_KEY || event.getClick() == ClickType.UNKNOWN) {
                event.setCancelled(true);
                player.updateInventory();
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.GO_BACK.getItemStack(), 45)) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.MAIN_MENU_ITEM.getDisplayName(), EnumItem.MAIN_MENU_ITEM.getSlot())) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.SETTINGS_ENABLED.getItemStack(), InventoryUtils.findSlotBelowItem(EnumItem.SETTINGS_IGNORE_COOLDOWN.getSlot(), 54))) {
                if (!PermissionUtils.noPermission(player, EnumPermission.BYPASS_COOLDOWN.getPermission(), true)) {
                    GadgetsMenu.getPlayerManager(player).setBypassCooldown(false);
                    SettingsMenu.openSettingsMenu(player);
                    event.setCancelled(true);
                    return;
                }
                if (EnumItem.NO_PERMISSION.isPlaySoundEnabled()) {
                    EnumItem.NO_PERMISSION.getSound().playSound(player, 1.0f, 0.5f);
                }
                if (EnumItem.NO_PERMISSION.isCloseGUIMenuAfterSelect()) {
                    player.closeInventory();
                }
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.SETTINGS_DISABLED.getItemStack(), InventoryUtils.findSlotBelowItem(EnumItem.SETTINGS_IGNORE_COOLDOWN.getSlot(), 54))) {
                if (!PermissionUtils.noPermission(player, EnumPermission.BYPASS_COOLDOWN.getPermission(), true)) {
                    GadgetsMenu.getPlayerManager(player).setBypassCooldown(true);
                    SettingsMenu.openSettingsMenu(player);
                    event.setCancelled(true);
                    return;
                }
                if (EnumItem.NO_PERMISSION.isPlaySoundEnabled()) {
                    EnumItem.NO_PERMISSION.getSound().playSound(player, 1.0f, 0.5f);
                }
                if (EnumItem.NO_PERMISSION.isCloseGUIMenuAfterSelect()) {
                    player.closeInventory();
                }
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.SETTINGS_ENABLED.getItemStack(), InventoryUtils.findSlotBelowItem(EnumItem.SETTINGS_SELF_MORPH_VIEW.getSlot(), 54))) {
                if (!GadgetsMenu.getGadgetsMenuData().isSelfMorphViewEnabled()) {
                    player.sendMessage(MessageType.DISABLED_SELF_MORPH_VIEW.getFormatMessage());
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
                GadgetsMenu.getPlayerManager(player).setSeeSelfMorph(false);
                SettingsMenu.openSettingsMenu(player);
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.SETTINGS_DISABLED.getItemStack(), InventoryUtils.findSlotBelowItem(EnumItem.SETTINGS_SELF_MORPH_VIEW.getSlot(), 54))) {
                if (!GadgetsMenu.getGadgetsMenuData().isSelfMorphViewEnabled()) {
                    player.sendMessage(MessageType.DISABLED_SELF_MORPH_VIEW.getFormatMessage());
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
                GadgetsMenu.getPlayerManager(player).setSeeSelfMorph(true);
                SettingsMenu.openSettingsMenu(player);
                event.setCancelled(true);
                return;
            }
            event.setCancelled(true);
        }
    }
}

