/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.menu.menus;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.api.GadgetsMenuAPI;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitEquipmentType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitType;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumArmorType;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.discount.DiscountManager;
import com.yapzhenyie.GadgetsMenu.utils.discount.ItemCostDiscount;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class SuitEquipmentMenu
implements Listener {
    private static int[] INVENTORY_SLOTS = new int[]{4, 13, 22, 31};

    public static void openSuitEquipmentMenu(Player player, String group) {
        Inventory invSuitEquipment = Bukkit.createInventory(null, (int)54, (String)ChatUtil.format(SuitType.valueOf(group).getDisplayNameStripColor()));
        List<SuitEquipmentType> suitGroup = SuitEquipmentType.getGroup(group);
        int slot = 0;
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        for (int i = 0; i <= 3; ++i) {
            SuitEquipmentType equipment = suitGroup.get(i);
            if (PermissionUtils.noPermission(player, equipment.getPermission(), EnumPermission.SUITS.getPermission(), false)) {
                DiscountManager discountManager = new DiscountManager(pManager, Category.SUITS.isPurchasable() && equipment.isPurchasable(), equipment.getMysteryDust());
                if (EnumItem.NO_PERMISSION.showCustomItem()) {
                    InventoryUtils.inventory(invSuitEquipment, equipment.getDisplayName(), EnumItem.NO_PERMISSION.getCustomItem(), equipment.getLore(), EnumItem.NO_PERMISSION.isShowInLore() ? EnumItem.NO_PERMISSION.getLore() : null, discountManager.getLore(), INVENTORY_SLOTS[slot++]);
                    continue;
                }
                InventoryUtils.inventory(invSuitEquipment, equipment.getDisplayName(), equipment.getMaterial(), equipment.getLore(), EnumItem.NO_PERMISSION.isShowInLore() ? EnumItem.NO_PERMISSION.getLore() : null, discountManager.getLore(), INVENTORY_SLOTS[slot++]);
                continue;
            }
            InventoryUtils.inventoryAddGlow(invSuitEquipment, equipment.getDisplayName(), equipment.getMaterial(), equipment.getLore(), EnumItem.HAS_PERMISSION.isShowInLore() ? EnumItem.HAS_PERMISSION.getLore() : null, INVENTORY_SLOTS[slot++], pManager.getSelectedSuitEquipment().get((Object)equipment.getArmorType()) == null ? null : pManager.getSelectedSuitEquipment().get((Object)equipment.getArmorType()).getDisplayName());
        }
        if (EnumItem.RESET_SUIT.show()) {
            InventoryUtils.inventory(invSuitEquipment, EnumItem.RESET_SUIT.getItemStack(), EnumItem.RESET_SUIT.getSlot());
        }
        if (EnumItem.GO_BACK.show()) {
            InventoryUtils.inventory(invSuitEquipment, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot());
        }
        if (EnumItem.MAIN_MENU_ITEM.show()) {
            InventoryUtils.mainMenuButton(pManager, invSuitEquipment, EnumItem.MAIN_MENU_ITEM.getSlot());
        }
        InventoryUtils.fillItems(invSuitEquipment);
        player.openInventory(invSuitEquipment);
    }

    @EventHandler
    public void onInvClickSuitEquipment(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        for (SuitEquipmentType.EnumSuitType group : SuitEquipmentType.groups()) {
            if (!event.getView().getTitle().equals(ChatUtil.format(SuitType.valueOf(group.getName()).getDisplayNameStripColor()))) continue;
            if (event.getClickedInventory() == null || event.getClickedInventory().getSize() != 54 || event.getClickedInventory().getType() != InventoryType.CHEST) {
                event.setCancelled(true);
                return;
            }
            if (!Category.SUITS.isEnabled() || !WorldUtils.isWorldEnabled(player, true)) {
                event.setCancelled(true);
                player.closeInventory();
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || event.getCurrentItem().getItemMeta().getDisplayName() == null) {
                event.setCancelled(true);
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT || event.getClick() == ClickType.NUMBER_KEY || event.getClick() == ClickType.UNKNOWN) {
                event.setCancelled(true);
                player.updateInventory();
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot())) {
                GadgetsMenu.getPlayerManager(player).openSuitsMenu();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.RESET_SUIT.getItemStack(), EnumItem.RESET_SUIT.getSlot())) {
                GadgetsMenu.getPlayerManager(player).unequipSuit();
                player.sendMessage(MessageType.RESET_SUIT.getFormatMessage());
                if (EnumItem.RESET_SUIT.isPlaySoundEnabled()) {
                    EnumItem.RESET_SUIT.getSound().playSound(player, 1.0f, 2.0f);
                }
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.MAIN_MENU_ITEM.getDisplayName(), EnumItem.MAIN_MENU_ITEM.getSlot())) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                event.setCancelled(true);
                return;
            }
            for (SuitEquipmentType equipment : SuitEquipmentType.values()) {
                if (!event.getCurrentItem().getItemMeta().getDisplayName().equals(ChatUtil.format(equipment.getDisplayName()))) continue;
                if (PermissionUtils.noPermission(player, equipment.getPermission(), EnumPermission.SUITS.getPermission(), false)) {
                    if (Category.SUITS.isPurchasable()) {
                        if (!equipment.isPurchasable()) {
                            player.sendMessage(MessageType.ITEM_UNPURCHASABLE.getFormatMessage());
                            if (EnumItem.ITEM_UNPURCHASABLE.isPlaySoundEnabled()) {
                                EnumItem.ITEM_UNPURCHASABLE.getSound().playSound(player, 1.0f, 0.5f);
                            }
                            player.closeInventory();
                            event.setCancelled(true);
                            return;
                        }
                        ItemCostDiscount discount = GadgetsMenu.getPlayerManager(player).getItemCostDiscount();
                        int discountedPrice = equipment.getMysteryDust();
                        if (discount != null) {
                            discountedPrice = discount.getPriceAfterDiscount(equipment.getMysteryDust());
                        }
                        if (GadgetsMenu.getPlayerManager(player).getMysteryDust() >= discountedPrice) {
                            GadgetsMenu.getPlayerManager(player).purchaseData().setData(Category.SUITS, equipment.getName(), equipment.getDisplayName(), discount, equipment.getMysteryDust(), equipment.getPermission());
                            GadgetsMenu.getPlayerManager(player).openItemPurchaseMenu();
                        } else {
                            player.sendMessage(MessageType.NOT_ENOUGH_MYSTERY_DUST_TO_PURCHASE.getFormatMessage());
                            if (EnumItem.NOT_ENOUGH_MYSTERY_DUST.isPlaySoundEnabled()) {
                                EnumItem.NOT_ENOUGH_MYSTERY_DUST.getSound().playSound(player, 1.0f, 0.5f);
                            }
                            player.closeInventory();
                        }
                        event.setCancelled(true);
                        return;
                    }
                    if (!PermissionUtils.noPermission(player, equipment.getPermission(), EnumPermission.SUITS.getPermission(), true)) continue;
                    if (EnumItem.NO_PERMISSION.isPlaySoundEnabled()) {
                        EnumItem.NO_PERMISSION.getSound().playSound(player, 1.0f, 0.5f);
                    }
                    if (EnumItem.NO_PERMISSION.isCloseGUIMenuAfterSelect()) {
                        player.closeInventory();
                    }
                    event.setCancelled(true);
                    return;
                }
                try {
                    if (equipment.getArmorType() == EnumArmorType.HELMET) {
                        if (GadgetsMenu.getPlayerManager(player).getSelectedSuitEquipment().get((Object)EnumArmorType.HELMET) != null && ChatUtil.format(equipment.getDisplayName()).equals(GadgetsMenu.getPlayerManager(player).getSelectedSuitEquipment().get((Object)EnumArmorType.HELMET).getDisplayName())) {
                            SuitManager.unequipHelmet(player);
                            player.sendMessage(MessageType.RESET_SUIT_HELMET.getFormatMessage());
                            if (EnumItem.RESET_SUIT.isPlaySoundEnabled()) {
                                EnumItem.RESET_SUIT.getSound().playSound(player, 1.0f, 2.0f);
                            }
                            SuitEquipmentMenu.openSuitEquipmentMenu(player, equipment.getGroup());
                            event.setCancelled(true);
                            return;
                        }
                        if (!SuitManager.checkRequirement(player, equipment)) {
                            player.closeInventory();
                            event.setCancelled(true);
                            return;
                        }
                        GadgetsMenu.getPlayerManager(player).equipSuitEquipment(EnumArmorType.HELMET, equipment);
                    } else if (equipment.getArmorType() == EnumArmorType.CHESTPLATE) {
                        if (GadgetsMenu.getPlayerManager(player).getSelectedSuitEquipment().get((Object)EnumArmorType.CHESTPLATE) != null && ChatUtil.format(equipment.getDisplayName()).equals(GadgetsMenu.getPlayerManager(player).getSelectedSuitEquipment().get((Object)EnumArmorType.CHESTPLATE).getDisplayName())) {
                            SuitManager.unequipChestplate(player);
                            player.sendMessage(MessageType.RESET_SUIT_CHESTPLATE.getFormatMessage());
                            if (EnumItem.RESET_SUIT.isPlaySoundEnabled()) {
                                EnumItem.RESET_SUIT.getSound().playSound(player, 1.0f, 2.0f);
                            }
                            SuitEquipmentMenu.openSuitEquipmentMenu(player, equipment.getGroup());
                            event.setCancelled(true);
                            return;
                        }
                        if (!SuitManager.checkRequirement(player, equipment)) {
                            player.closeInventory();
                            event.setCancelled(true);
                            return;
                        }
                        GadgetsMenu.getPlayerManager(player).equipSuitEquipment(EnumArmorType.CHESTPLATE, equipment);
                    } else if (equipment.getArmorType() == EnumArmorType.LEGGINGS) {
                        if (GadgetsMenu.getPlayerManager(player).getSelectedSuitEquipment().get((Object)EnumArmorType.LEGGINGS) != null && ChatUtil.format(equipment.getDisplayName()).equals(GadgetsMenu.getPlayerManager(player).getSelectedSuitEquipment().get((Object)EnumArmorType.LEGGINGS).getDisplayName())) {
                            SuitManager.unequipLeggings(player);
                            player.sendMessage(MessageType.RESET_SUIT_LEGGINGS.getFormatMessage());
                            if (EnumItem.RESET_SUIT.isPlaySoundEnabled()) {
                                EnumItem.RESET_SUIT.getSound().playSound(player, 1.0f, 2.0f);
                            }
                            SuitEquipmentMenu.openSuitEquipmentMenu(player, equipment.getGroup());
                            event.setCancelled(true);
                            return;
                        }
                        if (!SuitManager.checkRequirement(player, equipment)) {
                            player.closeInventory();
                            event.setCancelled(true);
                            return;
                        }
                        GadgetsMenu.getPlayerManager(player).equipSuitEquipment(EnumArmorType.LEGGINGS, equipment);
                    } else if (equipment.getArmorType() == EnumArmorType.BOOTS) {
                        if (GadgetsMenu.getPlayerManager(player).getSelectedSuitEquipment().get((Object)EnumArmorType.BOOTS) != null && ChatUtil.format(equipment.getDisplayName()).equals(GadgetsMenu.getPlayerManager(player).getSelectedSuitEquipment().get((Object)EnumArmorType.BOOTS).getDisplayName())) {
                            SuitManager.unequipBoots(player);
                            player.sendMessage(MessageType.RESET_SUIT_BOOTS.getFormatMessage());
                            if (EnumItem.RESET_SUIT.isPlaySoundEnabled()) {
                                EnumItem.RESET_SUIT.getSound().playSound(player, 1.0f, 2.0f);
                            }
                            SuitEquipmentMenu.openSuitEquipmentMenu(player, equipment.getGroup());
                            event.setCancelled(true);
                            return;
                        }
                        if (!SuitManager.checkRequirement(player, equipment)) {
                            player.closeInventory();
                            event.setCancelled(true);
                            return;
                        }
                        GadgetsMenu.getPlayerManager(player).equipSuitEquipment(EnumArmorType.BOOTS, equipment);
                    }
                    player.sendMessage(MessageType.SELECT_SUIT.getFormatMessage().replace("{SUIT}", equipment.getDisplayNameStripColor()));
                    if (EnumItem.HAS_PERMISSION.isPlaySoundEnabled()) {
                        EnumItem.HAS_PERMISSION.getSound().playSound(player, 1.0f, 2.0f);
                    }
                    SuitEquipmentMenu.openSuitEquipmentMenu(player, equipment.getGroup());
                    event.setCancelled(true);
                    return;
                }
                catch (Exception Ex) {
                    player.sendMessage(MessageType.ERROR.getFormatMessage());
                    Ex.printStackTrace();
                }
            }
            event.setCancelled(true);
            return;
        }
    }
}

