/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.menu.menus.mysteryboxes;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.discount.DiscountManager;
import com.yapzhenyie.GadgetsMenu.utils.discount.ItemCostDiscount;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.CraftMysteryBoxType;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.MysteryBoxType;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.MysteryBoxCraftingDate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class MysteryBoxesCraftingMenu
implements Listener {
    public static void openMysteryBoxesCraftingMenu(Player player) {
        Inventory invCraftMysteryBox = Bukkit.createInventory(null, (int)36, (String)GadgetsMenu.getGadgetsMenuData().getMysteryBoxCraftingGUIName());
        for (int i = 1; i <= 5; ++i) {
            CraftMysteryBoxType craftMysteryBox = CraftMysteryBoxType.valueOf(i);
            if (!craftMysteryBox.isShow()) continue;
            DiscountManager discount = new DiscountManager(GadgetsMenu.getPlayerManager(player), craftMysteryBox.getLore(), craftMysteryBox.getPrice());
            InventoryUtils.inventory(invCraftMysteryBox, craftMysteryBox.getDisplayName(), craftMysteryBox.getMaterial(), discount.getLore(), craftMysteryBox.getSlot());
        }
        if (EnumItem.GO_BACK.show()) {
            InventoryUtils.inventory(invCraftMysteryBox, EnumItem.GO_BACK.getItemStack(), 31);
        }
        InventoryUtils.fillItems(invCraftMysteryBox);
        player.openInventory(invCraftMysteryBox);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInvClickMysteryBoxCraftingMenu(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getView().getTitle().equals(GadgetsMenu.getGadgetsMenuData().getMysteryBoxCraftingGUIName())) {
            if (event.getClickedInventory() == null || event.getClickedInventory().getSize() != 36 || event.getClickedInventory().getType() != InventoryType.CHEST) {
                event.setCancelled(true);
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || event.getCurrentItem().getItemMeta().getDisplayName() == null) {
                event.setCancelled(true);
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT || event.getClick() == ClickType.NUMBER_KEY || event.getClick() == ClickType.UNKNOWN) {
                player.updateInventory();
                event.setCancelled(true);
                return;
            }
            if (!GadgetsMenu.getGadgetsMenuData().isMysteryBoxesEnabled() || !WorldUtils.isWorldEnabled(player, true)) {
                SoundEffect.ENTITY_ENDERMAN_TELEPORT.playSound(player, 1.0f, 0.5f);
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.GO_BACK.getItemStack(), 31)) {
                GadgetsMenu.getPlayerManager(player).openMysteryVaultMenu(1);
                event.setCancelled(true);
                return;
            }
            for (int i = 1; i <= 5; ++i) {
                CraftMysteryBoxType craftMysteryBox = CraftMysteryBoxType.valueOf(i);
                if (!ItemUtils.getCurrentItem(event, craftMysteryBox.getDisplayName(), craftMysteryBox.getSlot())) continue;
                ItemCostDiscount discount = GadgetsMenu.getPlayerManager(player).getItemCostDiscount();
                int discountedPrice = craftMysteryBox.getPrice();
                if (discount != null) {
                    discountedPrice = discount.getPriceAfterDiscount(craftMysteryBox.getPrice());
                }
                if (GadgetsMenu.getPlayerManager(player).getMysteryDust() < discountedPrice) {
                    player.sendMessage(MessageType.NOT_ENOUGH_MYSTERY_DUST_TO_PURCHASE.getFormatMessage());
                    if (EnumItem.NOT_ENOUGH_MYSTERY_DUST_TO_CRAFT_MYSTERY_BOX.isPlaySoundEnabled()) {
                        EnumItem.NOT_ENOUGH_MYSTERY_DUST_TO_CRAFT_MYSTERY_BOX.getSound().playSound(player, 1.0f, 0.5f);
                    }
                    event.setCancelled(true);
                    return;
                }
                boolean isSuccessful = GadgetsMenu.getPlayerManager(player).removeMysteryDust(discountedPrice);
                if (!isSuccessful) {
                    player.sendMessage(MessageType.FAILED_TO_DEDUCT_MYSTERY_DUST.getFormatMessage());
                    if (EnumItem.FAILED_TO_DEDUCT_MYSTERY_DUST.isPlaySoundEnabled()) {
                        EnumItem.FAILED_TO_DEDUCT_MYSTERY_DUST.getSound().playSound(player, 1.0f, 0.5f);
                    }
                    player.closeInventory();
                    return;
                }
                MysteryBoxType boxType = MysteryBoxType.valueOfByName("Crafted Mystery Box #" + i);
                String date = new MysteryBoxCraftingDate().getDate();
                GadgetsMenu.getPlayerManager(player).giveMysteryBoxes(boxType, null, false, date, 1);
                player.sendMessage(MessageType.CRAFTED_MYSTERY_BOX.getFormatMessage().replace("{NAME}", ChatUtil.stripColor(craftMysteryBox.getDisplayName())).replace("{NAME_COLOR}", craftMysteryBox.getDisplayName()));
                SoundEffect.ENTITY_EXPERIENCE_ORB_PICKUP.playSound(player, 1.0f, 2.0f);
                MysteryBoxesCraftingMenu.openMysteryBoxesCraftingMenu(player);
                event.setCancelled(true);
                return;
            }
            event.setCancelled(true);
            return;
        }
    }
}

