/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.mysteryboxes;

import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.banners.BannerManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.banners.BannerType;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.CloakManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.CloakType;
import com.yapzhenyie.GadgetsMenu.cosmetics.emotes.EmoteManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.emotes.EmoteType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.animated.AnimatedHatManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.animated.AnimatedHatType;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.standard.HatManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.standard.HatType;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.MorphManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.MorphType;
import com.yapzhenyie.GadgetsMenu.cosmetics.particles.ParticleManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.particles.ParticleType;
import com.yapzhenyie.GadgetsMenu.cosmetics.pets.PetManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.pets.PetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitEquipmentType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitType;
import com.yapzhenyie.GadgetsMenu.log.LoggerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumArmorType;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Rarity;
import org.bukkit.entity.Player;

public class MysteryBoxesLoot {
    private Rarity rarity;
    private Category category;
    private String name;
    private String displayName = null;
    private String permission = null;
    private int mysteryDust;

    public MysteryBoxesLoot(Rarity rarity, Category category, String name) {
        this.rarity = rarity;
        this.category = category;
        this.name = name;
        if (this.category.equals((Object)Category.HATS)) {
            HatType type = HatType.valueOf(name);
            if (type == null) {
                this.displayName = null;
            } else if (type.isEnabled() && type.canBeFound()) {
                this.displayName = type.getDisplayName();
                this.permission = type.getPermission();
                this.mysteryDust = type.getMysteryDust();
            }
        } else if (this.category.equals((Object)Category.ANIMATED_HATS)) {
            AnimatedHatType type = AnimatedHatType.valueOf(name);
            if (type == null) {
                this.displayName = null;
            } else if (type.isEnabled() && type.canBeFound()) {
                this.displayName = type.getDisplayName();
                this.permission = type.getPermission();
                this.mysteryDust = type.getMysteryDust();
            }
        } else if (this.category.equals((Object)Category.PARTICLES)) {
            ParticleType type = ParticleType.valueOf(name);
            if (type == null) {
                this.displayName = null;
            } else if (type.isEnabled() && type.canBeFound()) {
                this.displayName = type.getDisplayName();
                this.permission = type.getPermission();
                this.mysteryDust = type.getMysteryDust();
            }
        } else if (this.category.equals((Object)Category.SUITS)) {
            SuitEquipmentType type = SuitEquipmentType.valueOf(name);
            if (type == null) {
                this.displayName = null;
            } else {
                SuitType suit = SuitType.valueOf(type.getGroup());
                if (suit.isEnabled() && type.canBeFound()) {
                    this.displayName = type.getDisplayName();
                    this.permission = type.getPermission();
                    this.mysteryDust = type.getMysteryDust();
                }
            }
        } else if (this.category.equals((Object)Category.GADGETS)) {
            GadgetType type = GadgetType.valueOf(name);
            if (type == null) {
                this.displayName = null;
            } else if (type.isEnabled() && type.canBeFound()) {
                this.displayName = type.getDisplayName();
                this.permission = type.getPermission();
                this.mysteryDust = type.getMysteryDust();
            }
        } else if (this.category.equals((Object)Category.PETS)) {
            PetType type = PetType.valueOf(name);
            if (type == null) {
                this.displayName = null;
            } else if (type.isEnabled() && type.canBeFound()) {
                this.displayName = type.getDisplayName();
                this.permission = type.getPermission();
                this.mysteryDust = type.getMysteryDust();
            }
        } else if (this.category.equals((Object)Category.MORPHS)) {
            MorphType type = MorphType.valueOf(name);
            if (type == null) {
                this.displayName = null;
            } else if (type.isEnabled() && type.canBeFound()) {
                this.displayName = type.getDisplayName();
                this.permission = type.getPermission();
                this.mysteryDust = type.getMysteryDust();
            }
        } else if (this.category.equals((Object)Category.BANNERS)) {
            BannerType type = BannerType.valueOf(name);
            if (type == null) {
                this.displayName = null;
            } else if (type.isEnabled() && type.canBeFound()) {
                this.displayName = type.getDisplayName();
                this.permission = type.getPermission();
                this.mysteryDust = type.getMysteryDust();
            }
        } else if (this.category.equals((Object)Category.EMOTES)) {
            EmoteType type = EmoteType.valueOf(name);
            if (type == null) {
                this.displayName = null;
            } else if (type.isEnabled() && type.canBeFound()) {
                this.displayName = type.getDisplayName();
                this.permission = type.getPermission();
                this.mysteryDust = type.getMysteryDust();
            }
        } else if (this.category.equals((Object)Category.CLOAKS)) {
            CloakType type = CloakType.valueOf(name);
            if (type == null) {
                this.displayName = null;
            } else if (type.isEnabled() && type.canBeFound()) {
                this.displayName = type.getDisplayName();
                this.permission = type.getPermission();
                this.mysteryDust = type.getMysteryDust();
            }
        }
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameStripColor() {
        if (this.displayName == null) {
            return "Error";
        }
        return ChatUtil.stripColor(this.displayName);
    }

    public String getPermission() {
        if (this.permission == null) {
            LoggerManager.warn("This item($s) has been disabled, so player won't get the permission.".replace("$s", (Object)((Object)this.getRarity()) + " " + (Object)((Object)this.getCategory()) + " " + this.getName()));
            return null;
        }
        return this.permission;
    }

    public int getMysteryDust() {
        return this.mysteryDust;
    }

    public void equip(Player player) {
        CloakType type;
        if (this.category.equals((Object)Category.HATS)) {
            HatType type2 = HatType.valueOf(this.name);
            if (type2 != null && type2.isEnabled() && type2.canBeFound()) {
                HatManager.equipHat(player, type2);
            }
        } else if (this.category.equals((Object)Category.HATS)) {
            AnimatedHatType type3 = AnimatedHatType.valueOf(this.name);
            if (type3 != null && type3.isEnabled() && type3.canBeFound()) {
                AnimatedHatManager.equipAnimatedHat(player, type3);
            }
        } else if (this.category.equals((Object)Category.PARTICLES)) {
            ParticleType type4 = ParticleType.valueOf(this.name);
            if (type4 != null && type4.isEnabled() && type4.canBeFound()) {
                ParticleManager.equipParticle(player, type4);
            }
        } else if (this.category.equals((Object)Category.SUITS)) {
            SuitType suit;
            SuitEquipmentType type5 = SuitEquipmentType.valueOf(this.name);
            if (type5 != null && (suit = SuitType.valueOf(type5.getGroup())).isEnabled() && type5.canBeFound()) {
                if (type5.getArmorType() == EnumArmorType.HELMET) {
                    SuitManager.equipHelmet(player, type5);
                } else if (type5.getArmorType() == EnumArmorType.CHESTPLATE) {
                    SuitManager.equipChestplate(player, type5);
                } else if (type5.getArmorType() == EnumArmorType.LEGGINGS) {
                    SuitManager.equipLeggings(player, type5);
                } else if (type5.getArmorType() == EnumArmorType.BOOTS) {
                    SuitManager.equipBoots(player, type5);
                }
            }
        } else if (this.category.equals((Object)Category.GADGETS)) {
            GadgetType type6 = GadgetType.valueOf(this.name);
            if (type6 != null && type6.isEnabled() && type6.canBeFound()) {
                GadgetManager.equipGadget(player, type6);
            }
        } else if (this.category.equals((Object)Category.PETS)) {
            PetType type7 = PetType.valueOf(this.name);
            if (type7 != null && type7.isEnabled() && type7.canBeFound()) {
                PetManager.equipPet(player, type7);
            }
        } else if (this.category.equals((Object)Category.MORPHS)) {
            MorphType type8 = MorphType.valueOf(this.name);
            if (type8 != null && type8.isEnabled() && type8.canBeFound()) {
                MorphManager.equipMorph(player, type8);
            }
        } else if (this.category.equals((Object)Category.BANNERS)) {
            BannerType type9 = BannerType.valueOf(this.name);
            if (type9 != null && type9.isEnabled() && type9.canBeFound()) {
                BannerManager.equipBanner(player, type9);
            }
        } else if (this.category.equals((Object)Category.EMOTES)) {
            EmoteType type10 = EmoteType.valueOf(this.name);
            if (type10 != null && type10.isEnabled() && type10.canBeFound()) {
                EmoteManager.equipEmote(player, type10);
            }
        } else if (this.category.equals((Object)Category.CLOAKS) && (type = CloakType.valueOf(this.name)) != null && type.isEnabled() && type.canBeFound()) {
            CloakManager.equipCloak(player, type);
        }
    }

    public String toString() {
        return this.rarity.getName() + " %% " + this.category.getName() + " %% " + this.name;
    }
}

