/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.mysteryboxes;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.mysteryboxes.MysteryBoxes;
import com.yapzhenyie.GadgetsMenu.mysteryboxes.MysteryBoxesLoot;
import com.yapzhenyie.GadgetsMenu.player.OfflinePlayerManager;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.CosmeticItems;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.MysteryBoxType;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.MysteryBoxCraftingDate;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Quality;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Rarity;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class MysteryBoxesManager {
    public static void giveMysteryBoxes(OfflinePlayerManager pManager, MysteryBoxType mysteryBoxType, boolean requirePerm, String details, Long expiryDate) {
        MysteryBoxesLoot item;
        ArrayList<MysteryBoxesLoot> items = new ArrayList<MysteryBoxesLoot>();
        Quality quality = mysteryBoxType.getQuality();
        if (quality.getIncludedCommonItem() > 0) {
            ArrayList<MysteryBoxesLoot> COMMON = new ArrayList<MysteryBoxesLoot>();
            for (int common = 1; common <= quality.getIncludedCommonItem(); ++common) {
                item = MysteryBoxesManager.item(Rarity.COMMON, COMMON);
                items.add(item);
            }
        }
        if (quality.getIncludedRareItem() > 0) {
            ArrayList<MysteryBoxesLoot> RARE = new ArrayList<MysteryBoxesLoot>();
            for (int rare = 1; rare <= quality.getIncludedRareItem(); ++rare) {
                item = MysteryBoxesManager.item(Rarity.RARE, RARE);
                items.add(item);
            }
        }
        if (quality.getIncludedEpicItem() > 0) {
            ArrayList<MysteryBoxesLoot> EPIC = new ArrayList<MysteryBoxesLoot>();
            for (int epic = 1; epic <= quality.getIncludedEpicItem(); ++epic) {
                item = MysteryBoxesManager.item(Rarity.EPIC, EPIC);
                items.add(item);
            }
        }
        if (quality.getIncludedLegendaryItem() > 0) {
            ArrayList<MysteryBoxesLoot> LEGENDARY = new ArrayList<MysteryBoxesLoot>();
            for (int legendary = 1; legendary <= quality.getIncludedLegendaryItem(); ++legendary) {
                item = MysteryBoxesManager.item(Rarity.LEGENDARY, LEGENDARY);
                items.add(item);
            }
        }
        StringBuilder loots = new StringBuilder();
        for (int i = 0; i < items.size(); ++i) {
            loots.append(((MysteryBoxesLoot)items.get(i)).toString() + (i != items.size() - 1 ? " %% " : ""));
        }
        if (mysteryBoxType.isNormalMysteryBox()) {
            details = null;
        } else if (mysteryBoxType.isCraftedMysteryBox()) {
            details = new MysteryBoxCraftingDate().getDate();
        }
        MysteryBoxes data = new MysteryBoxes(mysteryBoxType, expiryDate != null, expiryDate, requirePerm, details, loots.toString());
        if (pManager.isOfflinePlayer()) {
            pManager.saveOfflinePlayerMysteryBoxes(data);
        } else {
            PlayerManager playerManager = (PlayerManager)pManager;
            Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                if (playerManager.isLoaded()) {
                    playerManager.mysteryBoxes().add(data);
                } else {
                    playerManager.mysteryBoxesCache().add(data);
                }
                GadgetsMenu.getDatabaseManager().getDatabaseUtils().addMysteryBox(playerManager.getUUID(), playerManager.getUID(), data);
            });
        }
    }

    private static MysteryBoxesLoot item(Rarity rarity, ArrayList<MysteryBoxesLoot> type) {
        int times = 0;
        return MysteryBoxesManager.randomGetCosmeticItem(rarity, type, times);
    }

    private static MysteryBoxesLoot randomGetCosmeticItem(Rarity rarity, ArrayList<MysteryBoxesLoot> type, int repeatTimes) {
        MysteryBoxesLoot item = new CosmeticItems(rarity).getRandomItem();
        if (repeatTimes >= 5) {
            return item;
        }
        for (MysteryBoxesLoot totalLoots : type) {
            if (!totalLoots.getCategory().equals((Object)item.getCategory()) || !totalLoots.getName().equals(item.getName())) continue;
            return MysteryBoxesManager.randomGetCosmeticItem(rarity, type, ++repeatTimes);
        }
        type.add(item);
        return item;
    }
}

