/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.nms.v1_17_R1;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.holograms.CraftHologram;
import com.yapzhenyie.GadgetsMenu.log.LoggerManager;
import com.yapzhenyie.GadgetsMenu.nms.NMSManager;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.ArmorStandSlot;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.PetUtils;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.entity.NMSArmorStand;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.entity.NMSEntityBase;
import com.yapzhenyie.GadgetsMenu.nms.v1_17_R1.armorstand.ArmorStandFollower;
import com.yapzhenyie.GadgetsMenu.nms.v1_17_R1.armorstand.EntityNMSArmorStand;
import com.yapzhenyie.GadgetsMenu.nms.v1_17_R1.pathfinders.PathfinderGoalPanic;
import com.yapzhenyie.GadgetsMenu.nms.v1_17_R1.pets.Pathfinder;
import com.yapzhenyie.GadgetsMenu.nms.v1_17_R1.pets.PetUtilsImpl;
import com.yapzhenyie.GadgetsMenu.nms.v1_17_R1.pets.PlayerFollower;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.EntityAccess;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class NMSManagerImpl
implements NMSManager {
    @Override
    public void removePathfinders(Entity entity) {
        Pathfinder.removePathfinders(entity);
    }

    @Override
    public void followPlayer(Player player, Entity entity, double speed) {
        PlayerFollower.followPlayer(player, entity, speed);
    }

    @Override
    public void makeEntityPanic(Entity entity) {
        EntityInsentient insentient = (EntityInsentient)((CraftEntity)entity).getHandle();
        insentient.bP.a(3, (PathfinderGoal)new PathfinderGoalPanic((EntityCreature)insentient, 1.5));
    }

    @Override
    public PetUtils pet(Entity entity) {
        return new PetUtilsImpl(entity);
    }

    @Override
    public NMSArmorStand spawnNMSArmorStand(org.bukkit.World world, double x, double y, double z, String displayName) {
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        CraftHologram craftHologram = new CraftHologram(new Location(world, x, y, z));
        EntityNMSArmorStand invisibleArmorStand = new EntityNMSArmorStand((World)nmsWorld, craftHologram);
        invisibleArmorStand.setLocationNMS(x, y, z);
        if (displayName != null && !displayName.isEmpty()) {
            invisibleArmorStand.setCustomNameNMS(ChatUtil.format(displayName));
        }
        craftHologram.setNMSNameable(invisibleArmorStand);
        invisibleArmorStand.getBukkitEntity().setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        if (!this.addEntityToWorld(nmsWorld, (net.minecraft.world.entity.Entity)invisibleArmorStand)) {
            LoggerManager.printLog(LoggerManager.LogLevel.WARNING, "Could not spawn mystery vault hologram!");
        }
        return invisibleArmorStand;
    }

    @Override
    public NMSArmorStand spawnNMSArmorStandFollower(org.bukkit.World world, double x, double y, double z, Player follower, double additionY, String displayName, ArmorStandSlot itemSlot, ItemStack itemStack) {
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        ArmorStandFollower armorStandFollower = new ArmorStandFollower((World)nmsWorld, follower);
        armorStandFollower.setLocationNMS(x, y, z);
        armorStandFollower.setAdditionY(additionY);
        if (itemSlot != null && itemStack != null) {
            armorStandFollower.setSlotNMS((EnumItemSlot)itemSlot.to1_9AndAboveFormat(), CraftItemStack.asNMSCopy((ItemStack)itemStack));
        }
        if (displayName != null && !displayName.isEmpty()) {
            armorStandFollower.setCustomNameNMS(ChatUtil.format(displayName));
        }
        armorStandFollower.getBukkitEntity().setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        if (!this.addEntityToWorld(nmsWorld, (net.minecraft.world.entity.Entity)armorStandFollower)) {
            LoggerManager.printLog(LoggerManager.LogLevel.WARNING, "Could not spawn GadgetsMenu hologram!");
        }
        return armorStandFollower;
    }

    @Override
    public boolean isNMSEntityBase(Entity bukkitEntity) {
        return ((CraftEntity)bukkitEntity).getHandle() instanceof NMSEntityBase;
    }

    @Override
    public NMSEntityBase getNMSEntityBase(Entity bukkitEntity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)bukkitEntity).getHandle();
        if (nmsEntity instanceof NMSEntityBase) {
            return (NMSEntityBase)nmsEntity;
        }
        return null;
    }

    @Override
    public NMSEntityBase getNMSEntityBaseById(org.bukkit.World world, int entityId) {
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        net.minecraft.world.entity.Entity nmsEntity = nmsWorld.getEntity(entityId);
        if (nmsEntity instanceof NMSEntityBase) {
            return (NMSEntityBase)nmsEntity;
        }
        return null;
    }

    private boolean addEntityToWorld(WorldServer nmsWorld, net.minecraft.world.entity.Entity nmsEntity) {
        Validate.isTrue((boolean)Bukkit.isPrimaryThread(), (String)"Async entity add!");
        int chunkX = MathHelper.floor((double)(nmsEntity.locX() / 16.0));
        int chunkZ = MathHelper.floor((double)(nmsEntity.locZ() / 16.0));
        if (!nmsWorld.isChunkLoaded(chunkX, chunkZ)) {
            nmsEntity.getBukkitEntity().remove();
            nmsEntity.setRemoved(Entity.RemovalReason.b);
            return false;
        }
        try {
            nmsWorld.G.a((EntityAccess)nmsEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

