/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.nms.v1_20_R1;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.holograms.CraftHologram;
import com.yapzhenyie.GadgetsMenu.log.LoggerManager;
import com.yapzhenyie.GadgetsMenu.nms.NMSManager;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.ArmorStandSlot;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.PetUtils;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.entity.NMSArmorStand;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.entity.NMSEntityBase;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.util.INMSParticle;
import com.yapzhenyie.GadgetsMenu.nms.v1_20_R1.armorstand.ArmorStandFollower;
import com.yapzhenyie.GadgetsMenu.nms.v1_20_R1.armorstand.EntityNMSArmorStand;
import com.yapzhenyie.GadgetsMenu.nms.v1_20_R1.pathfinders.PathfinderGoalPanic;
import com.yapzhenyie.GadgetsMenu.nms.v1_20_R1.pets.Pathfinder;
import com.yapzhenyie.GadgetsMenu.nms.v1_20_R1.pets.PetUtilsImpl;
import com.yapzhenyie.GadgetsMenu.nms.v1_20_R1.pets.PlayerFollower;
import com.yapzhenyie.GadgetsMenu.nms.v1_20_R1.util.NMSParticle;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.EntityAccess;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class NMSManagerImpl
implements NMSManager {
    @Override
    public ItemStack spawnEgg(ItemStack item, String name) {
        String id = "minecraft:" + name.toLowerCase();
        net.minecraft.world.item.ItemStack itemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        NBTTagCompound tag = itemStack.v();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.a("id", id);
        tag.a("EntityTag", (NBTBase)nbtTagCompound);
        itemStack.c(tag);
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)itemStack);
    }

    @Override
    public void removePathfinders(Entity entity) {
        Pathfinder.removePathfinders(entity);
    }

    @Override
    public void followPlayer(Player player, Entity entity, double speed) {
        PlayerFollower.followPlayer(player, entity, speed);
    }

    @Override
    public void makeEntityPanic(Entity entity) {
        EntityInsentient insentient = (EntityInsentient)((CraftEntity)entity).getHandle();
        insentient.bO.a(3, (PathfinderGoal)new PathfinderGoalPanic((EntityCreature)insentient, 1.5));
    }

    @Override
    public PetUtils pet(Entity entity) {
        return new PetUtilsImpl(entity);
    }

    @Override
    public NMSArmorStand spawnNMSArmorStand(org.bukkit.World world, double x, double y, double z, String displayName) {
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        CraftHologram craftHologram = new CraftHologram(new Location(world, x, y, z));
        EntityNMSArmorStand invisibleArmorStand = new EntityNMSArmorStand((World)nmsWorld, craftHologram);
        invisibleArmorStand.setLocationNMS(x, y, z);
        if (displayName != null && !displayName.isEmpty()) {
            invisibleArmorStand.setCustomNameNMS(ChatUtil.format(displayName));
        }
        craftHologram.setNMSNameable(invisibleArmorStand);
        invisibleArmorStand.getBukkitEntity().setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        if (!this.addEntityToWorld(nmsWorld, (net.minecraft.world.entity.Entity)invisibleArmorStand)) {
            LoggerManager.printLog(LoggerManager.LogLevel.WARNING, "Could not spawn mystery vault hologram!");
        }
        return invisibleArmorStand;
    }

    @Override
    public NMSArmorStand spawnNMSArmorStandFollower(org.bukkit.World world, double x, double y, double z, Player follower, double additionY, String displayName, ArmorStandSlot itemSlot, ItemStack itemStack) {
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        ArmorStandFollower armorStandFollower = new ArmorStandFollower((World)nmsWorld, follower);
        armorStandFollower.setLocationNMS(x, y, z);
        armorStandFollower.setAdditionY(additionY);
        if (itemSlot != null && itemStack != null) {
            armorStandFollower.setSlotNMS((EnumItemSlot)itemSlot.to1_9AndAboveFormat(), CraftItemStack.asNMSCopy((ItemStack)itemStack));
        }
        if (displayName != null && !displayName.isEmpty()) {
            armorStandFollower.setCustomNameNMS(ChatUtil.format(displayName));
        }
        armorStandFollower.getBukkitEntity().setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        if (!this.addEntityToWorld(nmsWorld, (net.minecraft.world.entity.Entity)armorStandFollower)) {
            LoggerManager.printLog(LoggerManager.LogLevel.WARNING, "Could not spawn GadgetsMenu hologram!");
        }
        return armorStandFollower;
    }

    @Override
    public boolean isNMSEntityBase(Entity bukkitEntity) {
        return ((CraftEntity)bukkitEntity).getHandle() instanceof NMSEntityBase;
    }

    @Override
    public NMSEntityBase getNMSEntityBase(Entity bukkitEntity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)bukkitEntity).getHandle();
        if (nmsEntity instanceof NMSEntityBase) {
            return (NMSEntityBase)nmsEntity;
        }
        return null;
    }

    @Override
    public NMSEntityBase getNMSEntityBaseById(org.bukkit.World world, int entityId) {
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        net.minecraft.world.entity.Entity nmsEntity = nmsWorld.a(entityId);
        if (nmsEntity instanceof NMSEntityBase) {
            return (NMSEntityBase)nmsEntity;
        }
        return null;
    }

    @Override
    public ItemStack createBook(String title, String page1, List<String> contents) {
        ItemStack item = new ItemStack(Material.WRITTEN_BOOK, 1);
        net.minecraft.world.item.ItemStack itemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.a("title", title);
        tagCompound.a("author", "GadgetsMenu");
        NBTTagList tagList = new NBTTagList();
        tagList.add((Object)NBTTagString.a((String)page1));
        for (String content : contents) {
            tagList.add((Object)NBTTagString.a((String)content));
        }
        tagCompound.a("pages", (NBTBase)tagList);
        itemStack.c(tagCompound);
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)itemStack);
    }

    @Override
    public void openBook(ItemStack book, Player player) {
        int slot = player.getInventory().getHeldItemSlot();
        ItemStack itemHolding = player.getInventory().getItem(slot);
        player.getInventory().setItem(slot, book);
        PacketPlayOutOpenBook openBookPacket = new PacketPlayOutOpenBook(EnumHand.a);
        ((CraftPlayer)player).getHandle().c.a((Packet)openBookPacket);
        player.getInventory().setItem(slot, itemHolding);
    }

    @Override
    public String getNBTTag(ItemStack item, String name) {
        if (item == null || name == null) {
            return null;
        }
        net.minecraft.world.item.ItemStack itemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (itemStack == null || !itemStack.u()) {
            return null;
        }
        NBTTagCompound tag = itemStack.v();
        String nbtTagPrefix = GadgetsMenu.getInstance().getPluginName();
        if (tag == null || !tag.e(nbtTagPrefix)) {
            return null;
        }
        NBTTagCompound compound = tag.p(nbtTagPrefix);
        return compound.l(name);
    }

    @Override
    public ItemStack setNBTTag(ItemStack item, String name, String value) {
        String nbtTagPrefix;
        if (item == null) {
            LoggerManager.warn("Failed to set NBT data.");
            return null;
        }
        net.minecraft.world.item.ItemStack itemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        NBTTagCompound tag = itemStack.v();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.c(tag);
        }
        if (!tag.e(nbtTagPrefix = GadgetsMenu.getInstance().getPluginName())) {
            tag.a(nbtTagPrefix, (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound compound = tag.p(nbtTagPrefix);
        compound.a(name, value);
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)itemStack);
    }

    @Override
    public boolean hasNBTTag(ItemStack item, String name) {
        if (item == null || name == null) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (itemStack == null || !itemStack.u()) {
            return false;
        }
        NBTTagCompound tag = itemStack.v();
        String nbtTagPrefix = GadgetsMenu.getInstance().getPluginName();
        if (tag == null || !tag.e(nbtTagPrefix)) {
            return false;
        }
        NBTTagCompound compound = tag.p(nbtTagPrefix);
        String result = compound.l(name);
        return result != null && !result.isEmpty();
    }

    @Override
    public boolean isNBTTagEqual(ItemStack item, String name, String value) {
        if (item == null || name == null) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (itemStack == null || !itemStack.u()) {
            return false;
        }
        NBTTagCompound tag = itemStack.v();
        String nbtTagPrefix = GadgetsMenu.getInstance().getPluginName();
        if (tag == null || !tag.e(nbtTagPrefix)) {
            return false;
        }
        NBTTagCompound compound = tag.p(nbtTagPrefix);
        String result = compound.l(name);
        if (result == null || result.isEmpty()) {
            return false;
        }
        return result.equals(value);
    }

    @Override
    public INMSParticle getNMSParticle() {
        return NMSParticle.getInstance();
    }

    private boolean addEntityToWorld(WorldServer nmsWorld, net.minecraft.world.entity.Entity nmsEntity) {
        Validate.isTrue((boolean)Bukkit.isPrimaryThread(), (String)"Async entity add!");
        int chunkX = MathHelper.a((double)(nmsEntity.dn() / 16.0));
        int chunkZ = MathHelper.a((double)(nmsEntity.dt() / 16.0));
        if (!nmsWorld.b(chunkX, chunkZ)) {
            nmsEntity.getBukkitEntity().remove();
            nmsEntity.b(Entity.RemovalReason.b);
            return false;
        }
        try {
            if (VersionManager.isPaperServer()) {
                Field entityLookupField = ReflectionUtils.getField(nmsWorld.getClass(), true, "entityLookup");
                ReflectionUtils.invokeMethod(entityLookupField.get(nmsWorld), "addNewEntity", nmsEntity);
            } else {
                nmsWorld.M.a((EntityAccess)nmsEntity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

