/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.player;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.mysteryboxes.MysteryBoxes;
import com.yapzhenyie.GadgetsMenu.mysteryboxes.MysteryBoxesManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.MathUtil;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.MysteryBoxType;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class OfflinePlayerManager {
    private UUID uuid;
    private OfflinePlayer player;

    public OfflinePlayerManager(UUID uuid) {
        this.uuid = uuid;
        this.player = Bukkit.getOfflinePlayer((UUID)uuid);
    }

    public String getName() {
        return this.player.getName();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public OfflinePlayer getPlayer() {
        return this.player;
    }

    public boolean isOfflinePlayer() {
        return true;
    }

    public int getMysteryDust() {
        try {
            return GadgetsMenu.getGEconomyProvider().getMysteryDust(this);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public boolean addMysteryDust(int amount) {
        return GadgetsMenu.getGEconomyProvider().addMysteryDust(this, amount);
    }

    public boolean setMysteryDust(int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("The data cannot be negative value.");
        }
        return GadgetsMenu.getGEconomyProvider().setMysteryDust(this, amount);
    }

    public boolean removeMysteryDust(int amount) {
        if (this.getMysteryDust() - amount < 0) {
            throw new IllegalArgumentException("The new data cannot be negative value.");
        }
        return GadgetsMenu.getGEconomyProvider().removeMysteryDust(this, amount);
    }

    public void setPetName(String name) {
        Pattern p = Pattern.compile("[$+,:;=?@#|'<>.^*()%!]");
        Matcher m = p.matcher(name);
        if (m.find()) {
            name = name.replaceAll("[$+,:;=?@#|'<>.^*()%!]", "");
        }
        name = ChatUtil.format(name);
        GadgetsMenu.getDatabaseManager().getDatabaseUtils().setPetName(this, name);
    }

    public void giveMysteryBoxes(MysteryBoxType mysteryBoxType, Long expiryDate, boolean requirePerm, String details, int amount) {
        if (amount <= 0) {
            throw new IllegalArgumentException("The amount must be possitive number!");
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
            for (int i = 1; i <= amount; ++i) {
                MysteryBoxesManager.giveMysteryBoxes(this, mysteryBoxType, requirePerm, details, expiryDate);
            }
        });
    }

    public void giveMysteryBoxes(Long expiryDate, boolean requirePerm, String details, int amount) {
        if (amount <= 0) {
            throw new IllegalArgumentException("The amount must be possitive number!");
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
            for (int i = 1; i <= amount; ++i) {
                int random = GadgetsMenu.random().nextInt(5) + 1;
                MysteryBoxesManager.giveMysteryBoxes(this, MysteryBoxType.valueOfByName("Normal Mystery Box #" + random), requirePerm, details, expiryDate);
            }
        });
    }

    public void giveMysteryBoxes(Long expiryDate, boolean requirePerm, String details, int amount, float totalChance, float oneStarChance, float twoStarChance, float threeStarChance, float fourStarChance, float fiveStarChance) {
        if (amount <= 0) {
            throw new IllegalArgumentException("The amount must be possitive number!");
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
            for (int i = 1; i <= amount; ++i) {
                float allchance = oneStarChance + twoStarChance + threeStarChance + fourStarChance + fiveStarChance;
                float random = MathUtil.randomFloat(0.0f, allchance);
                int q = 1;
                q = random <= oneStarChance ? 1 : (random > oneStarChance && random <= oneStarChance + twoStarChance ? 2 : (random > oneStarChance + twoStarChance && random <= oneStarChance + twoStarChance + threeStarChance ? 3 : (random > oneStarChance + twoStarChance + threeStarChance && random <= oneStarChance + twoStarChance + threeStarChance + fourStarChance ? 4 : (random > oneStarChance + twoStarChance + threeStarChance + fourStarChance && random <= oneStarChance + twoStarChance + threeStarChance + fourStarChance + fiveStarChance ? 5 : GadgetsMenu.random().nextInt(5) + 1))));
                MysteryBoxType boxType = MysteryBoxType.valueOfByName("Normal Mystery Box #" + q);
                MysteryBoxesManager.giveMysteryBoxes(this, boxType, requirePerm, details, expiryDate);
            }
        });
    }

    public int getMysteryBoxes() {
        if (this.getPlayer() == null) {
            return 0;
        }
        return GadgetsMenu.getDatabaseManager().getDatabaseUtils().getMysteryBoxes(this);
    }

    public void saveOfflinePlayerMysteryBoxes(MysteryBoxes box) {
        if (!this.isOfflinePlayer()) {
            return;
        }
        if (!GadgetsMenu.getGadgetsMenuData().isMysteryBoxesEnabled()) {
            return;
        }
        if (this.getPlayer() == null) {
            return;
        }
        if (this.getPlayer().getUniqueId() == null) {
            return;
        }
        if (GadgetsMenu.getDatabaseManager().getDatabaseUtils().isExist(this.player)) {
            GadgetsMenu.getDatabaseManager().getDatabaseUtils().addMysteryBox(this.getUUID(), this.getUID(), box);
        }
    }

    public int getUID() {
        return GadgetsMenu.getDatabaseManager().getDatabaseUtils().getUID(this.uuid);
    }
}

