/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils;

import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;

public class DownloadUtil {
    public static String downloadFile(String urlString, OutputStream outputStream) {
        return DownloadUtil.downloadFile(urlString, "GET", outputStream);
    }

    public static String downloadFile(String urlString, String method, OutputStream outputStream) {
        try {
            outputStream.flush();
            URL url = new URL(urlString.replace(" ", "%20"));
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(method);
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                int counter;
                byte[] tempBuffer = new byte[4096];
                InputStream inputStream = connection.getInputStream();
                while ((counter = inputStream.read(tempBuffer)) > 0) {
                    outputStream.write(tempBuffer, 0, counter);
                    outputStream.flush();
                }
            } else {
                return "ERROR:" + responseCode;
            }
            outputStream.close();
        }
        catch (MalformedURLException ex) {
            return "ERROR:500";
        }
        catch (ProtocolException ex) {
            return "ERROR:500";
        }
        catch (IOException ex) {
            return "ERROR:500";
        }
        return null;
    }

    public static String getFileContent(String url) {
        String fileContent = null;
        try {
            URL adress = new URL(url);
            InputStream inputStream = adress.openStream();
            fileContent = new Scanner(inputStream).useDelimiter("\\Z").next();
        }
        catch (MalformedURLException ex) {
            return "ERROR:500";
        }
        catch (IOException ex) {
            return "ERROR:404";
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return fileContent;
    }

    public static List<String> getFileContents(String url) {
        ArrayList<String> fileContents = new ArrayList<String>();
        try {
            URL adress = new URL(url);
            InputStream inputStream = adress.openStream();
            Scanner contents = new Scanner(inputStream).useDelimiter("\\Z");
            while (contents.hasNextLine()) {
                fileContents.add(contents.nextLine());
            }
        }
        catch (MalformedURLException ex) {
            return fileContents;
        }
        catch (IOException ex) {
            return fileContents;
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return fileContents;
    }

    public static void touchURL(String url) {
        try {
            new URL(url).openStream().close();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String checkErrorCodes(String errorCode, boolean returnAll) {
        if (errorCode.contains("ERROR")) {
            if (!returnAll) {
                return null;
            }
            String[] errorParts = errorCode.split(":");
            if (errorParts[1].equalsIgnoreCase("404")) {
                return ChatUtil.format("&cError: Code " + errorParts[1] + " &f- &cThe required file don't exists!");
            }
            if (errorParts[1].equalsIgnoreCase("500")) {
                return ChatUtil.format("&cError: Code " + errorParts[1] + " &f- &cPlease report it to plugin developer!");
            }
            return ChatUtil.format("&cUnknown connection error: " + errorParts[1] + "!");
        }
        return null;
    }
}

