/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils;

import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import org.bukkit.potion.PotionType;

public enum EnumPotion {
    WATER(0),
    AWKWARD(16),
    THICK(32),
    MUNDANE(64),
    REGEN(8193),
    REGEN_II(8197, false, true),
    REGEN_III(8225, true, false),
    SPEED(8194),
    SPEED_II(8258, false, true),
    SPEED_III(8226, true, false),
    FIRE_RESISTANCE(8195),
    INSTANT_HEAL(8197),
    INSTANT_HEAL_II(8229, true, false),
    NIGHT_VISION(8198),
    NIGHT_VISION_II(8262, false, true),
    STRENGTH(8201),
    STRENGTH_II(8265, false, true),
    STRENGTH_III(8233, true, false),
    JUMP(8203),
    JUMP_II(8267, false, true),
    JUMP_III(8235, true, false),
    WATER_BREATHING(8205, true, false),
    WATER_BREATHING_II(8269, false, true),
    INVISIBILITY(8206),
    INVISIBILITY_II(8270, false, true),
    LUCK(8207),
    POISON(8196),
    POISON_II(8260, false, true),
    POISON_III(8228, true, false),
    WEAKNESS(8200),
    WEAKNESS_II(8264, false, true),
    SLOWNESS(8202),
    SLOWNESS_II(8266, false, true),
    INSTANT_DAMAGE(8204),
    INSTANT_DAMAGE_II(8236, true, false);

    private int data;
    private PotionType potionType;
    private boolean strong;
    private boolean extend;

    private EnumPotion(int data) {
        this.data = data;
        try {
            this.potionType = PotionType.valueOf((String)this.toString().replace("_II", "").replace("_III", ""));
        }
        catch (IllegalArgumentException | NoSuchFieldError e) {
            this.potionType = PotionType.REGEN;
        }
        this.strong = false;
        this.extend = false;
    }

    private EnumPotion(int data, boolean strong, boolean extend) {
        this.data = data;
        try {
            this.potionType = PotionType.valueOf((String)this.toString().replace("_II", "").replace("_III", ""));
        }
        catch (IllegalArgumentException | NoSuchFieldError e) {
            this.potionType = PotionType.REGEN;
        }
        this.strong = strong;
        this.extend = extend;
    }

    public int getData() {
        return this.data;
    }

    public PotionType getPotionType() {
        return this.potionType;
    }

    public boolean isStrong() {
        return this.strong;
    }

    public boolean isExtend() {
        return this.extend;
    }

    public static EnumPotion valueOfMaterialData(int data) {
        for (EnumPotion potion : EnumPotion.values()) {
            if (potion.getData() != data) continue;
            return potion;
        }
        return WATER;
    }

    public static boolean isPotion(EnumMaterial material) {
        return material.getType().toString().toLowerCase().contains("potion");
    }

    public static boolean isSplashPotion(EnumMaterial material) {
        return material == EnumMaterial.SPLASH_POTION;
    }

    public static boolean isLingeringPotion(EnumMaterial material) {
        return material == EnumMaterial.LINGERING_POTION;
    }
}

