/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils;

import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import org.bukkit.DyeColor;

public enum GDyeColor {
    WHITE(0, 15, EnumMaterial.WHITE_BANNER),
    ORANGE(1, 14, EnumMaterial.ORANGE_BANNER),
    MAGENTA(2, 13, EnumMaterial.MAGENTA_BANNER),
    LIGHT_BLUE(3, 12, EnumMaterial.LIGHT_BLUE_BANNER),
    YELLOW(4, 11, EnumMaterial.YELLOW_BANNER),
    LIME(5, 10, EnumMaterial.LIME_BANNER),
    PINK(6, 9, EnumMaterial.PINK_BANNER),
    GRAY(7, 8, EnumMaterial.GRAY_BANNER),
    LIGHT_GRAY(8, 7, EnumMaterial.LIGHT_GRAY_BANNER),
    SILVER(8, 7, EnumMaterial.LIGHT_GRAY_BANNER),
    CYAN(9, 6, EnumMaterial.CYAN_BANNER),
    PURPLE(10, 5, EnumMaterial.PURPLE_BANNER),
    BLUE(11, 4, EnumMaterial.BLUE_BANNER),
    BROWN(12, 3, EnumMaterial.BROWN_BANNER),
    GREEN(13, 2, EnumMaterial.GREEN_BANNER),
    RED(14, 1, EnumMaterial.RED_BANNER),
    BLACK(15, 0, EnumMaterial.BLACK_BANNER);

    private byte woolData;
    private byte dyeData;
    private EnumMaterial coloredBanner;

    private GDyeColor(int woolData, int dyeData, EnumMaterial coloredBanner) {
        this.woolData = (byte)woolData;
        this.dyeData = (byte)dyeData;
        this.coloredBanner = coloredBanner;
    }

    public byte getWoolData() {
        return this.woolData;
    }

    public byte getDyeData() {
        return this.dyeData;
    }

    public EnumMaterial getColoredBanner() {
        return this.coloredBanner;
    }

    public DyeColor getColor() {
        if (!VersionManager.is1_13OrAbove() && this == LIGHT_GRAY) {
            return DyeColor.valueOf((String)"SILVER");
        }
        if (VersionManager.is1_13OrAbove() && this == SILVER) {
            return DyeColor.valueOf((String)"LIGHT_GRAY");
        }
        return DyeColor.valueOf((String)this.toString());
    }

    public static GDyeColor getNextColor(GDyeColor recent) {
        if (recent == BLACK) {
            return WHITE;
        }
        return GDyeColor.getByWoolData((byte)(recent.getWoolData() + 1));
    }

    public static GDyeColor getByWoolData(byte data) {
        for (GDyeColor color : GDyeColor.values()) {
            if (color.woolData != data) continue;
            return color;
        }
        return null;
    }

    public static GDyeColor getByDyeData(byte data) {
        for (GDyeColor color : GDyeColor.values()) {
            if (color.dyeData != data) continue;
            return color;
        }
        return null;
    }

    public String getName() {
        if (this == SILVER) {
            return LIGHT_GRAY.name();
        }
        return this.name();
    }
}

