/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils;

import com.yapzhenyie.GadgetsMenu.utils.EnumArmorType;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.GColor;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.banners.GPatterns;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.Color;

public class GMaterial {
    private EnumMaterial material = EnumMaterial.BARRIER;
    private int data;
    private boolean isHead = false;
    private String texture;
    private Color color;
    private boolean isBanner = false;
    private GPatterns patterns;
    private boolean check = true;

    public GMaterial(EnumMaterial material) {
        Validate.notNull((Object)((Object)material));
        this.material = material;
    }

    public GMaterial(EnumMaterial material, int data) {
        Validate.notNull((Object)((Object)material));
        this.material = material;
        this.data = data;
    }

    public GMaterial(EnumMaterial material, GColor color) {
        Validate.notNull((Object)((Object)material));
        this.material = material;
        this.color = color.getColor();
    }

    public GMaterial(EnumMaterial material, Color color) {
        Validate.notNull((Object)((Object)material));
        this.material = material;
        this.color = color;
    }

    public GMaterial(GPatterns patterns) {
        Validate.notNull((Object)patterns);
        this.material = patterns.getBaseColor().getColoredBanner();
        this.patterns = patterns;
        this.isBanner = true;
    }

    public GMaterial(String material, int data) {
        Validate.notNull((Object)material);
        this.material = EnumMaterial.getByName(material);
        this.data = data;
    }

    public GMaterial(String combinedMaterial) {
        if (combinedMaterial.contains(":")) {
            if (combinedMaterial.startsWith("head")) {
                this.material = EnumMaterial.PLAYER_HEAD;
                this.data = 3;
                this.isHead = true;
                this.texture = combinedMaterial.substring(5);
            } else {
                try {
                    this.material = EnumMaterial.getByName(combinedMaterial.split("\\:")[0]);
                }
                catch (NullPointerException ex) {
                    this.material = EnumMaterial.BARRIER;
                }
                String subData = combinedMaterial.split("\\:")[1];
                if (subData.length() >= 6 && subData.length() <= 7) {
                    this.color = new GColor(subData).getColor();
                } else {
                    this.data = Integer.parseInt(combinedMaterial.split("\\:")[1]);
                }
            }
        } else {
            try {
                this.material = EnumMaterial.getByName(combinedMaterial);
            }
            catch (NullPointerException ex) {
                this.material = EnumMaterial.BARRIER;
            }
            this.data = 0;
        }
    }

    @Deprecated
    public GMaterial(String combinedMaterial, List<String> customMaterials) {
        if (combinedMaterial.contains(":")) {
            try {
                this.material = EnumMaterial.getByName(combinedMaterial.split("\\:")[0]);
            }
            catch (NullPointerException ex) {
                this.material = EnumMaterial.BARRIER;
            }
            this.data = Integer.parseInt(combinedMaterial.split("\\:")[1]);
        } else {
            try {
                this.material = EnumMaterial.getByName(combinedMaterial);
            }
            catch (NullPointerException ex) {
                this.material = EnumMaterial.BARRIER;
            }
            this.data = 0;
        }
        if (!customMaterials.contains(String.valueOf((Object)this.material)) && this.material == null) {
            this.material = EnumMaterial.BARRIER;
            this.data = 0;
        }
        this.check = false;
    }

    public EnumMaterial getEnumMaterial() {
        if (this.material == null && this.check) {
            return EnumMaterial.BARRIER;
        }
        return this.material;
    }

    public int getData() {
        if (this.material.getData() != 0) {
            return this.material.getData();
        }
        return this.data;
    }

    public boolean isColorableMaterial() {
        return this.color != null && EnumArmorType.isLeatherArmor(this.material);
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isSkullHead() {
        return this.isHead;
    }

    public String getTexture() {
        if (this.isHead) {
            if (this.texture == null) {
                return "";
            }
            return this.texture;
        }
        return "";
    }

    public boolean isBanner() {
        return this.isBanner;
    }

    public GPatterns getBannerPatterns() {
        return this.patterns;
    }

    public String getCombinedMaterial() {
        if (this.isHead) {
            return "head:" + this.texture;
        }
        if (this.isBanner) {
            return "banner:" + this.patterns.getBaseColor().toString() + ":{" + this.patterns.getGPatterns().toString().replace("[", "").replace("]", "") + "}";
        }
        return this.material.getName().toString() + (this.data > 15 ? ":" + this.data : "") + (this.isColorableMaterial() ? ":" + GColor.getHexFromColor(this.color) : "");
    }

    public String toString() {
        return this.getCombinedMaterial();
    }

    public static class GMaterialHead {
        private String texture;

        public GMaterialHead(String texture) {
            this.texture = texture;
        }

        public GMaterial getMaterial() {
            return new GMaterial("head:" + this.texture);
        }
    }
}

