/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class MathUtil {
    public static final Vector rotateAroundAxisX(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double y = v.getY() * cos - v.getZ() * sin;
        double z = v.getY() * sin + v.getZ() * cos;
        return v.setY(y).setZ(z);
    }

    public static final Vector rotateAroundAxisY(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.getX() * cos + v.getZ() * sin;
        double z = v.getX() * -sin + v.getZ() * cos;
        return v.setX(x).setZ(z);
    }

    public static final Vector rotateAroundAxisZ(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.getX() * cos - v.getY() * sin;
        double y = v.getX() * sin + v.getY() * cos;
        return v.setX(x).setY(y);
    }

    public static final Vector rotateVector(Vector v, double angleX, double angleY, double angleZ) {
        MathUtil.rotateAroundAxisX(v, angleX);
        MathUtil.rotateAroundAxisY(v, angleY);
        MathUtil.rotateAroundAxisZ(v, angleZ);
        return v;
    }

    public static final double angleToXAxis(Vector vector) {
        return Math.atan2(vector.getX(), vector.getY());
    }

    public static Vector getRandomVector() {
        double x = GadgetsMenu.random().nextDouble() * 2.0 - 1.0;
        double y = GadgetsMenu.random().nextDouble() * 2.0 - 1.0;
        double z = GadgetsMenu.random().nextDouble() * 2.0 - 1.0;
        return new Vector(x, y, z).normalize();
    }

    public static Vector getBackVector(Location loc) {
        float newZ = (float)(loc.getZ() + 0.75 * Math.sin(Math.toRadians(loc.getYaw() + 90.0f)));
        float newX = (float)(loc.getX() + 0.75 * Math.cos(Math.toRadians(loc.getYaw() + 90.0f)));
        return new Vector((double)newX - loc.getX(), 0.0, (double)newZ - loc.getZ());
    }

    public static final Vector rotateVectorYX(Vector v, float yawDegrees, float pitchDegrees) {
        double yaw = Math.toRadians(-1.0f * yawDegrees);
        double pitch = pitchDegrees;
        double cosYaw = Math.cos(yaw);
        double cosPitch = Math.cos(pitch);
        double sinYaw = Math.sin(yaw);
        double sinPitch = Math.sin(pitch);
        double initialY = v.getY();
        double initialZ = v.getZ();
        double z = initialY * sinPitch - initialZ * cosPitch;
        double y = initialY * cosPitch + initialZ * sinPitch;
        initialZ = z;
        double initialX = v.getX();
        z = initialZ * cosYaw - initialX * sinYaw;
        double x = initialZ * sinYaw + initialX * cosYaw;
        return new Vector(x, y, z);
    }

    public static void applyVelocity(final Entity entity, Vector vector) {
        if (entity.hasMetadata("NPC")) {
            return;
        }
        if (vector.getX() > 10.0) {
            vector.setX(10);
        }
        if (vector.getY() > 10.0) {
            vector.setY(10);
        }
        if (vector.getZ() > 10.0) {
            vector.setZ(10);
        }
        entity.setVelocity(vector);
        if (entity instanceof Player) {
            Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), new Runnable(){

                @Override
                public void run() {
                    GadgetsMenu.getPlayerManager((Player)entity).disableFallDamage();
                }
            }, 4L);
        }
    }

    public static void applyVelocity(final Entity entity, Vector vector, boolean ignoreGadgetsEnabled) {
        if (entity.hasMetadata("NPC")) {
            return;
        }
        if (vector.getX() > 10.0) {
            vector.setX(10);
        }
        if (vector.getY() > 10.0) {
            vector.setY(10);
        }
        if (vector.getZ() > 10.0) {
            vector.setZ(10);
        }
        entity.setVelocity(vector);
        if (entity instanceof Player && !ignoreGadgetsEnabled) {
            Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), new Runnable(){

                @Override
                public void run() {
                    GadgetsMenu.getPlayerManager((Player)entity).disableFallDamage();
                }
            }, 4L);
        }
    }

    public static Vector getRandomCircleVector() {
        double rnd = GadgetsMenu.random().nextDouble() * 2.0 * Math.PI;
        double x = Math.cos(rnd);
        double z = Math.sin(rnd);
        return new Vector(x, 0.0, z);
    }

    public static double randomDouble(double min, double max) {
        return Math.random() < 0.5 ? (1.0 - Math.random()) * (max - min) + min : Math.random() * (max - min) + min;
    }

    public static float randomFloat(float min, float max) {
        return (float)(Math.random() < 0.5 ? (1.0 - Math.random()) * (double)(max - min) + (double)min : Math.random() * (double)(max - min) + (double)min);
    }

    public static int randomInt(int min, int max) {
        return (int)(Math.random() < 0.5 ? (1.0 - Math.random()) * (double)(max - min + 1) + (double)min : Math.random() * (double)(max - min + 1) + (double)min);
    }

    public static double offset(Entity a, Entity b) {
        return MathUtil.offset(a.getLocation().toVector(), b.getLocation().toVector());
    }

    public static double offset(Location a, Location b) {
        return MathUtil.offset(a.toVector(), b.toVector());
    }

    public static double offset(Vector a, Vector b) {
        return a.subtract(b).length();
    }

    public static double square(double num) {
        return num * num;
    }

    public static int floor(double num) {
        int floor = (int)num;
        return (double)floor == num ? floor : floor - (int)(Double.doubleToRawLongBits(num) >>> 63);
    }
}

