/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils;

import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.banners.BannerManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.banners.BannerType;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.CloakManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.CloakType;
import com.yapzhenyie.GadgetsMenu.cosmetics.emotes.EmoteManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.emotes.EmoteType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.standard.HatManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.standard.HatType;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.MorphManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.MorphType;
import com.yapzhenyie.GadgetsMenu.cosmetics.particles.ParticleManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.particles.ParticleType;
import com.yapzhenyie.GadgetsMenu.cosmetics.pets.PetManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.pets.PetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitEquipmentType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitType;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumArmorType;
import com.yapzhenyie.GadgetsMenu.utils.discount.ItemCostDiscount;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PurchaseData {
    private Category category;
    private String name;
    private String displayName;
    private ItemCostDiscount discount;
    private int price;
    private String permission;
    private ItemStack showCaseItem;

    public void setData(Category category, String name, String displayName, ItemCostDiscount discount, int price, String permission) {
        this.category = category;
        this.name = name;
        this.displayName = ChatUtil.format(displayName);
        this.discount = discount;
        this.price = price;
        this.permission = permission;
        this.showCaseItem = null;
    }

    public void setData(Category category, String name, String displayName, ItemCostDiscount discount, int price, String permission, ItemStack showCaseItem) {
        this.category = category;
        this.name = name;
        this.displayName = ChatUtil.format(displayName);
        this.discount = discount;
        this.price = price;
        this.permission = permission;
        this.showCaseItem = showCaseItem;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = ChatUtil.format(displayName);
    }

    public void setItemCostDiscount(ItemCostDiscount discount) {
        this.discount = discount;
    }

    public void setPrice(int price) {
        this.price = price;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public void setShowCaseItem(ItemStack showCaseItem) {
        this.showCaseItem = showCaseItem;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ItemCostDiscount getItemCostDiscount() {
        return this.discount;
    }

    public int getPrice() {
        if (this.discount != null) {
            return this.discount.getPriceAfterDiscount(this.price);
        }
        return this.price;
    }

    public String getPermission() {
        return this.permission;
    }

    public ItemStack getShowCaseItem() {
        return this.showCaseItem;
    }

    public void equip(Player player) {
        CloakType type;
        if (this.category.equals((Object)Category.HATS)) {
            HatType type2 = HatType.valueOf(this.name);
            if (type2 != null && type2.isEnabled() && type2.canBeFound()) {
                HatManager.equipHat(player, type2);
            }
        } else if (this.category.equals((Object)Category.PARTICLES)) {
            ParticleType type3 = ParticleType.valueOf(this.name);
            if (type3 != null && type3.isEnabled() && type3.canBeFound()) {
                ParticleManager.equipParticle(player, type3);
            }
        } else if (this.category.equals((Object)Category.SUITS)) {
            SuitType suit;
            SuitEquipmentType type4 = SuitEquipmentType.valueOf(this.name);
            if (type4 != null && (suit = SuitType.valueOf(type4.getGroup())).isEnabled() && type4.canBeFound()) {
                if (type4.getArmorType() == EnumArmorType.HELMET) {
                    SuitManager.equipHelmet(player, type4);
                } else if (type4.getArmorType() == EnumArmorType.CHESTPLATE) {
                    SuitManager.equipChestplate(player, type4);
                } else if (type4.getArmorType() == EnumArmorType.LEGGINGS) {
                    SuitManager.equipLeggings(player, type4);
                } else if (type4.getArmorType() == EnumArmorType.BOOTS) {
                    SuitManager.equipBoots(player, type4);
                }
            }
        } else if (this.category.equals((Object)Category.GADGETS)) {
            GadgetType type5 = GadgetType.valueOf(this.name);
            if (type5 != null && type5.isEnabled() && type5.canBeFound()) {
                GadgetManager.equipGadget(player, type5);
            }
        } else if (this.category.equals((Object)Category.PETS)) {
            PetType type6 = PetType.valueOf(this.name);
            if (type6 != null && type6.isEnabled() && type6.canBeFound()) {
                PetManager.equipPet(player, type6);
            }
        } else if (this.category.equals((Object)Category.MORPHS)) {
            MorphType type7 = MorphType.valueOf(this.name);
            if (type7 != null && type7.isEnabled() && type7.canBeFound()) {
                MorphManager.equipMorph(player, type7);
            }
        } else if (this.category.equals((Object)Category.BANNERS)) {
            BannerType type8 = BannerType.valueOf(this.name);
            if (type8 != null && type8.isEnabled() && type8.canBeFound()) {
                BannerManager.equipBanner(player, type8);
            }
        } else if (this.category.equals((Object)Category.EMOTES)) {
            EmoteType type9 = EmoteType.valueOf(this.name);
            if (type9 != null && type9.isEnabled() && type9.canBeFound()) {
                EmoteManager.equipEmote(player, type9);
            }
        } else if (this.category.equals((Object)Category.CLOAKS) && (type = CloakType.valueOf(this.name)) != null && type.isEnabled() && type.canBeFound()) {
            CloakManager.equipCloak(player, type);
        }
    }

    public void reset() {
        this.category = null;
        this.name = null;
        this.displayName = null;
        this.price = 0;
        this.permission = null;
        this.showCaseItem = null;
    }

    public String toString() {
        return this.category.getName() + ": " + this.name + ", " + ChatUtil.format(this.displayName) + ", " + this.price + ", " + this.permission;
    }
}

