/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils.discount;

import java.util.ArrayList;
import java.util.List;

public class ItemCostDiscount {
    private static ArrayList<ItemCostDiscount> UNARRANGED_GROUPS = new ArrayList();
    private static ArrayList<ItemCostDiscount> ARRANGED_GROUPS = new ArrayList();
    private String name;
    private int priority;
    private String permission;
    private int rate;
    private List<String> enoughMysteryDustLore;
    private List<String> notEnoughMysteryDustLore;

    public ItemCostDiscount(String name, int priority, String permission, int rate, List<String> enoughMysteryDustLore, List<String> notEnoughMysteryDustLore) {
        this.name = name;
        this.priority = priority;
        this.permission = permission;
        rate = Math.abs(rate);
        if (rate > 100) {
            rate = 100;
        }
        this.rate = rate;
        this.enoughMysteryDustLore = enoughMysteryDustLore;
        this.notEnoughMysteryDustLore = notEnoughMysteryDustLore;
        if (!UNARRANGED_GROUPS.contains(this)) {
            UNARRANGED_GROUPS.add(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getPermission() {
        return this.permission;
    }

    public int getDiscountRate() {
        return this.rate;
    }

    public int getPriceAfterDiscount(int price) {
        return (int)Math.ceil((double)price * (double)(100 - this.rate) / 100.0);
    }

    public List<String> getEnoughMysteryDustLore() {
        return this.enoughMysteryDustLore;
    }

    public List<String> getNotEnoughMysteryDustLore() {
        return this.notEnoughMysteryDustLore;
    }

    public static ArrayList<ItemCostDiscount> getUnarrangedGroups() {
        return UNARRANGED_GROUPS;
    }

    public static ArrayList<ItemCostDiscount> getArrangedGroups() {
        if (!UNARRANGED_GROUPS.isEmpty() && ARRANGED_GROUPS.isEmpty()) {
            ItemCostDiscount.arrangeDiscountGroups();
        }
        return ARRANGED_GROUPS;
    }

    public static void arrangeDiscountGroups() {
        ArrayList<ItemCostDiscount> arranged = new ArrayList<ItemCostDiscount>();
        for (ItemCostDiscount d : UNARRANGED_GROUPS) {
            arranged = ItemCostDiscount.arrange(arranged, d);
        }
        ARRANGED_GROUPS = arranged;
    }

    private static ArrayList<ItemCostDiscount> arrange(ArrayList<ItemCostDiscount> references, ItemCostDiscount dis) {
        if (references.isEmpty()) {
            references.add(dis);
            return references;
        }
        ArrayList<ItemCostDiscount> newArrangement = new ArrayList<ItemCostDiscount>();
        boolean lastNumber = true;
        for (ItemCostDiscount ref : references) {
            if (!lastNumber || ref.getPriority() <= dis.getPriority()) {
                newArrangement.add(ref);
                continue;
            }
            newArrangement.add(dis);
            newArrangement.add(ref);
            lastNumber = false;
        }
        if (lastNumber) {
            newArrangement.add(dis);
        }
        return newArrangement;
    }
}

