/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils.mysteryboxes;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.banners.BannerType;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.CloakType;
import com.yapzhenyie.GadgetsMenu.cosmetics.emotes.EmoteType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.animated.AnimatedHatType;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.standard.HatType;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.MorphType;
import com.yapzhenyie.GadgetsMenu.cosmetics.particles.ParticleType;
import com.yapzhenyie.GadgetsMenu.cosmetics.pets.PetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitEquipmentType;
import com.yapzhenyie.GadgetsMenu.mysteryboxes.MysteryBoxesLoot;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Rarity;
import java.util.ArrayList;

public class CosmeticItems {
    private static ArrayList<MysteryBoxesLoot> common = new ArrayList();
    private static ArrayList<MysteryBoxesLoot> rare = new ArrayList();
    private static ArrayList<MysteryBoxesLoot> epic = new ArrayList();
    private static ArrayList<MysteryBoxesLoot> legendary = new ArrayList();
    private Rarity rarity;

    public CosmeticItems(Rarity rarity) {
        this.rarity = rarity;
        if (this.rarity == null) {
            throw new IllegalArgumentException("The rarity cannot be null!");
        }
    }

    public static void loadItems() {
        if (Category.HATS.isEnabled() && Category.HATS.canBeFound()) {
            for (HatType hatType : HatType.enabled()) {
                if (!hatType.canBeFound()) continue;
                if (hatType.getRarity() == Rarity.COMMON) {
                    common.add(new MysteryBoxesLoot(Rarity.COMMON, Category.HATS, hatType.getName()));
                    continue;
                }
                if (hatType.getRarity() == Rarity.RARE) {
                    rare.add(new MysteryBoxesLoot(Rarity.RARE, Category.HATS, hatType.getName()));
                    continue;
                }
                if (hatType.getRarity() == Rarity.EPIC) {
                    epic.add(new MysteryBoxesLoot(Rarity.EPIC, Category.HATS, hatType.getName()));
                    continue;
                }
                if (hatType.getRarity() != Rarity.LEGENDARY) continue;
                legendary.add(new MysteryBoxesLoot(Rarity.LEGENDARY, Category.HATS, hatType.getName()));
            }
        }
        if (Category.ANIMATED_HATS.isEnabled() && Category.ANIMATED_HATS.canBeFound()) {
            for (AnimatedHatType animatedHatType : AnimatedHatType.enabled()) {
                if (!animatedHatType.canBeFound()) continue;
                if (animatedHatType.getRarity() == Rarity.COMMON) {
                    common.add(new MysteryBoxesLoot(Rarity.COMMON, Category.ANIMATED_HATS, animatedHatType.getName()));
                    continue;
                }
                if (animatedHatType.getRarity() == Rarity.RARE) {
                    rare.add(new MysteryBoxesLoot(Rarity.RARE, Category.ANIMATED_HATS, animatedHatType.getName()));
                    continue;
                }
                if (animatedHatType.getRarity() == Rarity.EPIC) {
                    epic.add(new MysteryBoxesLoot(Rarity.EPIC, Category.ANIMATED_HATS, animatedHatType.getName()));
                    continue;
                }
                if (animatedHatType.getRarity() != Rarity.LEGENDARY) continue;
                legendary.add(new MysteryBoxesLoot(Rarity.LEGENDARY, Category.ANIMATED_HATS, animatedHatType.getName()));
            }
        }
        if (Category.PARTICLES.isEnabled() && Category.PARTICLES.canBeFound()) {
            for (ParticleType particleType : ParticleType.enabled()) {
                if (!particleType.canBeFound()) continue;
                if (particleType.getRarity() == Rarity.COMMON) {
                    common.add(new MysteryBoxesLoot(Rarity.COMMON, Category.PARTICLES, particleType.getName()));
                    continue;
                }
                if (particleType.getRarity() == Rarity.RARE) {
                    rare.add(new MysteryBoxesLoot(Rarity.RARE, Category.PARTICLES, particleType.getName()));
                    continue;
                }
                if (particleType.getRarity() == Rarity.EPIC) {
                    epic.add(new MysteryBoxesLoot(Rarity.EPIC, Category.PARTICLES, particleType.getName()));
                    continue;
                }
                if (particleType.getRarity() != Rarity.LEGENDARY) continue;
                legendary.add(new MysteryBoxesLoot(Rarity.LEGENDARY, Category.PARTICLES, particleType.getName()));
            }
        }
        if (Category.SUITS.isEnabled() && Category.SUITS.canBeFound()) {
            for (SuitEquipmentType suitEquipmentType : SuitEquipmentType.values()) {
                if (!suitEquipmentType.getType().isEnabled() || !suitEquipmentType.canBeFound()) continue;
                if (suitEquipmentType.getRarity() == Rarity.COMMON) {
                    common.add(new MysteryBoxesLoot(Rarity.COMMON, Category.SUITS, suitEquipmentType.getName()));
                    continue;
                }
                if (suitEquipmentType.getRarity() == Rarity.RARE) {
                    rare.add(new MysteryBoxesLoot(Rarity.RARE, Category.SUITS, suitEquipmentType.getName()));
                    continue;
                }
                if (suitEquipmentType.getRarity() == Rarity.EPIC) {
                    epic.add(new MysteryBoxesLoot(Rarity.EPIC, Category.SUITS, suitEquipmentType.getName()));
                    continue;
                }
                if (suitEquipmentType.getRarity() != Rarity.LEGENDARY) continue;
                legendary.add(new MysteryBoxesLoot(Rarity.LEGENDARY, Category.SUITS, suitEquipmentType.getName()));
            }
        }
        if (Category.GADGETS.isEnabled() && Category.GADGETS.canBeFound()) {
            for (GadgetType gadgetType : GadgetType.enabled()) {
                if (!gadgetType.canBeFound()) continue;
                if (gadgetType.getRarity() == Rarity.COMMON) {
                    common.add(new MysteryBoxesLoot(Rarity.COMMON, Category.GADGETS, gadgetType.getName()));
                    continue;
                }
                if (gadgetType.getRarity() == Rarity.RARE) {
                    rare.add(new MysteryBoxesLoot(Rarity.RARE, Category.GADGETS, gadgetType.getName()));
                    continue;
                }
                if (gadgetType.getRarity() == Rarity.EPIC) {
                    epic.add(new MysteryBoxesLoot(Rarity.EPIC, Category.GADGETS, gadgetType.getName()));
                    continue;
                }
                if (gadgetType.getRarity() != Rarity.LEGENDARY) continue;
                legendary.add(new MysteryBoxesLoot(Rarity.LEGENDARY, Category.GADGETS, gadgetType.getName()));
            }
        }
        if (Category.PETS.isEnabled() && Category.PETS.canBeFound()) {
            for (PetType petType : PetType.enabled()) {
                if (!petType.canBeFound()) continue;
                if (petType.getRarity() == Rarity.COMMON) {
                    common.add(new MysteryBoxesLoot(Rarity.COMMON, Category.PETS, petType.getName()));
                    continue;
                }
                if (petType.getRarity() == Rarity.RARE) {
                    rare.add(new MysteryBoxesLoot(Rarity.RARE, Category.PETS, petType.getName()));
                    continue;
                }
                if (petType.getRarity() == Rarity.EPIC) {
                    epic.add(new MysteryBoxesLoot(Rarity.EPIC, Category.PETS, petType.getName()));
                    continue;
                }
                if (petType.getRarity() != Rarity.LEGENDARY) continue;
                legendary.add(new MysteryBoxesLoot(Rarity.LEGENDARY, Category.PETS, petType.getName()));
            }
        }
        if (Category.MORPHS.isEnabled() && Category.MORPHS.canBeFound()) {
            for (MorphType morphType : MorphType.enabled()) {
                if (!morphType.canBeFound()) continue;
                if (morphType.getRarity() == Rarity.COMMON) {
                    common.add(new MysteryBoxesLoot(Rarity.COMMON, Category.MORPHS, morphType.getName()));
                    continue;
                }
                if (morphType.getRarity() == Rarity.RARE) {
                    rare.add(new MysteryBoxesLoot(Rarity.RARE, Category.MORPHS, morphType.getName()));
                    continue;
                }
                if (morphType.getRarity() == Rarity.EPIC) {
                    epic.add(new MysteryBoxesLoot(Rarity.EPIC, Category.MORPHS, morphType.getName()));
                    continue;
                }
                if (morphType.getRarity() != Rarity.LEGENDARY) continue;
                legendary.add(new MysteryBoxesLoot(Rarity.LEGENDARY, Category.MORPHS, morphType.getName()));
            }
        }
        if (Category.BANNERS.isEnabled() && Category.BANNERS.canBeFound()) {
            for (BannerType bannerType : BannerType.enabled()) {
                if (!bannerType.canBeFound()) continue;
                if (bannerType.getRarity() == Rarity.COMMON) {
                    common.add(new MysteryBoxesLoot(Rarity.COMMON, Category.BANNERS, bannerType.getName()));
                    continue;
                }
                if (bannerType.getRarity() == Rarity.RARE) {
                    rare.add(new MysteryBoxesLoot(Rarity.RARE, Category.BANNERS, bannerType.getName()));
                    continue;
                }
                if (bannerType.getRarity() == Rarity.EPIC) {
                    epic.add(new MysteryBoxesLoot(Rarity.EPIC, Category.BANNERS, bannerType.getName()));
                    continue;
                }
                if (bannerType.getRarity() != Rarity.LEGENDARY) continue;
                legendary.add(new MysteryBoxesLoot(Rarity.LEGENDARY, Category.BANNERS, bannerType.getName()));
            }
        }
        if (Category.EMOTES.isEnabled() && Category.EMOTES.canBeFound()) {
            for (EmoteType emoteType : EmoteType.enabled()) {
                if (!emoteType.canBeFound()) continue;
                if (emoteType.getRarity() == Rarity.COMMON) {
                    common.add(new MysteryBoxesLoot(Rarity.COMMON, Category.EMOTES, emoteType.getName()));
                    continue;
                }
                if (emoteType.getRarity() == Rarity.RARE) {
                    rare.add(new MysteryBoxesLoot(Rarity.RARE, Category.EMOTES, emoteType.getName()));
                    continue;
                }
                if (emoteType.getRarity() == Rarity.EPIC) {
                    epic.add(new MysteryBoxesLoot(Rarity.EPIC, Category.EMOTES, emoteType.getName()));
                    continue;
                }
                if (emoteType.getRarity() != Rarity.LEGENDARY) continue;
                legendary.add(new MysteryBoxesLoot(Rarity.LEGENDARY, Category.EMOTES, emoteType.getName()));
            }
        }
        if (Category.CLOAKS.isEnabled() && Category.CLOAKS.canBeFound()) {
            for (CloakType cloakType : CloakType.enabled()) {
                if (!cloakType.canBeFound()) continue;
                if (cloakType.getRarity() == Rarity.COMMON) {
                    common.add(new MysteryBoxesLoot(Rarity.COMMON, Category.CLOAKS, cloakType.getName()));
                    continue;
                }
                if (cloakType.getRarity() == Rarity.RARE) {
                    rare.add(new MysteryBoxesLoot(Rarity.RARE, Category.CLOAKS, cloakType.getName()));
                    continue;
                }
                if (cloakType.getRarity() == Rarity.EPIC) {
                    epic.add(new MysteryBoxesLoot(Rarity.EPIC, Category.CLOAKS, cloakType.getName()));
                    continue;
                }
                if (cloakType.getRarity() != Rarity.LEGENDARY) continue;
                legendary.add(new MysteryBoxesLoot(Rarity.LEGENDARY, Category.CLOAKS, cloakType.getName()));
            }
        }
    }

    public MysteryBoxesLoot getRandomItem() {
        if (this.rarity == Rarity.COMMON) {
            int random = GadgetsMenu.random().nextInt(common.size());
            MysteryBoxesLoot loot = common.get(random);
            if (loot == null) {
                return new MysteryBoxesLoot(Rarity.COMMON, null, null);
            }
            return loot;
        }
        if (this.rarity == Rarity.RARE) {
            int random = GadgetsMenu.random().nextInt(rare.size());
            MysteryBoxesLoot loot = rare.get(random);
            if (loot == null) {
                return new MysteryBoxesLoot(Rarity.RARE, null, null);
            }
            return loot;
        }
        if (this.rarity == Rarity.EPIC) {
            int random = GadgetsMenu.random().nextInt(epic.size());
            MysteryBoxesLoot loot = epic.get(random);
            if (loot == null) {
                return new MysteryBoxesLoot(Rarity.EPIC, null, null);
            }
            return loot;
        }
        if (this.rarity == Rarity.LEGENDARY) {
            int random = GadgetsMenu.random().nextInt(legendary.size());
            MysteryBoxesLoot loot = legendary.get(random);
            if (loot == null) {
                return new MysteryBoxesLoot(Rarity.LEGENDARY, null, null);
            }
            return loot;
        }
        return new MysteryBoxesLoot(this.rarity, null, null);
    }
}

