/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils;

import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.MathUtil;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Quality;
import java.util.Arrays;
import java.util.List;

public enum Rarity {
    COMMON("Common", "&aCommon", 70, 64, 58, 52, 0),
    RARE("Rare", "&9Rare", 15, 18, 20, 22, 40),
    EPIC("Epic", "&5Epic", 10, 12, 15, 18, 50),
    LEGENDARY("Legendary", "&6Legendary", 5, 6, 7, 8, 10);

    private String name;
    private String displayName;
    private int oneStarChance;
    private int twoStarChance;
    private int threeStarChance;
    private int fourStarChance;
    private int fiveStarChance;
    private boolean isSendMessageEnabled = true;
    private List<String> foundLootMessages;
    private boolean isPlaySoundEnabled = true;
    private SoundEffect sound = SoundEffect.ENTITY_CHICKEN_EGG;
    private boolean isBroadcastMessagesEnabled = true;
    private String broadcastMessage;
    private String foundLootHologram;
    private boolean isGiveMysteryDustEnabled = true;
    private int minMysteryDust = 1;
    private int maxMysteryDust = 3;
    private boolean isSendAlreadyHadLootMessagesEnabled = true;
    private List<String> alreadyHadLootMessages;
    private boolean executeCustomCommand = false;
    private String customCommand;

    private Rarity(String name, String displayName, int oneStarChance, int twoStarChance, int threeStarChance, int fourStarChance, int fiveStarChance) {
        this.name = name;
        if (FileManager.getMysteryBoxesFile().get("Mystery-Boxes.Rarity." + this.name) == null) {
            this.displayName = displayName;
            FileManager.getMysteryBoxesFile().set("Mystery-Boxes.Rarity." + this.name, displayName);
        } else {
            this.displayName = FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Rarity." + this.name);
        }
        if (FileManager.getMysteryBoxesFile().get("Mystery-Boxes.Chances.One-Star." + this.name) == null) {
            this.oneStarChance = oneStarChance;
            FileManager.getMysteryBoxesFile().set("Mystery-Boxes.Chances.One-Star." + this.name, oneStarChance);
        } else {
            this.oneStarChance = FileManager.getMysteryBoxesFile().getInt("Mystery-Boxes.Chances.One-Star." + this.name);
        }
        if (FileManager.getMysteryBoxesFile().get("Mystery-Boxes.Chances.Two-Star." + this.name) == null) {
            this.twoStarChance = twoStarChance;
            FileManager.getMysteryBoxesFile().set("Mystery-Boxes.Chances.Two-Star." + this.name, twoStarChance);
        } else {
            this.twoStarChance = FileManager.getMysteryBoxesFile().getInt("Mystery-Boxes.Chances.Two-Star." + this.name);
        }
        if (FileManager.getMysteryBoxesFile().get("Mystery-Boxes.Chances.Three-Star." + this.name) == null) {
            this.threeStarChance = threeStarChance;
            FileManager.getMysteryBoxesFile().set("Mystery-Boxes.Chances.Three-Star." + this.name, threeStarChance);
        } else {
            this.threeStarChance = FileManager.getMysteryBoxesFile().getInt("Mystery-Boxes.Chances.Three-Star." + this.name);
        }
        if (FileManager.getMysteryBoxesFile().get("Mystery-Boxes.Chances.Four-Star." + this.name) == null) {
            this.fourStarChance = fourStarChance;
            FileManager.getMysteryBoxesFile().set("Mystery-Boxes.Chances.Four-Star." + this.name, fourStarChance);
        } else {
            this.fourStarChance = FileManager.getMysteryBoxesFile().getInt("Mystery-Boxes.Chances.Four-Star." + this.name);
        }
        if (fiveStarChance != 0) {
            if (FileManager.getMysteryBoxesFile().get("Mystery-Boxes.Chances.Five-Star." + this.name) == null) {
                this.fiveStarChance = fiveStarChance;
                FileManager.getMysteryBoxesFile().set("Mystery-Boxes.Chances.Five-Star." + this.name, fiveStarChance);
            } else {
                this.fiveStarChance = FileManager.getMysteryBoxesFile().getInt("Mystery-Boxes.Chances.Five-Star." + this.name);
            }
        }
        if (FileManager.getMysteryBoxesFile().get("Mystery-Boxes.Found-Loot." + this.name + ".Send-Message.Enabled") != null) {
            this.isSendMessageEnabled = FileManager.getMysteryBoxesFile().getBoolean("Mystery-Boxes.Found-Loot." + this.name + ".Send-Message.Enabled");
        }
        this.foundLootMessages = FileManager.getMysteryBoxesFile().get("Mystery-Boxes.Found-Loot." + this.name + ".Send-Message.Message") != null ? FileManager.getMysteryBoxesFile().getStringList("Mystery-Boxes.Found-Loot." + this.name + ".Send-Message.Message") : Arrays.asList("\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584", "             &b&lMystery Box", "", "  &7You found loot!", "  &71x " + this.displayName + " {LOOT}", "", "\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584");
        if (FileManager.getMysteryBoxesFile().get("Mystery-Boxes.Found-Loot." + this.name + ".Play-Sound.Enabled") != null) {
            this.isPlaySoundEnabled = FileManager.getMysteryBoxesFile().getBoolean("Mystery-Boxes.Found-Loot." + this.name + ".Play-Sound.Enabled");
        }
        if (FileManager.getMysteryBoxesFile().get("Mystery-Boxes.Found-Loot." + this.name + ".Play-Sound.Sound") != null) {
            this.sound = SoundEffect.valueOf(FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Found-Loot." + this.name + ".Play-Sound.Sound"));
        }
        if (FileManager.getMysteryBoxesFile().get("Mystery-Boxes.Broadcast.Found-Loot." + this.name + ".Enabled") != null) {
            this.isBroadcastMessagesEnabled = FileManager.getMysteryBoxesFile().getBoolean("Mystery-Boxes.Broadcast.Found-Loot." + this.name + ".Enabled");
        }
        this.broadcastMessage = FileManager.getMysteryBoxesFile().get("Mystery-Boxes.Broadcast.Found-Loot." + this.name + ".Message") != null ? FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Broadcast.Found-Loot." + this.name + ".Message") : ChatUtil.format("&b[Mystery Box] {PLAYER} &bfound a " + this.displayName + " {LOOT}&b!");
        this.foundLootHologram = FileManager.getMysteryBoxesFile().get("Mystery-Boxes.Holograms.Found-Loot." + this.name) != null ? FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Holograms.Found-Loot." + this.name) : ChatUtil.format(this.displayName + " {LOOT}");
        if (FileManager.getMysteryBoxesFile().get("Mystery-Boxes.Already-Had-Loot." + this.name + ".Give-Mystery-Dust.Enabled") != null) {
            this.isGiveMysteryDustEnabled = FileManager.getMysteryBoxesFile().getBoolean("Mystery-Boxes.Already-Had-Loot." + this.name + ".Give-Mystery-Dust.Enabled");
        }
        if (FileManager.getMysteryBoxesFile().get("Mystery-Boxes.Already-Had-Loot." + this.name + ".Give-Mystery-Dust.Min") != null) {
            this.minMysteryDust = FileManager.getMysteryBoxesFile().getInt("Mystery-Boxes.Already-Had-Loot." + this.name + ".Give-Mystery-Dust.Min");
        }
        if (FileManager.getMysteryBoxesFile().get("Mystery-Boxes.Already-Had-Loot." + this.name + ".Give-Mystery-Dust.Max") != null) {
            this.maxMysteryDust = FileManager.getMysteryBoxesFile().getInt("Mystery-Boxes.Already-Had-Loot." + this.name + ".Give-Mystery-Dust.Max");
        }
        if (FileManager.getMysteryBoxesFile().get("Mystery-Boxes.Already-Had-Loot." + this.name + ".Send-Message.Enabled") != null) {
            this.isSendAlreadyHadLootMessagesEnabled = FileManager.getMysteryBoxesFile().getBoolean("Mystery-Boxes.Already-Had-Loot." + this.name + ".Send-Message.Enabled");
        }
        this.alreadyHadLootMessages = FileManager.getMysteryBoxesFile().get("Mystery-Boxes.Already-Had-Loot." + this.name + ".Send-Message.Message") != null ? FileManager.getMysteryBoxesFile().getStringList("Mystery-Boxes.Already-Had-Loot." + this.name + ".Send-Message.Message") : Arrays.asList("&7You already had " + this.displayName + " {LOOT} &7so you", "&7received &a{MYSTERY_DUST} Mystery Dust &7instead.");
        if (FileManager.getMysteryBoxesFile().get("Mystery-Boxes.Already-Had-Loot." + this.name + ".Execute-Command.Enabled") != null) {
            this.executeCustomCommand = FileManager.getMysteryBoxesFile().getBoolean("Mystery-Boxes.Already-Had-Loot." + this.name + ".Execute-Command.Enabled");
        }
        if (FileManager.getMysteryBoxesFile().get("Mystery-Boxes.Already-Had-Loot." + this.name + ".Execute-Command.Command") != null) {
            this.customCommand = FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Already-Had-Loot." + this.name + ".Execute-Command.Command");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return ChatUtil.format(this.displayName);
    }

    public int getOneStarChance() {
        return this.oneStarChance;
    }

    public int getTwoStarChance() {
        return this.twoStarChance;
    }

    public int getThreeStarChance() {
        return this.threeStarChance;
    }

    public int getFourStarChance() {
        return this.fourStarChance;
    }

    public int getFiveStarChance() {
        return this.fiveStarChance;
    }

    public int getChance(Quality quality) {
        if (quality == Quality.ONE_STAR) {
            return this.oneStarChance;
        }
        if (quality == Quality.TWO_STAR) {
            return this.twoStarChance;
        }
        if (quality == Quality.THREE_STAR) {
            return this.threeStarChance;
        }
        if (quality == Quality.FOUR_STAR) {
            return this.fourStarChance;
        }
        if (quality == Quality.FIVE_STAR) {
            return this.fiveStarChance;
        }
        return this.oneStarChance;
    }

    public boolean isSendMessageEnabled() {
        return this.isSendMessageEnabled;
    }

    public List<String> getFoundLootMessages() {
        return this.foundLootMessages;
    }

    public boolean isPlaySoundEnabled() {
        return this.isPlaySoundEnabled;
    }

    public SoundEffect getSound() {
        return this.sound;
    }

    public boolean isBroadcastMessagesEnabled() {
        return this.isBroadcastMessagesEnabled;
    }

    public String getBroadcastMessage() {
        return this.broadcastMessage;
    }

    public String getFoundLootHologram() {
        return this.foundLootHologram;
    }

    public boolean isGiveMysteryDustEnabled() {
        return this.isGiveMysteryDustEnabled;
    }

    public int getMinMysteryDust() {
        return this.minMysteryDust;
    }

    public int getMaxMysteryDust() {
        return this.maxMysteryDust;
    }

    public int getRandomMysteryDustInRange() {
        if (this.maxMysteryDust > this.minMysteryDust) {
            return MathUtil.randomInt(this.minMysteryDust, this.maxMysteryDust);
        }
        return MathUtil.randomInt(this.maxMysteryDust, this.minMysteryDust);
    }

    public boolean isSendAlreadyHadLootMessagesEnabled() {
        return this.isSendAlreadyHadLootMessagesEnabled;
    }

    public List<String> getAlreadyHadLootMessages() {
        return this.alreadyHadLootMessages;
    }

    public boolean executeCustomCommand() {
        return this.executeCustomCommand;
    }

    public String getCustomCommand() {
        return this.customCommand;
    }

    public static Rarity getName(String name) throws NullPointerException {
        for (Rarity type : Rarity.values()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }
}

