/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils.mysteryvault;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.log.LoggerManager;
import com.yapzhenyie.GadgetsMenu.mysteryboxes.MysteryBoxesMessages;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.entity.NMSArmorStand;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ServerVersion;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.MysteryVaultManager;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.MysteryVaultUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MysteryVault {
    private String name;
    private Location location;
    private BlockFace blockFace;
    private ArrayList<NMSArmorStand> holograms = new ArrayList();
    private boolean displayIndividualHologram = false;
    private NMSArmorStand individualHologram;
    private NMSArmorStand lootHologram;

    public MysteryVault(String name, BlockFace blockFace, Location location) {
        if (MysteryVaultManager.vaults().contains(this)) {
            throw new IllegalArgumentException("This mystery vault already exists!");
        }
        Validate.isTrue((name != null && !name.isEmpty() ? 1 : 0) != 0, (String)"The name can not be null or empty!");
        Validate.notNull((Object)blockFace, (String)"BlockFace can not be null!");
        Validate.notNull((Object)location, (String)"Location can not be null!");
        this.name = name;
        this.blockFace = blockFace;
        this.location = location;
        if (GadgetsMenu.hasProtocolLibHook()) {
            this.displayIndividualHologram = true;
        }
    }

    public void saveToDatabase() {
        for (MysteryVault vault : MysteryVaultManager.vaults()) {
            if (vault.getName().equalsIgnoreCase(this.name)) {
                throw new IllegalArgumentException("Mystery vault with that name already exists!");
            }
            if (!vault.getLocation().equals((Object)this.location)) continue;
            throw new IllegalArgumentException("You have already created mystery vault at this location!");
        }
        try {
            FileManager.getMysteryVaultFile().set("Mystery-Vaults." + this.name + ".BlockFace", this.blockFace.toString());
            MysteryVaultUtils.saveLocation(this.location, FileManager.getMysteryVaultFile().createSection("Mystery-Vaults." + this.name + ".Location"));
            MysteryVaultManager.vaults().add(this);
            FileManager.getMysteryVaultFile().save();
        }
        catch (Exception e) {
            LoggerManager.printLog(MessageType.ERROR.getFormatMessage());
            e.printStackTrace();
        }
    }

    public void updateLocation(BlockFace blockFace, Location location) {
        Validate.notNull((Object)blockFace, (String)"BlockFace can not be null!");
        Validate.notNull((Object)location, (String)"Location can not be null!");
        try {
            this.blockFace = blockFace;
            this.location = location;
            FileManager.getMysteryVaultFile().set("Mystery-Vaults." + this.name + ".BlockFace", blockFace.toString());
            MysteryVaultUtils.saveLocation(location, FileManager.getMysteryVaultFile().createSection("Mystery-Vaults." + this.name + ".Location"));
            FileManager.getMysteryVaultFile().save();
        }
        catch (Exception e) {
            LoggerManager.printLog(MessageType.ERROR.getFormatMessage());
            e.printStackTrace();
        }
    }

    public void updateLocationWithoutSaving(Location location) {
        Validate.notNull((Object)location, (String)"Location can not be null!");
        try {
            this.location = location;
        }
        catch (Exception e) {
            LoggerManager.printLog(MessageType.ERROR.getFormatMessage());
            e.printStackTrace();
        }
    }

    public boolean delete() {
        if (FileManager.getMysteryVaultFile().get("Mystery-Vaults." + this.name) == null) {
            return false;
        }
        if (!MysteryVaultManager.vaults().contains(this)) {
            return false;
        }
        try {
            this.removeHolograms();
            this.removeLootHologram();
            this.removeIndividualHologram();
            MysteryVaultManager.vaults().remove(this);
            FileManager.getMysteryVaultFile().set("Mystery-Vaults." + this.name, null);
            FileManager.getMysteryVaultFile().save();
            return true;
        }
        catch (Exception e) {
            LoggerManager.printLog(MessageType.ERROR.getFormatMessage());
            e.printStackTrace();
            return false;
        }
    }

    public String getName() {
        return this.name;
    }

    public BlockFace getBlockFace() {
        return this.blockFace;
    }

    public Location getLocation() {
        return this.location;
    }

    public void createHolograms() {
        if (!this.holograms.isEmpty()) {
            if (this.holograms.get(0) != null && this.holograms.get(0).isDeadNMS()) {
                NMSArmorStand hologram1 = GadgetsMenu.getNMSManager().spawnNMSArmorStand(this.location.getWorld(), this.location.getX() + 0.5, this.location.getY() + EnumHologramAdditionY.getAdditionY() + 0.24, this.location.getZ() + 0.5, MysteryBoxesMessages.hologramLineOne);
                this.holograms.set(0, hologram1);
            }
            if (this.holograms.get(1) != null && this.holograms.get(1).isDeadNMS()) {
                NMSArmorStand hologram2 = GadgetsMenu.getNMSManager().spawnNMSArmorStand(this.location.getWorld(), this.location.getX() + 0.5, this.location.getY() + EnumHologramAdditionY.getAdditionY(), this.location.getZ() + 0.5, MysteryBoxesMessages.hologramLineTwo);
                this.holograms.set(1, hologram2);
            }
            return;
        }
        NMSArmorStand hologram1 = GadgetsMenu.getNMSManager().spawnNMSArmorStand(this.location.getWorld(), this.location.getX() + 0.5, this.location.getY() + EnumHologramAdditionY.getAdditionY() + 0.24, this.location.getZ() + 0.5, MysteryBoxesMessages.hologramLineOne);
        NMSArmorStand hologram2 = GadgetsMenu.getNMSManager().spawnNMSArmorStand(this.location.getWorld(), this.location.getX() + 0.5, this.location.getY() + EnumHologramAdditionY.getAdditionY(), this.location.getZ() + 0.5, MysteryBoxesMessages.hologramLineTwo);
        this.holograms.add(hologram1);
        this.holograms.add(hologram2);
    }

    public void removeHolograms() {
        for (NMSArmorStand armorStand : this.holograms) {
            if (armorStand.isDeadNMS()) continue;
            armorStand.killEntityNMS();
        }
    }

    public List<String> getHolograms() {
        ArrayList<String> holograms = new ArrayList<String>();
        for (NMSArmorStand armorStand : this.holograms) {
            holograms.add(armorStand.getCustomNameNMS());
        }
        return holograms;
    }

    public NMSArmorStand getIndividualHologram() {
        return this.individualHologram;
    }

    public void createIndividualHologram() {
        NMSArmorStand hologram;
        if (this.individualHologram != null && !this.individualHologram.isDeadNMS()) {
            this.individualHologram.killEntityNMS();
        }
        if (!this.displayIndividualHologram) {
            return;
        }
        if (!MysteryVaultManager.isIndividualHologramEnabled()) {
            return;
        }
        String hologramDetails = MysteryVaultManager.getAvailableMysteryBoxesHolograms().get(0);
        if (hologramDetails == null) {
            hologramDetails = "";
        }
        this.individualHologram = hologram = GadgetsMenu.getNMSManager().spawnNMSArmorStand(this.location.getWorld(), this.location.getX() + 0.5, this.location.getY() + EnumHologramAdditionY.getAdditionY() + 0.55, this.location.getZ() + 0.5, ChatUtil.format(hologramDetails + ChatUtil.randomColor("")));
    }

    public void refreshIndividualHologram(int num) {
        if (!this.displayIndividualHologram) {
            return;
        }
        if (!MysteryVaultManager.isIndividualHologramEnabled()) {
            return;
        }
        if (this.individualHologram == null) {
            this.createIndividualHologram();
            return;
        }
        if (MysteryVaultManager.getAvailableMysteryBoxesHolograms().size() < num + 1) {
            return;
        }
        String hologramDetails = MysteryVaultManager.getAvailableMysteryBoxesHolograms().get(num);
        if (hologramDetails == null) {
            hologramDetails = "";
        }
        this.individualHologram.setCustomNameNMS(ChatUtil.format(hologramDetails + ChatUtil.randomColor("")));
    }

    public void removeIndividualHologram() {
        if (this.individualHologram != null && !this.individualHologram.isDeadNMS()) {
            this.individualHologram.killEntityNMS();
            this.individualHologram = null;
        }
    }

    public boolean displayIndividualHologram() {
        return this.displayIndividualHologram;
    }

    public void enableIndividualHologram(boolean enable) {
        if (this.displayIndividualHologram) {
            if (!enable) {
                this.displayIndividualHologram = false;
                this.removeIndividualHologram();
            }
        } else if (enable) {
            this.displayIndividualHologram = true;
            this.createIndividualHologram();
        }
    }

    public void createLootHologram(String name) {
        NMSArmorStand lootHologram;
        this.removeLootHologram();
        double addY = EnumHologramAdditionY.getAdditionY() + 0.86;
        if (!this.displayIndividualHologram || !MysteryVaultManager.isIndividualHologramEnabled()) {
            addY = EnumHologramAdditionY.getAdditionY() + 0.55;
        }
        this.lootHologram = lootHologram = GadgetsMenu.getNMSManager().spawnNMSArmorStand(this.location.getWorld(), this.location.getX() + 0.5, this.location.getY() + addY, this.location.getZ() + 0.5, name == null ? "&cERROR" : name);
    }

    public void removeLootHologram() {
        if (this.lootHologram != null) {
            if (!this.lootHologram.isDeadNMS()) {
                this.lootHologram.killEntityNMS();
            }
            this.lootHologram = null;
        }
    }

    public void removeLootHologram(int delay) {
        new BukkitRunnable(){

            public void run() {
                if (MysteryVaultManager.activatedVaults().contains((Object)this)) {
                    return;
                }
                if (MysteryVault.this.lootHologram != null) {
                    if (!MysteryVault.this.lootHologram.isDeadNMS()) {
                        MysteryVault.this.lootHologram.killEntityNMS();
                    }
                    MysteryVault.this.lootHologram = null;
                }
            }
        }.runTaskLater((Plugin)GadgetsMenu.getInstance(), (long)(delay * 20));
    }

    private static enum EnumHologramAdditionY {
        v1_8(0.26, 8),
        v1_9(1.14, 9),
        v1_10(1.14, 10);

        private double increasement = 1.21;
        private int requiredVersion;
        private static double incrementY;

        private EnumHologramAdditionY(double increasement, int requiredVersion) {
            this.increasement = increasement;
            this.requiredVersion = requiredVersion;
        }

        public double getIncreasement() {
            return this.increasement;
        }

        public int getRequiredVersion() {
            return this.requiredVersion;
        }

        public static double getAdditionY() {
            if (incrementY != 0.0) {
                return incrementY;
            }
            if (FileManager.getMysteryBoxesFile().get("Mystery-Boxes.Holograms.Hologram-Height") == null) {
                if (FileManager.getMysteryBoxesFile().get("Mystery-Boxes.Holograms.Y-Increment") != null) {
                    incrementY = FileManager.getMysteryBoxesFile().getDouble("Mystery-Boxes.Holograms.Y-Increment");
                    FileManager.getMysteryBoxesFile().set("Mystery-Boxes.Holograms.Hologram-Height", incrementY);
                    FileManager.getMysteryBoxesFile().set("Mystery-Boxes.Holograms.Y-Increment", null);
                    return incrementY;
                }
                for (EnumHologramAdditionY addition : EnumHologramAdditionY.values()) {
                    if (addition.getRequiredVersion() != ServerVersion.getServerVersion().getCurrentVersionNumber()) continue;
                    incrementY = addition.getIncreasement();
                    break;
                }
                if (incrementY == 0.0) {
                    incrementY = 1.21;
                }
                FileManager.getMysteryBoxesFile().set("Mystery-Boxes.Holograms.Hologram-Height", incrementY);
                return incrementY;
            }
            incrementY = FileManager.getMysteryBoxesFile().getDouble("Mystery-Boxes.Holograms.Hologram-Height");
            return incrementY;
        }
    }
}

