/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Quality;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.MysteryVault;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.MysteryVaultManager;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.AnimationType;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class Animation {
    private PlayerManager pManager;
    private MysteryVault mysteryVault;
    private AnimationType animation;
    private Quality quality;
    private long delay;
    protected int steps = 0;
    protected boolean isContinue = true;

    public Animation(PlayerManager pManager, final MysteryVault mysteryVault, AnimationType animation, Quality quality, long delay) {
        this.mysteryVault = mysteryVault;
        this.animation = animation;
        this.quality = quality;
        this.delay = delay;
        if (!Bukkit.getServer().getWorlds().contains(this.mysteryVault.getLocation().getWorld())) {
            return;
        }
        if (pManager != null) {
            this.pManager = pManager;
            if (PermissionUtils.noPermission(pManager.getPlayer(), animation.getPermission(), EnumPermission.ALL_MYSTERY_VAULT_ANIMATIONS.getPermission(), true)) {
                if (MysteryVaultManager.activatedVaults().contains(mysteryVault)) {
                    MysteryVaultManager.activatedVaults().remove(mysteryVault);
                }
                pManager.setOpeningMysteryBox(false);
                return;
            }
            this.onStart();
            this.playSound();
            BukkitRunnable runnable = new BukkitRunnable(){

                public void run() {
                    if (Animation.this.getPlayer() == null || !Animation.this.getPlayer().isOnline()) {
                        Animation.this.clear();
                        this.cancel();
                        return;
                    }
                    if (!Animation.this.isContinue) {
                        if (MysteryVaultManager.activatedVaults().contains(mysteryVault)) {
                            MysteryVaultManager.activatedVaults().remove(mysteryVault);
                        }
                        this.cancel();
                        return;
                    }
                    try {
                        Animation.this.onUpdate();
                        Animation.this.onUpdateParticleEffect();
                        Animation.this.onUpdateSound();
                        ++Animation.this.steps;
                    }
                    catch (NullPointerException e) {
                        e.printStackTrace();
                        Animation.this.clear();
                        this.cancel();
                    }
                }
            };
            runnable.runTaskTimer((Plugin)GadgetsMenu.getInstance(), delay, animation.getRepeatDelay());
        }
    }

    protected PlayerManager getPlayerManager() {
        return this.pManager;
    }

    protected Player getPlayer() {
        return this.pManager.getPlayer();
    }

    public MysteryVault getMysteryVault() {
        return this.mysteryVault;
    }

    public Quality getQuality() {
        return this.quality;
    }

    public AnimationType getAnimation() {
        return this.animation;
    }

    public long getDelay() {
        return this.delay;
    }

    public abstract void onStart();

    public abstract void onUpdate();

    protected void playSound() {
    }

    public abstract void onUpdateParticleEffect();

    public abstract void onUpdateSound();

    public abstract void onClear();

    public void clear() {
        if (this.pManager == null) {
            return;
        }
        if (MysteryVaultManager.activatedVaults().contains(this.mysteryVault)) {
            MysteryVaultManager.activatedVaults().remove(this.mysteryVault);
        }
        this.pManager.setOpeningMysteryBox(false);
        this.isContinue = false;
    }
}

