/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.MathUtil;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Quality;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.MysteryVault;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.MysteryVaultManager;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.AnimationType;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.GMiniBlock;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.types.Animation;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class CountdownAnimation
extends Animation {
    private static HashMap<Integer, HashSet<Vector>> vectorList = new HashMap();
    private ArmorStand armorStand;
    private int count = 5;
    private static float volume = 0.05f;
    private static int pixelStepX = 1;
    private static int pixelStepY = 1;
    private static boolean x = true;
    private static boolean O = false;
    private static boolean[][] shape = new boolean[][]{{O, O, O, O, x, O, O, O, O, O, O, O, O, O, O, x, O, O, O, O, O}, {O, O, O, O, x, O, O, O, O, O, O, O, O, O, O, x, O, O, O, O, O}, {O, O, O, O, x, O, O, O, O, O, O, O, O, O, O, x, O, O, O, O, O}, {O, O, O, O, x, O, O, O, O, O, O, O, O, O, O, x, O, O, O, O, O}, {O, O, O, O, x, O, O, O, O, O, O, O, O, O, O, x, O, O, O, O, O}, {O, O, O, O, x, O, O, O, O, O, O, O, O, O, O, x, O, O, O, O, O}, {O, O, O, O, x, O, O, O, O, O, O, O, O, O, O, x, O, O, O, O, O}, {O, O, O, O, x, O, O, O, O, O, O, O, O, O, O, x, O, O, O, O, O}, {O, O, O, O, x, O, O, O, O, O, O, O, O, O, O, x, O, O, O, O, O}, {O, O, O, O, x, O, O, O, O, O, O, O, O, O, O, x, O, O, O, O, O}, {O, O, O, O, x, O, O, O, O, O, O, O, O, O, O, x, O, O, O, O, O}, {O, O, O, O, x, O, O, O, O, O, O, O, O, O, O, x, O, O, O, O, O}, {O, O, O, O, x, O, O, O, O, O, O, O, O, O, O, x, O, O, O, O, O}, {O, O, O, O, x, O, O, O, O, O, O, O, O, O, O, x, O, O, O, O, O}, {O, O, O, O, x, O, O, O, O, O, O, O, O, O, O, x, O, O, O, O, O}, {O, O, O, O, x, O, O, O, O, O, O, O, O, O, O, x, O, O, O, O, O}, {O, O, O, O, x, O, O, O, O, O, O, O, O, O, O, x, O, O, O, O, O}, {O, O, O, O, x, O, O, O, O, O, O, O, O, O, O, x, O, O, O, O, O}};
    private BlockFace blockFace = this.getMysteryVault().getBlockFace();
    private static float[] pitch = new float[]{0.5f, 0.529732f, 0.561231f, 0.594604f, 0.629961f, 0.66742f, 0.707107f, 0.749154f, 0.793701f, 0.840896f, 0.890899f, 0.943874f, 1.0f, 1.059463f, 1.122462f, 1.189207f, 1.259921f, 1.33484f, 1.414214f, 1.498307f, 1.587401f, 1.681793f, 1.781797f, 1.887749f, 2.0f};

    public CountdownAnimation(PlayerManager pManager, MysteryVault mysteryVault, Quality quality, long delay) {
        super(pManager, mysteryVault, AnimationType.COUNTDOWN, quality, delay);
        if (vectorList.isEmpty()) {
            for (int i = 0; i <= 5; ++i) {
                BufferedImage image = this.stringToBufferedImage(new Font("Tahoma", 0, 16), String.valueOf(i));
                vectorList.put(i, new HashSet());
                for (int y = 0; y < image.getHeight(); y += pixelStepY) {
                    for (int x = 0; x < image.getWidth(); x += pixelStepX) {
                        int filter = image.getRGB(x, y);
                        if (Color.black.getRGB() != filter) continue;
                        Vector v2 = new Vector((float)image.getWidth() / 2.0f - (float)x, (float)image.getHeight() / 2.0f - (float)y, 0.0f).multiply(0.14285715f);
                        v2 = MathUtil.rotateVector(v2, 0.0, 0.0, 0.0);
                        vectorList.get(i).add(v2);
                    }
                }
            }
        }
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onUpdate() {
        Location loc;
        if (this.steps <= 100 && this.steps % 20 == 0) {
            this.drawEffect(this.count, ParticleEffect.FLAME, this.getMysteryVault().getLocation(), this.blockFace);
            --this.count;
        }
        if (this.steps == 101) {
            Location location = this.getMysteryVault().getLocation();
            location = new Location(location.getWorld(), location.getX() + 0.5, location.getY() - 0.4, location.getZ() + 0.5, GMiniBlock.getYawByBlockFace(this.blockFace), 0.0f);
            ArmorStand miniBlock = (ArmorStand)this.getPlayer().getWorld().spawnEntity(location.clone(), EntityType.ARMOR_STAND);
            miniBlock.setVisible(false);
            miniBlock.setGravity(false);
            miniBlock.setSmall(true);
            try {
                miniBlock.setMarker(false);
                miniBlock.setCollidable(false);
                miniBlock.setSilent(true);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            miniBlock.setHelmet(this.getAnimation().getMiniBlock().getItemStack());
            miniBlock.setBasePlate(false);
            miniBlock.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
            this.armorStand = miniBlock;
        }
        if (this.steps > 101 && this.steps <= 116) {
            loc = this.armorStand.getLocation().clone();
            loc.setY(loc.getY() + 0.05);
            this.armorStand.teleport(loc);
        }
        if (this.steps > 116 && this.steps <= 156) {
            loc = this.armorStand.getLocation().clone();
            double inc = 0.039269908169872414;
            double angle = (double)(this.steps * 4) * inc;
            Vector v = new Vector();
            if (this.blockFace == BlockFace.EAST) {
                v.setX(Math.sin(angle) * 0.3 / 4.0);
                v.setZ(-(Math.cos(angle) * 0.3) / 4.0);
            } else if (this.blockFace == BlockFace.SOUTH) {
                v.setX(Math.cos(angle) * 0.3 / 4.0);
                v.setZ(Math.sin(angle) * 0.3 / 4.0);
            } else if (this.blockFace == BlockFace.WEST) {
                v.setX(-(Math.sin(angle) * 0.3) / 4.0);
                v.setZ(Math.cos(angle) * 0.3 / 4.0);
            } else if (this.blockFace == BlockFace.NORTH) {
                v.setX(-(Math.cos(angle) * 0.3) / 4.0);
                v.setZ(-(Math.sin(angle) * 0.3) / 4.0);
            }
            loc.add(v);
            loc.setY(loc.getY() + 0.05625);
            this.armorStand.teleport(loc);
        }
    }

    @Override
    public void playSound() {
    }

    @Override
    public void onUpdateParticleEffect() {
        if (this.steps > 101 && this.steps <= 156) {
            ParticleEffect.FIREWORKS_SPARK.display(this.armorStand.getEyeLocation().add(0.0, VersionManager.is1_13OrAbove() ? 0.15 : -0.4, 0.0), 1);
            if (this.steps % 4 == 0) {
                ParticleEffect.REDSTONE.displayRandomColor(this.armorStand.getEyeLocation().add(0.0, VersionManager.is1_13OrAbove() ? 0.15 : -0.4, 0.0));
            }
        }
        if (this.steps > 156) {
            ParticleEffect.CRIT_MAGIC.display(this.armorStand.getLocation().clone().add(0.0, 0.8, 0.0), 0.22f, 0.22f, 0.22f);
        }
    }

    @Override
    public void onUpdateSound() {
        if (this.steps <= 100 && this.steps % 20 == 0) {
            SoundEffect.BLOCK_LEVER_CLICK.playSound(this.getMysteryVault().getLocation(), 1.0f, 1.0f);
        }
        if (this.steps == 102) {
            SoundEffect.ENTITY_FIREWORK_ROCKET_LAUNCH.playSound(this.getMysteryVault().getLocation().clone(), 0.4f, 1.0f);
        }
        if (this.steps > 156) {
            if (this.armorStand == null) {
                return;
            }
            if (this.steps <= 180) {
                ParticleEffect.ENCHANTMENT_TABLE.display(this.armorStand.getLocation().clone().add(0.0, 1.9, 0.0), 5.0f, 15);
                SoundEffect.ENTITY_FIREWORK_ROCKET_TWINKLE_FAR.playSound(this.armorStand.getLocation().clone(), volume += 0.006f, 1.0f);
            } else if (this.steps <= 184) {
                SoundEffect.ENTITY_FIREWORK_ROCKET_TWINKLE_FAR.playSound(this.armorStand.getLocation().clone(), 1.0f, 1.0f);
            } else if (this.steps == 230) {
                SoundEffect.ENTITY_GENERIC_EXPLODE.playSound(this.armorStand.getLocation().clone());
            } else if (this.steps == 235) {
                ParticleEffect.LAVA.display(this.armorStand.getLocation().clone().add(0.0, 0.8, 0.0), 0.0f, 45);
                ParticleEffect.FLAME.display(this.armorStand.getLocation().clone().add(0.0, 0.8, 0.0), 0.45f, 40);
            } else if (this.steps == 250) {
                ParticleEffect.CLOUD.display(this.armorStand.getLocation().clone().add(0.0, 0.8, 0.0), 0.7f, 0.7f, 0.7f);
                SoundEffect.ENTITY_EXPERIENCE_ORB_PICKUP.playSound(this.armorStand.getLocation());
            } else if (this.steps > 250 && this.steps < 280) {
                ParticleEffect.CLOUD.display(this.armorStand.getLocation().clone().add(0.0, 0.8, 0.0), 0.7f, 0.7f, 0.7f);
            } else if (this.steps >= 280) {
                this.onClear();
                this.isContinue = false;
            }
        }
        if (this.steps == 101) {
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 6, 0L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 9, 4L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 11, 8L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 13, 12L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 7, 16L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 11, 20L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 13, 24L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 14, 28L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 9, 32L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 12, 36L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 15, 40L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 16, 44L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 10, 48L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 14, 52L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 16, 56L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 18, 60L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HAT, 12, 4L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HAT, 12, 12L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HAT, 12, 20L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HAT, 12, 28L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HAT, 12, 36L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HAT, 12, 44L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HAT, 12, 52L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HAT, 12, 60L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_SNARE, 12, 0L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_SNARE, 12, 8L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_SNARE, 12, 16L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_SNARE, 12, 24L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_SNARE, 12, 32L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_SNARE, 12, 40L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_SNARE, 12, 48L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_SNARE, 12, 56L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 1, 0L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 2, 2L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 3, 4L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 2, 6L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 3, 8L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 5, 10L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 4, 12L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 3, 14L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 5, 16L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 4, 18L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 5, 20L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 4, 22L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 6, 24L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 5, 26L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 4, 28L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 5, 30L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 5, 32L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 4, 34L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 6, 36L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 5, 38L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 6, 40L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 7, 42L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 7, 44L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 6, 46L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 7, 48L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 8, 50L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 7, 52L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 8, 54L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 8, 56L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 9, 58L);
            this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 8, 60L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 16, 0L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 17, 2L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 18, 4L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 15, 6L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 18, 8L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 20, 10L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 19, 12L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 18, 14L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 20, 16L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 19, 18L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 20, 20L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 19, 22L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 21, 24L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 20, 26L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 19, 28L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 20, 30L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 20, 32L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 19, 34L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 21, 36L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 20, 38L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 21, 40L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 22, 42L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 22, 44L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 21, 46L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 22, 48L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 23, 50L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 22, 52L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 23, 54L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 23, 56L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 24, 58L);
            this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 23, 60L);
        }
    }

    private void drawEffect(int count, ParticleEffect particle, Location location, BlockFace blockFace) {
        Location location2 = location.clone().add(0.5, 1.1, 0.5);
        location2.setYaw(this.setYaw(GMiniBlock.getYawByBlockFace(blockFace)));
        location = location.clone().add(0.5, 2.3, 0.5);
        location.setYaw(GMiniBlock.getYawByBlockFace(blockFace) - 180.0f);
        try {
            double defX;
            for (Vector v : vectorList.get(count)) {
                v = MathUtil.rotateVectorYX(v, location.getYaw(), 0.0f);
                particle.display(location.add(v), 0.0f, 1);
                location.subtract(v);
            }
            double space = 0.25;
            double x = defX = location2.getX() - space * (double)shape[0].length / 2.0 + space;
            double y = location2.clone().getY() + 2.8;
            double angle = -((location2.getYaw() + 180.0f) / 60.0f);
            angle += location2.getYaw() < -180.0f ? 3.25 : 2.985;
            for (int i = 0; i < shape.length; ++i) {
                for (int j = 0; j < shape[i].length; ++j) {
                    if (shape[i][j]) {
                        Location target = location2.clone();
                        target.setX(x);
                        target.setY(y);
                        Vector v = target.toVector().subtract(location2.toVector());
                        v = MathUtil.rotateAroundAxisY(v, angle);
                        location2.add(v);
                        for (int k = 0; k < 3; ++k) {
                            ParticleEffect.CRIT.display(location2, 0.0f, 1);
                        }
                        location2.subtract(v);
                    }
                    x += space;
                }
                y -= space;
                x = defX;
            }
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
    }

    private float setYaw(float yaw) {
        if (yaw == -90.0f) {
            return 90.0f;
        }
        if (yaw == 180.0f) {
            return 0.0f;
        }
        return yaw;
    }

    private BufferedImage stringToBufferedImage(Font font, String s) {
        BufferedImage img = new BufferedImage(1, 1, 2);
        Graphics g = img.getGraphics();
        g.setFont(font);
        FontRenderContext frc = g.getFontMetrics().getFontRenderContext();
        Rectangle2D rect = font.getStringBounds(s, frc);
        g.dispose();
        img = new BufferedImage((int)Math.ceil(rect.getWidth()), (int)Math.ceil(rect.getHeight()), 2);
        g = img.getGraphics();
        g.setColor(Color.black);
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        int x = 0;
        int y = fm.getAscent();
        g.drawString(s, x, y);
        g.dispose();
        return img;
    }

    @Override
    public void onClear() {
        if (this.armorStand != null && this.armorStand.isValid()) {
            this.armorStand.remove();
            this.armorStand = null;
        }
        if (MysteryVaultManager.activatedVaults().contains(this.getMysteryVault())) {
            MysteryVaultManager.activatedVaults().remove(this.getMysteryVault());
        }
        this.getPlayerManager().setOpeningMysteryBox(false);
    }

    private void playSound(final SoundEffect sound, final int p, long delay) {
        new BukkitRunnable(){

            public void run() {
                if (CountdownAnimation.this.armorStand == null) {
                    return;
                }
                sound.playSound(CountdownAnimation.this.armorStand.getLocation().clone(), 1.0f, pitch[p]);
            }
        }.runTaskLater((Plugin)GadgetsMenu.getInstance(), delay);
    }
}

