/*
 * Decompiled with CFR 0.152.
 */
package depend.xxmicloxx.NoteBlockAPI.songplayer;

import depend.xxmicloxx.NoteBlockAPI.NoteBlockAPI;
import depend.xxmicloxx.NoteBlockAPI.model.Layer;
import depend.xxmicloxx.NoteBlockAPI.model.Note;
import depend.xxmicloxx.NoteBlockAPI.model.NotePitch;
import depend.xxmicloxx.NoteBlockAPI.model.Song;
import depend.xxmicloxx.NoteBlockAPI.songplayer.RangeSongPlayer;
import depend.xxmicloxx.NoteBlockAPI.utils.InstrumentUtils;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class PositionSongPlayer
extends RangeSongPlayer {
    private Location targetLocation;

    public PositionSongPlayer(Song song) {
        super(song);
    }

    public Location getTargetLocation() {
        return this.targetLocation;
    }

    public void setTargetLocation(Location targetLocation) {
        this.targetLocation = targetLocation;
    }

    @Override
    public void playTick(Player p, int tick) {
        if (!p.getWorld().getName().equals(this.targetLocation.getWorld().getName())) {
            return;
        }
        byte playerVolume = NoteBlockAPI.getPlayerVolume(p);
        for (Layer layer : this.song.getLayerHashMap().values()) {
            Note note = layer.getNote(tick);
            if (note == null) continue;
            float volume = (float)(layer.getVolume() * this.volume * playerVolume * note.getVelocity()) / 1.0E8f * (0.0625f * (float)this.getDistance());
            float pitch = NotePitch.getPitch(note.getKey() - 33);
            p.playSound(this.targetLocation, InstrumentUtils.getInstrument(note.getInstrument()), volume, pitch);
        }
    }

    @Override
    public boolean isInRange(Player player) {
        return player.getLocation().distance(this.targetLocation) <= (double)this.getDistance();
    }
}

