/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.com.mongodb;

import com.grinderwolf.swm.internal.com.mongodb.AcknowledgedBulkWriteResult;
import com.grinderwolf.swm.internal.com.mongodb.BulkWriteException;
import com.grinderwolf.swm.internal.com.mongodb.BulkWriteUpsert;
import com.grinderwolf.swm.internal.com.mongodb.DBObject;
import com.grinderwolf.swm.internal.com.mongodb.DBObjects;
import com.grinderwolf.swm.internal.com.mongodb.MongoBulkWriteException;
import com.grinderwolf.swm.internal.com.mongodb.UnacknowledgedBulkWriteResult;
import com.grinderwolf.swm.internal.com.mongodb.WriteConcernError;
import com.grinderwolf.swm.internal.com.mongodb.bulk.BulkWriteError;
import com.grinderwolf.swm.internal.com.mongodb.bulk.BulkWriteResult;
import com.grinderwolf.swm.internal.org.bson.BsonDocument;
import com.grinderwolf.swm.internal.org.bson.BsonDocumentReader;
import com.grinderwolf.swm.internal.org.bson.codecs.Decoder;
import com.grinderwolf.swm.internal.org.bson.codecs.DecoderContext;
import java.util.ArrayList;
import java.util.List;

final class BulkWriteHelper {
    static com.grinderwolf.swm.internal.com.mongodb.BulkWriteResult translateBulkWriteResult(BulkWriteResult bulkWriteResult, Decoder<DBObject> decoder) {
        if (bulkWriteResult.wasAcknowledged()) {
            return new AcknowledgedBulkWriteResult(bulkWriteResult.getInsertedCount(), bulkWriteResult.getMatchedCount(), bulkWriteResult.getDeletedCount(), bulkWriteResult.getModifiedCount(), BulkWriteHelper.translateBulkWriteUpserts(bulkWriteResult.getUpserts(), decoder));
        }
        return new UnacknowledgedBulkWriteResult();
    }

    static List<BulkWriteUpsert> translateBulkWriteUpserts(List<com.grinderwolf.swm.internal.com.mongodb.bulk.BulkWriteUpsert> upserts, Decoder<DBObject> decoder) {
        ArrayList<BulkWriteUpsert> retVal = new ArrayList<BulkWriteUpsert>(upserts.size());
        for (com.grinderwolf.swm.internal.com.mongodb.bulk.BulkWriteUpsert cur : upserts) {
            retVal.add(new BulkWriteUpsert(cur.getIndex(), BulkWriteHelper.getUpsertedId(cur, decoder)));
        }
        return retVal;
    }

    private static Object getUpsertedId(com.grinderwolf.swm.internal.com.mongodb.bulk.BulkWriteUpsert cur, Decoder<DBObject> decoder) {
        return decoder.decode(new BsonDocumentReader(new BsonDocument("_id", cur.getId())), DecoderContext.builder().build()).get("_id");
    }

    static BulkWriteException translateBulkWriteException(MongoBulkWriteException e, Decoder<DBObject> decoder) {
        return new BulkWriteException(BulkWriteHelper.translateBulkWriteResult(e.getWriteResult(), decoder), BulkWriteHelper.translateWriteErrors(e.getWriteErrors()), BulkWriteHelper.translateWriteConcernError(e.getWriteConcernError()), e.getServerAddress());
    }

    static WriteConcernError translateWriteConcernError(com.grinderwolf.swm.internal.com.mongodb.bulk.WriteConcernError writeConcernError) {
        return writeConcernError == null ? null : new WriteConcernError(writeConcernError.getCode(), writeConcernError.getMessage(), DBObjects.toDBObject(writeConcernError.getDetails()));
    }

    static List<com.grinderwolf.swm.internal.com.mongodb.BulkWriteError> translateWriteErrors(List<BulkWriteError> errors) {
        ArrayList<com.grinderwolf.swm.internal.com.mongodb.BulkWriteError> retVal = new ArrayList<com.grinderwolf.swm.internal.com.mongodb.BulkWriteError>(errors.size());
        for (BulkWriteError cur : errors) {
            retVal.add(new com.grinderwolf.swm.internal.com.mongodb.BulkWriteError(cur.getCode(), cur.getMessage(), DBObjects.toDBObject(cur.getDetails()), cur.getIndex()));
        }
        return retVal;
    }

    private BulkWriteHelper() {
    }
}

