/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.com.mongodb;

import com.grinderwolf.swm.internal.com.mongodb.DBCollection;
import com.grinderwolf.swm.internal.com.mongodb.DBDecoder;
import com.grinderwolf.swm.internal.com.mongodb.DBObject;
import com.grinderwolf.swm.internal.com.mongodb.MongoInternalException;
import com.grinderwolf.swm.internal.com.mongodb.connection.BufferProvider;
import com.grinderwolf.swm.internal.com.mongodb.connection.ByteBufferBsonOutput;
import com.grinderwolf.swm.internal.org.bson.BsonBinaryWriter;
import com.grinderwolf.swm.internal.org.bson.BsonReader;
import com.grinderwolf.swm.internal.org.bson.codecs.Decoder;
import com.grinderwolf.swm.internal.org.bson.codecs.DecoderContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class DBDecoderAdapter
implements Decoder<DBObject> {
    private final DBDecoder decoder;
    private final DBCollection collection;
    private final BufferProvider bufferProvider;

    DBDecoderAdapter(DBDecoder decoder, DBCollection collection, BufferProvider bufferProvider) {
        this.decoder = decoder;
        this.collection = collection;
        this.bufferProvider = bufferProvider;
    }

    @Override
    public DBObject decode(BsonReader reader, DecoderContext decoderContext) {
        ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(this.bufferProvider);
        BsonBinaryWriter binaryWriter = new BsonBinaryWriter(bsonOutput);
        try {
            binaryWriter.pipe(reader);
            BufferExposingByteArrayOutputStream byteArrayOutputStream = new BufferExposingByteArrayOutputStream(binaryWriter.getBsonOutput().getSize());
            bsonOutput.pipe(byteArrayOutputStream);
            DBObject dBObject = this.decoder.decode(byteArrayOutputStream.getInternalBytes(), this.collection);
            return dBObject;
        }
        catch (IOException e) {
            throw new MongoInternalException("An unlikely IOException thrown.", e);
        }
        finally {
            binaryWriter.close();
            bsonOutput.close();
        }
    }

    private static class BufferExposingByteArrayOutputStream
    extends ByteArrayOutputStream {
        BufferExposingByteArrayOutputStream(int size) {
            super(size);
        }

        byte[] getInternalBytes() {
            return this.buf;
        }
    }
}

