/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.com.mongodb;

import com.grinderwolf.swm.internal.com.mongodb.BasicDBList;
import com.grinderwolf.swm.internal.com.mongodb.DBCallback;
import com.grinderwolf.swm.internal.com.mongodb.DBCallbackFactory;
import com.grinderwolf.swm.internal.com.mongodb.DBCollection;
import com.grinderwolf.swm.internal.com.mongodb.DBCollectionObjectFactory;
import com.grinderwolf.swm.internal.com.mongodb.DBObjectFactory;
import com.grinderwolf.swm.internal.com.mongodb.DBRef;
import com.grinderwolf.swm.internal.org.bson.BSONObject;
import com.grinderwolf.swm.internal.org.bson.BasicBSONCallback;
import com.grinderwolf.swm.internal.org.bson.types.BasicBSONList;
import com.grinderwolf.swm.internal.org.bson.types.ObjectId;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DefaultDBCallback
extends BasicBSONCallback
implements DBCallback {
    private final DBObjectFactory objectFactory;
    public static final DBCallbackFactory FACTORY = new DBCallbackFactory(){

        @Override
        public DBCallback create(DBCollection collection) {
            return new DefaultDBCallback(collection);
        }
    };

    public DefaultDBCallback(DBCollection collection) {
        this.objectFactory = collection != null ? collection.getObjectFactory() : new DBCollectionObjectFactory();
    }

    @Override
    public BSONObject create() {
        return this.objectFactory.getInstance();
    }

    @Override
    public BSONObject create(boolean array, List<String> path) {
        return array ? new BasicDBList() : this.objectFactory.getInstance(path != null ? path : Collections.emptyList());
    }

    @Override
    public void gotDBRef(String name, String namespace, ObjectId id) {
        this._put(name, new DBRef(namespace, id));
    }

    @Override
    public Object objectDone() {
        Iterator<String> iterator;
        String name = this.curName();
        BSONObject document = (BSONObject)super.objectDone();
        if (!(document instanceof BasicBSONList) && (iterator = document.keySet().iterator()).hasNext() && iterator.next().equals("$ref") && iterator.hasNext() && iterator.next().equals("$id")) {
            this._put(name, new DBRef((String)document.get("$db"), (String)document.get("$ref"), document.get("$id")));
        }
        return document;
    }
}

