/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.com.mongodb;

import com.grinderwolf.swm.internal.com.mongodb.DBCallback;
import com.grinderwolf.swm.internal.com.mongodb.DBCollection;
import com.grinderwolf.swm.internal.com.mongodb.DBDecoder;
import com.grinderwolf.swm.internal.com.mongodb.DBDecoderFactory;
import com.grinderwolf.swm.internal.com.mongodb.DBObject;
import com.grinderwolf.swm.internal.com.mongodb.LazyDBCallback;
import com.grinderwolf.swm.internal.com.mongodb.lang.Nullable;
import com.grinderwolf.swm.internal.org.bson.BSONCallback;
import com.grinderwolf.swm.internal.org.bson.LazyBSONDecoder;
import java.io.IOException;
import java.io.InputStream;

public class LazyDBDecoder
extends LazyBSONDecoder
implements DBDecoder {
    public static final DBDecoderFactory FACTORY = new DBDecoderFactory(){

        @Override
        public DBDecoder create() {
            return new LazyDBDecoder();
        }
    };

    @Override
    public DBCallback getDBCallback(@Nullable DBCollection collection) {
        return new LazyDBCallback(collection);
    }

    @Override
    public DBObject readObject(InputStream in) throws IOException {
        DBCallback dbCallback = this.getDBCallback(null);
        this.decode(in, (BSONCallback)dbCallback);
        return (DBObject)dbCallback.get();
    }

    @Override
    public DBObject decode(InputStream input, DBCollection collection) throws IOException {
        DBCallback callback = this.getDBCallback(collection);
        this.decode(input, (BSONCallback)callback);
        return (DBObject)callback.get();
    }

    @Override
    public DBObject decode(byte[] bytes, DBCollection collection) {
        DBCallback callback = this.getDBCallback(collection);
        this.decode(bytes, (BSONCallback)callback);
        return (DBObject)callback.get();
    }
}

