/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.com.mongodb;

import com.grinderwolf.swm.internal.com.mongodb.DBCollection;
import com.grinderwolf.swm.internal.com.mongodb.DBObject;
import com.grinderwolf.swm.internal.com.mongodb.WriteRequest;
import com.grinderwolf.swm.internal.com.mongodb.bulk.UpdateRequest;
import com.grinderwolf.swm.internal.com.mongodb.bulk.WriteRequest;
import com.grinderwolf.swm.internal.com.mongodb.client.model.Collation;
import com.grinderwolf.swm.internal.org.bson.BsonDocumentWrapper;
import com.grinderwolf.swm.internal.org.bson.codecs.Encoder;

class ReplaceRequest
extends WriteRequest {
    private final DBObject query;
    private final DBObject document;
    private final boolean upsert;
    private final Encoder<DBObject> codec;
    private final Encoder<DBObject> replacementCodec;
    private final Collation collation;

    ReplaceRequest(DBObject query, DBObject document, boolean upsert, Encoder<DBObject> codec, Encoder<DBObject> replacementCodec, Collation collation) {
        this.query = query;
        this.document = document;
        this.upsert = upsert;
        this.codec = codec;
        this.replacementCodec = replacementCodec;
        this.collation = collation;
    }

    public DBObject getQuery() {
        return this.query;
    }

    public DBObject getDocument() {
        return this.document;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public Collation getCollation() {
        return this.collation;
    }

    @Override
    com.grinderwolf.swm.internal.com.mongodb.bulk.WriteRequest toNew(DBCollection dbCollection) {
        return new UpdateRequest(new BsonDocumentWrapper<DBObject>(this.query, this.codec), new BsonDocumentWrapper<DBObject>(this.document, this.replacementCodec), WriteRequest.Type.REPLACE).upsert(this.isUpsert()).collation(this.getCollation());
    }
}

