/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.com.mongodb;

import com.grinderwolf.swm.internal.com.mongodb.DBCollection;
import com.grinderwolf.swm.internal.com.mongodb.DBObject;
import com.grinderwolf.swm.internal.com.mongodb.WriteRequest;
import com.grinderwolf.swm.internal.com.mongodb.bulk.WriteRequest;
import com.grinderwolf.swm.internal.com.mongodb.client.model.Collation;
import com.grinderwolf.swm.internal.org.bson.BsonDocumentWrapper;
import com.grinderwolf.swm.internal.org.bson.codecs.Encoder;
import java.util.List;

class UpdateRequest
extends WriteRequest {
    private final DBObject query;
    private final DBObject update;
    private final boolean multi;
    private final boolean upsert;
    private final Encoder<DBObject> codec;
    private final Collation collation;
    private final List<? extends DBObject> arrayFilters;

    UpdateRequest(DBObject query, DBObject update, boolean multi, boolean upsert, Encoder<DBObject> codec, Collation collation, List<? extends DBObject> arrayFilters) {
        this.query = query;
        this.update = update;
        this.multi = multi;
        this.upsert = upsert;
        this.codec = codec;
        this.collation = collation;
        this.arrayFilters = arrayFilters;
    }

    public DBObject getQuery() {
        return this.query;
    }

    public DBObject getUpdate() {
        return this.update;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public List<? extends DBObject> getArrayFilters() {
        return this.arrayFilters;
    }

    @Override
    com.grinderwolf.swm.internal.com.mongodb.bulk.WriteRequest toNew(DBCollection dbCollection) {
        return new com.grinderwolf.swm.internal.com.mongodb.bulk.UpdateRequest(new BsonDocumentWrapper<DBObject>(this.query, this.codec), new BsonDocumentWrapper<DBObject>(this.update, this.codec), WriteRequest.Type.UPDATE).upsert(this.isUpsert()).multi(this.isMulti()).collation(this.getCollation()).arrayFilters(dbCollection.wrapAllowNull(this.arrayFilters, this.codec));
    }
}

