/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.com.mongodb.client.internal;

import com.grinderwolf.swm.internal.com.mongodb.MongoNamespace;
import com.grinderwolf.swm.internal.com.mongodb.assertions.Assertions;
import com.grinderwolf.swm.internal.com.mongodb.client.internal.SimpleMongoClient;
import com.grinderwolf.swm.internal.org.bson.BsonDocument;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;

class KeyRetriever
implements Closeable {
    private final SimpleMongoClient client;
    private final boolean ownsClient;
    private final MongoNamespace namespace;

    KeyRetriever(SimpleMongoClient client, boolean ownsClient, MongoNamespace namespace) {
        this.client = Assertions.notNull("client", client);
        this.ownsClient = ownsClient;
        this.namespace = Assertions.notNull("namespace", namespace);
    }

    public List<BsonDocument> find(BsonDocument keyFilter) {
        return this.client.getDatabase(this.namespace.getDatabaseName()).getCollection(this.namespace.getCollectionName(), BsonDocument.class).find(keyFilter).into(new ArrayList());
    }

    @Override
    public void close() {
        if (this.ownsClient) {
            this.client.close();
        }
    }
}

