/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.ninja.leaping.configurate.loader;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.grinderwolf.swm.internal.ninja.leaping.configurate.ConfigurationNode;
import com.grinderwolf.swm.internal.ninja.leaping.configurate.ConfigurationOptions;
import com.grinderwolf.swm.internal.ninja.leaping.configurate.loader.AtomicFiles;
import com.grinderwolf.swm.internal.ninja.leaping.configurate.loader.CommentHandler;
import com.grinderwolf.swm.internal.ninja.leaping.configurate.loader.CommentHandlers;
import com.grinderwolf.swm.internal.ninja.leaping.configurate.loader.ConfigurationLoader;
import com.grinderwolf.swm.internal.ninja.leaping.configurate.loader.HeaderMode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractConfigurationLoader<NodeType extends ConfigurationNode>
implements ConfigurationLoader<NodeType> {
    public static final String CONFIGURATE_LINE_SEPARATOR = "\n";
    protected static final Splitter LINE_SPLITTER = Splitter.on("\n");
    protected static final String SYSTEM_LINE_SEPARATOR = System.lineSeparator();
    protected final @Nullable Callable<BufferedReader> source;
    protected final @Nullable Callable<BufferedWriter> sink;
    private final @NonNull CommentHandler[] commentHandlers;
    private final @NonNull HeaderMode headerMode;
    private final @NonNull ConfigurationOptions defaultOptions;

    protected AbstractConfigurationLoader(@NonNull Builder<?> builder, @NonNull CommentHandler[] commentHandlers) {
        this.source = builder.getSource();
        this.sink = builder.getSink();
        this.headerMode = builder.getHeaderMode();
        this.commentHandlers = commentHandlers;
        this.defaultOptions = builder.getDefaultOptions();
    }

    public @NonNull CommentHandler getDefaultCommentHandler() {
        return this.commentHandlers[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public @NonNull NodeType load(@NonNull ConfigurationOptions options) throws IOException {
        if (this.source == null) {
            throw new IOException("No source present to read from!");
        }
        try (BufferedReader reader = this.source.call();){
            String comment;
            if ((this.headerMode == HeaderMode.PRESERVE || this.headerMode == HeaderMode.NONE) && (comment = CommentHandlers.extractComment(reader, this.commentHandlers)) != null && comment.length() > 0) {
                options = options.setHeader(comment);
            }
            Object node = this.createEmptyNode(options);
            this.loadInternal(node, reader);
            Object NodeType = node;
            return NodeType;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return this.createEmptyNode(options);
        }
        catch (Exception e) {
            if (!(e instanceof IOException)) throw new IOException(e);
            throw (IOException)e;
        }
    }

    protected abstract void loadInternal(NodeType var1, BufferedReader var2) throws IOException;

    @Override
    public void save(@NonNull ConfigurationNode node) throws IOException {
        if (this.sink == null) {
            throw new IOException("No sink present to write to!");
        }
        try (Writer writer = this.sink.call();){
            String header;
            this.writeHeaderInternal(writer);
            if (this.headerMode != HeaderMode.NONE && (header = node.getOptions().getHeader()) != null && !header.isEmpty()) {
                for (String line : this.getDefaultCommentHandler().toComment(ImmutableList.copyOf(LINE_SPLITTER.split(header)))) {
                    writer.write(line);
                    writer.write(SYSTEM_LINE_SEPARATOR);
                }
                writer.write(SYSTEM_LINE_SEPARATOR);
            }
            this.saveInternal(node, writer);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    protected void writeHeaderInternal(Writer writer) throws IOException {
    }

    protected abstract void saveInternal(ConfigurationNode var1, Writer var2) throws IOException;

    @Override
    public @NonNull ConfigurationOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    @Override
    public final boolean canLoad() {
        return this.source != null;
    }

    @Override
    public final boolean canSave() {
        return this.sink != null;
    }

    protected static abstract class Builder<T extends Builder> {
        protected @NonNull HeaderMode headerMode = HeaderMode.PRESERVE;
        protected @Nullable Callable<BufferedReader> source;
        protected @Nullable Callable<BufferedWriter> sink;
        protected @NonNull ConfigurationOptions defaultOptions = ConfigurationOptions.defaults();

        protected Builder() {
        }

        private @NonNull T self() {
            return (T)this;
        }

        public @NonNull T setFile(@NonNull File file) {
            return this.setPath(Objects.requireNonNull(file, "file").toPath());
        }

        public @NonNull T setPath(@NonNull Path path) {
            Path absPath = Objects.requireNonNull(path, "path").toAbsolutePath();
            this.source = () -> Files.newBufferedReader(absPath, StandardCharsets.UTF_8);
            this.sink = AtomicFiles.createAtomicWriterFactory(absPath, StandardCharsets.UTF_8);
            return this.self();
        }

        public @NonNull T setURL(@NonNull URL url) {
            Objects.requireNonNull(url, "url");
            this.source = () -> new BufferedReader(new InputStreamReader(url.openConnection().getInputStream(), StandardCharsets.UTF_8));
            return this.self();
        }

        public @NonNull T setSource(@Nullable Callable<BufferedReader> source) {
            this.source = source;
            return this.self();
        }

        public @NonNull T setSink(@Nullable Callable<BufferedWriter> sink) {
            this.sink = sink;
            return this.self();
        }

        public @Nullable Callable<BufferedReader> getSource() {
            return this.source;
        }

        public @Nullable Callable<BufferedWriter> getSink() {
            return this.sink;
        }

        public @NonNull T setHeaderMode(@NonNull HeaderMode mode) {
            this.headerMode = Objects.requireNonNull(mode, "mode");
            return this.self();
        }

        public @NonNull HeaderMode getHeaderMode() {
            return this.headerMode;
        }

        @Deprecated
        public @NonNull T setPreservesHeader(boolean preservesHeader) {
            this.headerMode = preservesHeader ? HeaderMode.PRESERVE : HeaderMode.PRESET;
            return this.self();
        }

        @Deprecated
        public boolean preservesHeader() {
            return this.headerMode == HeaderMode.PRESERVE;
        }

        public @NonNull T setDefaultOptions(@NonNull ConfigurationOptions defaultOptions) {
            this.defaultOptions = Objects.requireNonNull(defaultOptions, "defaultOptions");
            return this.self();
        }

        public @NonNull ConfigurationOptions getDefaultOptions() {
            return this.defaultOptions;
        }

        public abstract @NonNull AbstractConfigurationLoader build();
    }
}

