/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.ninja.leaping.configurate.util;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class EnumLookup {
    private static final LoadingCache<Class<? extends Enum<?>>, Map<String, Enum<?>>> ENUM_FIELD_CACHE = CacheBuilder.newBuilder().weakKeys().maximumSize(512L).build(new CacheLoader<Class<? extends Enum<?>>, Map<String, Enum<?>>>(){

        @Override
        public Map<String, Enum<?>> load(Class<? extends Enum<?>> key) {
            HashMap ret = new HashMap();
            for (Enum<?> field : key.getEnumConstants()) {
                ret.put(field.name(), field);
                ret.putIfAbsent(EnumLookup.processKey(field.name()), field);
            }
            return ImmutableMap.copyOf(ret);
        }
    });

    private EnumLookup() {
    }

    private static @NonNull String processKey(@NonNull String key) {
        return "\ud83c\udf38" + key.toLowerCase().replace("_", "");
    }

    public static <T extends Enum<T>> @NonNull Optional<T> lookupEnum(@NonNull Class<T> clazz, @NonNull String key) {
        Preconditions.checkNotNull(clazz, "clazz");
        Preconditions.checkNotNull(key, "key");
        try {
            Map<String, Enum<?>> vals = ENUM_FIELD_CACHE.get(clazz);
            Enum<?> possibleRet = vals.get(key);
            if (possibleRet != null) {
                return Optional.of(possibleRet);
            }
            return Optional.ofNullable(vals.get(EnumLookup.processKey(key)));
        }
        catch (ExecutionException e) {
            return Optional.empty();
        }
    }
}

