/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.org.bson.codecs;

import com.grinderwolf.swm.internal.org.bson.BsonBinarySubType;
import com.grinderwolf.swm.internal.org.bson.BsonReader;
import com.grinderwolf.swm.internal.org.bson.BsonType;
import com.grinderwolf.swm.internal.org.bson.BsonWriter;
import com.grinderwolf.swm.internal.org.bson.Transformer;
import com.grinderwolf.swm.internal.org.bson.assertions.Assertions;
import com.grinderwolf.swm.internal.org.bson.codecs.BsonTypeClassMap;
import com.grinderwolf.swm.internal.org.bson.codecs.BsonTypeCodecMap;
import com.grinderwolf.swm.internal.org.bson.codecs.BsonValueCodecProvider;
import com.grinderwolf.swm.internal.org.bson.codecs.Codec;
import com.grinderwolf.swm.internal.org.bson.codecs.DecoderContext;
import com.grinderwolf.swm.internal.org.bson.codecs.DocumentCodecProvider;
import com.grinderwolf.swm.internal.org.bson.codecs.EncoderContext;
import com.grinderwolf.swm.internal.org.bson.codecs.IterableCodecProvider;
import com.grinderwolf.swm.internal.org.bson.codecs.MapCodecProvider;
import com.grinderwolf.swm.internal.org.bson.codecs.ValueCodecProvider;
import com.grinderwolf.swm.internal.org.bson.codecs.configuration.CodecRegistries;
import com.grinderwolf.swm.internal.org.bson.codecs.configuration.CodecRegistry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class MapCodec
implements Codec<Map<String, Object>> {
    private static final CodecRegistry DEFAULT_REGISTRY = CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new BsonValueCodecProvider(), new DocumentCodecProvider(), new IterableCodecProvider(), new MapCodecProvider()));
    private static final BsonTypeClassMap DEFAULT_BSON_TYPE_CLASS_MAP = new BsonTypeClassMap();
    private final BsonTypeCodecMap bsonTypeCodecMap;
    private final CodecRegistry registry;
    private final Transformer valueTransformer;

    public MapCodec() {
        this(DEFAULT_REGISTRY);
    }

    public MapCodec(CodecRegistry registry) {
        this(registry, DEFAULT_BSON_TYPE_CLASS_MAP);
    }

    public MapCodec(CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap) {
        this(registry, bsonTypeClassMap, null);
    }

    public MapCodec(CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap, Transformer valueTransformer) {
        this.registry = Assertions.notNull("registry", registry);
        this.bsonTypeCodecMap = new BsonTypeCodecMap(Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap), registry);
        this.valueTransformer = valueTransformer != null ? valueTransformer : new Transformer(){

            @Override
            public Object transform(Object value) {
                return value;
            }
        };
    }

    @Override
    public void encode(BsonWriter writer, Map<String, Object> map, EncoderContext encoderContext) {
        writer.writeStartDocument();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            writer.writeName(entry.getKey());
            this.writeValue(writer, encoderContext, entry.getValue());
        }
        writer.writeEndDocument();
    }

    @Override
    public Map<String, Object> decode(BsonReader reader, DecoderContext decoderContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = reader.readName();
            map.put(fieldName, this.readValue(reader, decoderContext));
        }
        reader.readEndDocument();
        return map;
    }

    @Override
    public Class<Map<String, Object>> getEncoderClass() {
        return Map.class;
    }

    private Object readValue(BsonReader reader, DecoderContext decoderContext) {
        BsonType bsonType = reader.getCurrentBsonType();
        if (bsonType == BsonType.NULL) {
            reader.readNull();
            return null;
        }
        if (bsonType == BsonType.ARRAY) {
            return decoderContext.decodeWithChildContext(this.registry.get(List.class), reader);
        }
        if (bsonType == BsonType.BINARY && BsonBinarySubType.isUuid(reader.peekBinarySubType()) && reader.peekBinarySize() == 16) {
            return decoderContext.decodeWithChildContext(this.registry.get(UUID.class), reader);
        }
        return this.valueTransformer.transform(this.bsonTypeCodecMap.get(bsonType).decode(reader, decoderContext));
    }

    private void writeValue(BsonWriter writer, EncoderContext encoderContext, Object value) {
        if (value == null) {
            writer.writeNull();
        } else {
            Codec<?> codec = this.registry.get(value.getClass());
            encoderContext.encodeWithChildContext(codec, writer, value);
        }
    }
}

