/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.org.bson.codecs.pojo;

import com.grinderwolf.swm.internal.org.bson.codecs.Codec;
import com.grinderwolf.swm.internal.org.bson.codecs.configuration.CodecRegistry;
import com.grinderwolf.swm.internal.org.bson.codecs.pojo.CollectionPropertyCodecProvider;
import com.grinderwolf.swm.internal.org.bson.codecs.pojo.EnumPropertyCodecProvider;
import com.grinderwolf.swm.internal.org.bson.codecs.pojo.FallbackPropertyCodecProvider;
import com.grinderwolf.swm.internal.org.bson.codecs.pojo.MapPropertyCodecProvider;
import com.grinderwolf.swm.internal.org.bson.codecs.pojo.PojoCodec;
import com.grinderwolf.swm.internal.org.bson.codecs.pojo.PropertyCodecProvider;
import com.grinderwolf.swm.internal.org.bson.codecs.pojo.PropertyCodecRegistry;
import com.grinderwolf.swm.internal.org.bson.codecs.pojo.TypeWithTypeParameters;
import java.util.ArrayList;
import java.util.List;

class PropertyCodecRegistryImpl
implements PropertyCodecRegistry {
    private final List<PropertyCodecProvider> propertyCodecProviders;

    PropertyCodecRegistryImpl(PojoCodec<?> pojoCodec, CodecRegistry codecRegistry, List<PropertyCodecProvider> propertyCodecProviders) {
        ArrayList<PropertyCodecProvider> augmentedProviders = new ArrayList<PropertyCodecProvider>();
        if (propertyCodecProviders != null) {
            augmentedProviders.addAll(propertyCodecProviders);
        }
        augmentedProviders.add(new CollectionPropertyCodecProvider());
        augmentedProviders.add(new MapPropertyCodecProvider());
        augmentedProviders.add(new EnumPropertyCodecProvider(codecRegistry));
        augmentedProviders.add(new FallbackPropertyCodecProvider(pojoCodec, codecRegistry));
        this.propertyCodecProviders = augmentedProviders;
    }

    public <S> Codec<S> get(TypeWithTypeParameters<S> type) {
        for (PropertyCodecProvider propertyCodecProvider : this.propertyCodecProviders) {
            Codec<S> codec = propertyCodecProvider.get(type, this);
            if (codec == null) continue;
            return codec;
        }
        return null;
    }
}

