/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.nms;

import com.github.luben.zstd.Zstd;
import com.grinderwolf.swm.api.exceptions.WorldAlreadyExistsException;
import com.grinderwolf.swm.api.loaders.SlimeLoader;
import com.grinderwolf.swm.api.utils.SlimeFormat;
import com.grinderwolf.swm.api.world.SlimeChunk;
import com.grinderwolf.swm.api.world.SlimeChunkSection;
import com.grinderwolf.swm.api.world.SlimeWorld;
import com.grinderwolf.swm.api.world.properties.SlimeProperties;
import com.grinderwolf.swm.api.world.properties.SlimePropertyMap;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundMap;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.ListTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.Tag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.TagType;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.stream.NBTOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Difficulty;

public class CraftSlimeWorld
implements SlimeWorld {
    private SlimeLoader loader;
    private final String name;
    private final Map<Long, SlimeChunk> chunks;
    private final CompoundTag extraData;
    private final List<CompoundTag> worldMaps;
    private byte version;
    private final SlimePropertyMap propertyMap;
    private final boolean readOnly;
    private final boolean locked;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SlimeChunk getChunk(int x, int z) {
        Map<Long, SlimeChunk> map = this.chunks;
        synchronized (map) {
            Long index = (long)z * Integer.MAX_VALUE + (long)x;
            return this.chunks.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateChunk(SlimeChunk chunk) {
        if (!chunk.getWorldName().equals(this.getName())) {
            throw new IllegalArgumentException("Chunk (" + chunk.getX() + ", " + chunk.getZ() + ") belongs to world '" + chunk.getWorldName() + "', not to '" + this.getName() + "'!");
        }
        Map<Long, SlimeChunk> map = this.chunks;
        synchronized (map) {
            this.chunks.put((long)chunk.getZ() * Integer.MAX_VALUE + (long)chunk.getX(), chunk);
        }
    }

    @Override
    public SlimeWorld clone(String worldName) {
        try {
            return this.clone(worldName, null);
        }
        catch (WorldAlreadyExistsException | IOException ignored) {
            return null;
        }
    }

    @Override
    public SlimeWorld clone(String worldName, SlimeLoader loader) throws WorldAlreadyExistsException, IOException {
        return this.clone(worldName, loader, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SlimeWorld clone(String worldName, SlimeLoader loader, boolean lock) throws WorldAlreadyExistsException, IOException {
        CraftSlimeWorld world;
        if (this.name.equals(worldName)) {
            throw new IllegalArgumentException("The clone world cannot have the same name as the original world!");
        }
        if (worldName == null) {
            throw new IllegalArgumentException("The world name cannot be null!");
        }
        if (loader != null && loader.worldExists(worldName)) {
            throw new WorldAlreadyExistsException(worldName);
        }
        Map<Long, SlimeChunk> map = this.chunks;
        synchronized (map) {
            world = new CraftSlimeWorld(loader == null ? this.loader : loader, worldName, new HashMap<Long, SlimeChunk>(this.chunks), this.extraData.clone(), new ArrayList<CompoundTag>(this.worldMaps), this.version, this.propertyMap, loader == null, lock);
        }
        if (loader != null) {
            loader.saveWorld(worldName, world.serialize(), lock);
        }
        return world;
    }

    @Override
    public SlimeWorld.SlimeProperties getProperties() {
        return SlimeWorld.SlimeProperties.builder().spawnX(this.propertyMap.getInt(SlimeProperties.SPAWN_X)).spawnY(this.propertyMap.getInt(SlimeProperties.SPAWN_Y)).spawnZ(this.propertyMap.getInt(SlimeProperties.SPAWN_Z)).environment(this.propertyMap.getString(SlimeProperties.ENVIRONMENT)).pvp(this.propertyMap.getBoolean(SlimeProperties.PVP)).allowMonsters(this.propertyMap.getBoolean(SlimeProperties.ALLOW_MONSTERS)).allowAnimals(this.propertyMap.getBoolean(SlimeProperties.ALLOW_ANIMALS)).difficulty(Difficulty.valueOf((String)this.propertyMap.getString(SlimeProperties.DIFFICULTY).toUpperCase()).getValue()).readOnly(this.readOnly).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize() {
        ArrayList<SlimeChunk> sortedChunks;
        Map<Long, SlimeChunk> map = this.chunks;
        synchronized (map) {
            sortedChunks = new ArrayList<SlimeChunk>(this.chunks.values());
        }
        sortedChunks.sort(Comparator.comparingLong(chunk -> (long)chunk.getZ() * Integer.MAX_VALUE + (long)chunk.getX()));
        sortedChunks.removeIf(chunk -> chunk == null || Arrays.stream(chunk.getSections()).allMatch(Objects::isNull));
        this.extraData.getValue().put("properties", this.propertyMap.toCompound());
        ByteArrayOutputStream outByteStream = new ByteArrayOutputStream();
        DataOutputStream outStream = new DataOutputStream(outByteStream);
        try {
            outStream.write(SlimeFormat.SLIME_HEADER);
            outStream.write(9);
            outStream.writeByte(this.version);
            int minX = sortedChunks.stream().mapToInt(SlimeChunk::getX).min().orElse(0);
            int minZ = sortedChunks.stream().mapToInt(SlimeChunk::getZ).min().orElse(0);
            int maxX = sortedChunks.stream().mapToInt(SlimeChunk::getX).max().orElse(0);
            int maxZ = sortedChunks.stream().mapToInt(SlimeChunk::getZ).max().orElse(0);
            outStream.writeShort(minX);
            outStream.writeShort(minZ);
            int width = maxX - minX + 1;
            int depth = maxZ - minZ + 1;
            outStream.writeShort(width);
            outStream.writeShort(depth);
            BitSet chunkBitset = new BitSet(width * depth);
            for (SlimeChunk chunk2 : sortedChunks) {
                int bitsetIndex = (chunk2.getZ() - minZ) * width + (chunk2.getX() - minX);
                chunkBitset.set(bitsetIndex, true);
            }
            int chunkMaskSize = (int)Math.ceil((double)(width * depth) / 8.0);
            CraftSlimeWorld.writeBitSetAsBytes(outStream, chunkBitset, chunkMaskSize);
            byte[] chunkData = CraftSlimeWorld.serializeChunks(sortedChunks, this.version);
            byte[] compressedChunkData = Zstd.compress(chunkData);
            outStream.writeInt(compressedChunkData.length);
            outStream.writeInt(chunkData.length);
            outStream.write(compressedChunkData);
            List tileEntitiesList = sortedChunks.stream().flatMap(chunk -> chunk.getTileEntities().stream()).collect(Collectors.toList());
            ListTag tileEntitiesNbtList = new ListTag("tiles", TagType.TAG_COMPOUND, tileEntitiesList);
            CompoundTag tileEntitiesCompound = new CompoundTag("", new CompoundMap(Collections.singletonList(tileEntitiesNbtList)));
            byte[] tileEntitiesData = CraftSlimeWorld.serializeCompoundTag(tileEntitiesCompound);
            byte[] compressedTileEntitiesData = Zstd.compress(tileEntitiesData);
            outStream.writeInt(compressedTileEntitiesData.length);
            outStream.writeInt(tileEntitiesData.length);
            outStream.write(compressedTileEntitiesData);
            List entitiesList = sortedChunks.stream().flatMap(chunk -> chunk.getEntities().stream()).collect(Collectors.toList());
            outStream.writeBoolean(!entitiesList.isEmpty());
            if (!entitiesList.isEmpty()) {
                ListTag entitiesNbtList = new ListTag("entities", TagType.TAG_COMPOUND, entitiesList);
                CompoundTag entitiesCompound = new CompoundTag("", new CompoundMap(Collections.singletonList(entitiesNbtList)));
                byte[] entitiesData = CraftSlimeWorld.serializeCompoundTag(entitiesCompound);
                byte[] compressedEntitiesData = Zstd.compress(entitiesData);
                outStream.writeInt(compressedEntitiesData.length);
                outStream.writeInt(entitiesData.length);
                outStream.write(compressedEntitiesData);
            }
            byte[] extra = CraftSlimeWorld.serializeCompoundTag(this.extraData);
            byte[] compressedExtra = Zstd.compress(extra);
            outStream.writeInt(compressedExtra.length);
            outStream.writeInt(extra.length);
            outStream.write(compressedExtra);
            CompoundMap map2 = new CompoundMap();
            map2.put("maps", (Tag<?>)new ListTag<CompoundTag>("maps", TagType.TAG_COMPOUND, this.worldMaps));
            CompoundTag mapsCompound = new CompoundTag("", map2);
            byte[] mapArray = CraftSlimeWorld.serializeCompoundTag(mapsCompound);
            byte[] compressedMapArray = Zstd.compress(mapArray);
            outStream.writeInt(compressedMapArray.length);
            outStream.writeInt(mapArray.length);
            outStream.write(compressedMapArray);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return outByteStream.toByteArray();
    }

    private static void writeBitSetAsBytes(DataOutputStream outStream, BitSet set, int fixedSize) throws IOException {
        byte[] array = set.toByteArray();
        outStream.write(array);
        int chunkMaskPadding = fixedSize - array.length;
        for (int i = 0; i < chunkMaskPadding; ++i) {
            outStream.write(0);
        }
    }

    private static byte[] serializeChunks(List<SlimeChunk> chunks, byte worldVersion) throws IOException {
        ByteArrayOutputStream outByteStream = new ByteArrayOutputStream(16384);
        DataOutputStream outStream = new DataOutputStream(outByteStream);
        for (SlimeChunk chunk : chunks) {
            if (worldVersion >= 4) {
                byte[] heightMaps = CraftSlimeWorld.serializeCompoundTag(chunk.getHeightMaps());
                outStream.writeInt(heightMaps.length);
                outStream.write(heightMaps);
            } else {
                int[] heightMap = chunk.getHeightMaps().getIntArrayValue("heightMap").get();
                for (int i = 0; i < 256; ++i) {
                    outStream.writeInt(heightMap[i]);
                }
            }
            int[] biomes = chunk.getBiomes();
            if (worldVersion >= 4) {
                outStream.writeInt(biomes.length);
            }
            for (int biome : biomes) {
                outStream.writeInt(biome);
            }
            SlimeChunkSection[] sections = chunk.getSections();
            BitSet sectionBitmask = new BitSet(16);
            for (int i = 0; i < sections.length; ++i) {
                sectionBitmask.set(i, sections[i] != null);
            }
            CraftSlimeWorld.writeBitSetAsBytes(outStream, sectionBitmask, 2);
            for (SlimeChunkSection section : sections) {
                if (section == null) continue;
                boolean hasBlockLight = section.getBlockLight() != null;
                outStream.writeBoolean(hasBlockLight);
                if (hasBlockLight) {
                    outStream.write(section.getBlockLight().getBacking());
                }
                if (worldVersion >= 4) {
                    Object palette = section.getPalette().getValue();
                    outStream.writeInt(palette.size());
                    Iterator iterator = palette.iterator();
                    while (iterator.hasNext()) {
                        CompoundTag value = (CompoundTag)iterator.next();
                        byte[] serializedValue = CraftSlimeWorld.serializeCompoundTag(value);
                        outStream.writeInt(serializedValue.length);
                        outStream.write(serializedValue);
                    }
                    long[] blockStates = section.getBlockStates();
                    outStream.writeInt(blockStates.length);
                    for (long value : section.getBlockStates()) {
                        outStream.writeLong(value);
                    }
                } else {
                    outStream.write(section.getBlocks());
                    outStream.write(section.getData().getBacking());
                }
                boolean hasSkyLight = section.getSkyLight() != null;
                outStream.writeBoolean(hasSkyLight);
                if (!hasSkyLight) continue;
                outStream.write(section.getSkyLight().getBacking());
            }
        }
        return outByteStream.toByteArray();
    }

    private static byte[] serializeCompoundTag(CompoundTag tag) throws IOException {
        if (tag == null || tag.getValue().isEmpty()) {
            return new byte[0];
        }
        ByteArrayOutputStream outByteStream = new ByteArrayOutputStream();
        NBTOutputStream outStream = new NBTOutputStream(outByteStream, 0, ByteOrder.BIG_ENDIAN);
        outStream.writeTag(tag);
        return outByteStream.toByteArray();
    }

    @Override
    public SlimeLoader getLoader() {
        return this.loader;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Map<Long, SlimeChunk> getChunks() {
        return this.chunks;
    }

    @Override
    public CompoundTag getExtraData() {
        return this.extraData;
    }

    public List<CompoundTag> getWorldMaps() {
        return this.worldMaps;
    }

    public byte getVersion() {
        return this.version;
    }

    @Override
    public SlimePropertyMap getPropertyMap() {
        return this.propertyMap;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    public void setLoader(SlimeLoader loader) {
        this.loader = loader;
    }

    public void setVersion(byte version) {
        this.version = version;
    }

    public CraftSlimeWorld(SlimeLoader loader, String name, Map<Long, SlimeChunk> chunks, CompoundTag extraData, List<CompoundTag> worldMaps, byte version, SlimePropertyMap propertyMap, boolean readOnly, boolean locked) {
        this.loader = loader;
        this.name = name;
        this.chunks = chunks;
        this.extraData = extraData;
        this.worldMaps = worldMaps;
        this.version = version;
        this.propertyMap = propertyMap;
        this.readOnly = readOnly;
        this.locked = locked;
    }
}

