/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.nms.v1_13_R1;

import com.grinderwolf.swm.api.world.SlimeChunk;
import com.grinderwolf.swm.api.world.SlimeChunkSection;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundMap;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.LongArrayTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.Tag;
import com.grinderwolf.swm.nms.CraftSlimeChunk;
import com.grinderwolf.swm.nms.CraftSlimeWorld;
import com.grinderwolf.swm.nms.v1_13_R1.Converter;
import com.grinderwolf.swm.nms.v1_13_R1.CustomWorldServer;
import com.grinderwolf.swm.nms.v1_13_R1.NMSSlimeChunk;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.server.v1_13_R1.BiomeBase;
import net.minecraft.server.v1_13_R1.Biomes;
import net.minecraft.server.v1_13_R1.Block;
import net.minecraft.server.v1_13_R1.BlockPosition;
import net.minecraft.server.v1_13_R1.Chunk;
import net.minecraft.server.v1_13_R1.ChunkConverter;
import net.minecraft.server.v1_13_R1.ChunkCoordIntPair;
import net.minecraft.server.v1_13_R1.ChunkSection;
import net.minecraft.server.v1_13_R1.ChunkStatus;
import net.minecraft.server.v1_13_R1.Entity;
import net.minecraft.server.v1_13_R1.EntityTypes;
import net.minecraft.server.v1_13_R1.FluidType;
import net.minecraft.server.v1_13_R1.FluidTypes;
import net.minecraft.server.v1_13_R1.GeneratorAccess;
import net.minecraft.server.v1_13_R1.HeightMap;
import net.minecraft.server.v1_13_R1.IChunkAccess;
import net.minecraft.server.v1_13_R1.IChunkLoader;
import net.minecraft.server.v1_13_R1.NBTTagCompound;
import net.minecraft.server.v1_13_R1.ProtoChunk;
import net.minecraft.server.v1_13_R1.ProtoChunkTickList;
import net.minecraft.server.v1_13_R1.RegistryBlocks;
import net.minecraft.server.v1_13_R1.TickList;
import net.minecraft.server.v1_13_R1.TileEntity;
import net.minecraft.server.v1_13_R1.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomChunkLoader
implements IChunkLoader {
    private static final Logger LOGGER = LogManager.getLogger((String)"SWM Chunk Loader");
    private final CraftSlimeWorld world;

    void loadAllChunks(CustomWorldServer server) {
        for (SlimeChunk chunk : new ArrayList<SlimeChunk>(this.world.getChunks().values())) {
            Chunk nmsChunk = this.createChunk(server, chunk);
            this.world.updateChunk(new NMSSlimeChunk(nmsChunk));
        }
    }

    private Chunk createChunk(CustomWorldServer server, SlimeChunk chunk) {
        int x = chunk.getX();
        int z = chunk.getZ();
        LOGGER.debug("Loading chunk (" + x + ", " + z + ") on world " + this.world.getName());
        BlockPosition.MutableBlockPosition mutableBlockPosition = new BlockPosition.MutableBlockPosition();
        ProtoChunkTickList airChunkTickList = new ProtoChunkTickList(block -> block.getBlockData().isAir(), arg_0 -> ((RegistryBlocks)Block.REGISTRY).b(arg_0), arg_0 -> ((RegistryBlocks)Block.REGISTRY).get(arg_0), new ChunkCoordIntPair(x, z));
        ProtoChunkTickList fluidChunkTickList = new ProtoChunkTickList(fluidType -> fluidType == FluidTypes.a, arg_0 -> ((RegistryBlocks)FluidType.c).b(arg_0), arg_0 -> ((RegistryBlocks)FluidType.c).get(arg_0), new ChunkCoordIntPair(x, z));
        BiomeBase[] biomeBaseArray = new BiomeBase[256];
        int[] biomeIntArray = chunk.getBiomes();
        for (int i = 0; i < biomeIntArray.length; ++i) {
            biomeBaseArray[i] = BiomeBase.a((int)biomeIntArray[i]);
            if (biomeBaseArray[i] != null) continue;
            biomeBaseArray[i] = server.getChunkProvider().getChunkGenerator().getWorldChunkManager().getBiome((BlockPosition)mutableBlockPosition.c((i & 0xF) + (x << 4), 0, (i >> 4 & 0xF) + (z << 4)), Biomes.c);
        }
        CompoundTag upgradeDataTag = ((CraftSlimeChunk)chunk).getUpgradeData();
        Chunk nmsChunk = new Chunk((World)server, x, z, biomeBaseArray, upgradeDataTag == null ? ChunkConverter.a : new ChunkConverter((NBTTagCompound)Converter.convertTag(upgradeDataTag)), (TickList)airChunkTickList, (TickList)fluidChunkTickList, 0L);
        nmsChunk.c("postprocessed");
        LOGGER.debug("Loading chunk sections for chunk (" + x + ", " + z + ") on world " + this.world.getName());
        ChunkSection[] sections = new ChunkSection[16];
        for (int sectionId = 0; sectionId < chunk.getSections().length; ++sectionId) {
            SlimeChunkSection slimeSection = chunk.getSections()[sectionId];
            if (slimeSection == null || slimeSection.getBlockStates().length <= 0) continue;
            ChunkSection section = new ChunkSection(sectionId, true);
            LOGGER.debug("ChunkSection #" + sectionId + " - Chunk (" + x + ", " + z + ") - World " + this.world.getName() + ":");
            LOGGER.debug("Block palette:");
            LOGGER.debug(slimeSection.getPalette().toString());
            LOGGER.debug("Block states array:");
            LOGGER.debug((Object)slimeSection.getBlockStates());
            LOGGER.debug("Block light array:");
            LOGGER.debug(slimeSection.getBlockLight() != null ? (Object)slimeSection.getBlockLight().getBacking() : "Not present");
            LOGGER.debug("Sky light array:");
            LOGGER.debug(slimeSection.getSkyLight() != null ? (Object)slimeSection.getSkyLight().getBacking() : "Not present");
            NBTTagCompound sectionCompound = new NBTTagCompound();
            sectionCompound.set("Palette", Converter.convertTag(slimeSection.getPalette()));
            sectionCompound.a("BlockStates", slimeSection.getBlockStates());
            section.getBlocks().a(sectionCompound, "Palette", "BlockStates");
            if (slimeSection.getBlockLight() != null) {
                section.a(Converter.convertArray(slimeSection.getBlockLight()));
            }
            if (slimeSection.getSkyLight() != null) {
                section.b(Converter.convertArray(slimeSection.getSkyLight()));
            }
            section.recalcBlockCounts();
            sections[sectionId] = section;
        }
        nmsChunk.a(sections);
        ChunkSection heightMapTypes = HeightMap.Type.values();
        CompoundMap heightMaps = chunk.getHeightMaps().getValue();
        for (ChunkSection type : heightMapTypes) {
            if (type.c() != HeightMap.Use.LIVE_WORLD) continue;
            String name = type.b();
            if (heightMaps.containsKey(name)) {
                LongArrayTag heightMap = (LongArrayTag)heightMaps.get(name);
                nmsChunk.a((HeightMap.Type)type, heightMap.getValue());
                continue;
            }
            nmsChunk.b((HeightMap.Type)type).a();
        }
        LOGGER.debug("Loading tile entities for chunk (" + x + ", " + z + ") on world " + this.world.getName());
        List<CompoundTag> tileEntities = chunk.getTileEntities();
        int loadedEntities = 0;
        if (tileEntities != null) {
            for (CompoundTag tag : tileEntities) {
                TileEntity entity = TileEntity.create((NBTTagCompound)((NBTTagCompound)Converter.convertTag(tag)));
                if (entity == null) continue;
                nmsChunk.a(entity);
                ++loadedEntities;
            }
        }
        LOGGER.debug("Loaded " + loadedEntities + " tile entities for chunk (" + x + ", " + z + ") on world " + this.world.getName());
        LOGGER.debug("Loading entities for chunk (" + x + ", " + z + ") on world " + this.world.getName());
        List<CompoundTag> entities = chunk.getEntities();
        loadedEntities = 0;
        if (entities != null) {
            for (CompoundTag tag : entities) {
                this.loadEntity(tag, server.getMinecraftWorld(), nmsChunk);
            }
        }
        LOGGER.debug("Loaded " + loadedEntities + " entities for chunk (" + x + ", " + z + ") on world " + this.world.getName());
        LOGGER.debug("Loaded chunk (" + x + ", " + z + ") on world " + this.world.getName());
        return nmsChunk;
    }

    private Entity loadEntity(CompoundTag tag, World world, Chunk chunk) {
        Entity entity = EntityTypes.a((NBTTagCompound)((NBTTagCompound)Converter.convertTag(tag)), (World)world);
        chunk.f(true);
        if (entity != null) {
            chunk.a(entity);
            CompoundMap map = tag.getValue();
            if (map.containsKey("Passengers")) {
                List passengersList = (List)((Tag)map.get("Passengers")).getValue();
                for (CompoundTag passengerTag : passengersList) {
                    Entity passenger = this.loadEntity(passengerTag, world, chunk);
                    if (passengerTag == null) continue;
                    passenger.a(entity, true);
                }
            }
        }
        return entity;
    }

    @Nullable
    public ProtoChunk b(GeneratorAccess generatorAccess, int x, int z, Consumer<IChunkAccess> consumer) {
        Chunk chunk = this.a(generatorAccess, x, z, null);
        consumer.accept((IChunkAccess)chunk);
        return null;
    }

    public Chunk a(GeneratorAccess generatorAccess, int x, int z, Consumer<Chunk> consumer) {
        Chunk chunk;
        SlimeChunk slimeChunk = this.world.getChunk(x, z);
        if (slimeChunk == null) {
            BlockPosition.MutableBlockPosition mutableBlockPosition = new BlockPosition.MutableBlockPosition();
            BiomeBase[] biomeBaseArray = new BiomeBase[256];
            for (int i = 0; i < biomeBaseArray.length; ++i) {
                biomeBaseArray[i] = generatorAccess.getChunkProvider().getChunkGenerator().getWorldChunkManager().getBiome((BlockPosition)mutableBlockPosition.c((i & 0xF) + (x << 4), 0, (i >> 4 & 0xF) + (z << 4)), Biomes.c);
            }
            ProtoChunkTickList airChunkTickList = new ProtoChunkTickList(block -> block.getBlockData().isAir(), arg_0 -> ((RegistryBlocks)Block.REGISTRY).b(arg_0), arg_0 -> ((RegistryBlocks)Block.REGISTRY).get(arg_0), new ChunkCoordIntPair(x, z));
            ProtoChunkTickList fluidChunkTickList = new ProtoChunkTickList(fluidType -> fluidType == FluidTypes.a, arg_0 -> ((RegistryBlocks)FluidType.c).b(arg_0), arg_0 -> ((RegistryBlocks)FluidType.c).get(arg_0), new ChunkCoordIntPair(x, z));
            chunk = new Chunk(generatorAccess.getMinecraftWorld(), x, z, biomeBaseArray, ChunkConverter.a, (TickList)airChunkTickList, (TickList)fluidChunkTickList, 0L);
            chunk.c("postprocessed");
        } else if (slimeChunk instanceof NMSSlimeChunk) {
            chunk = ((NMSSlimeChunk)slimeChunk).getChunk();
        } else {
            throw new IllegalStateException("Chunk (" + x + ", " + z + ") has not been converted to a NMSSlimeChunk object!");
        }
        if (consumer != null) {
            consumer.accept(chunk);
        }
        return chunk;
    }

    public void saveChunk(World world, IChunkAccess chunkAccess) {
        this.saveChunk(world, chunkAccess, false);
    }

    public void saveChunk(World world, IChunkAccess chunkAccess, boolean unloaded) {
        if (chunkAccess.i().d() == ChunkStatus.Type.PROTOCHUNK) {
            return;
        }
        SlimeChunk slimeChunk = this.world.getChunk(chunkAccess.getPos().x, chunkAccess.getPos().z);
        if (slimeChunk instanceof NMSSlimeChunk) {
            ((NMSSlimeChunk)slimeChunk).setChunk((Chunk)chunkAccess);
        } else {
            this.world.updateChunk(new NMSSlimeChunk((Chunk)chunkAccess));
        }
    }

    public void c() {
    }

    public boolean chunkExists(int x, int z) {
        return true;
    }

    public void b() {
    }

    public CustomChunkLoader(CraftSlimeWorld world) {
        this.world = world;
    }
}

