/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.nms.v1_13_R2;

import com.grinderwolf.swm.api.world.SlimeChunk;
import com.grinderwolf.swm.api.world.SlimeChunkSection;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundMap;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.LongArrayTag;
import com.grinderwolf.swm.nms.CraftSlimeChunk;
import com.grinderwolf.swm.nms.CraftSlimeWorld;
import com.grinderwolf.swm.nms.v1_13_R2.Converter;
import com.grinderwolf.swm.nms.v1_13_R2.CustomWorldServer;
import com.grinderwolf.swm.nms.v1_13_R2.NMSSlimeChunk;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.server.v1_13_R2.BiomeBase;
import net.minecraft.server.v1_13_R2.Biomes;
import net.minecraft.server.v1_13_R2.BlockPosition;
import net.minecraft.server.v1_13_R2.Chunk;
import net.minecraft.server.v1_13_R2.ChunkConverter;
import net.minecraft.server.v1_13_R2.ChunkCoordIntPair;
import net.minecraft.server.v1_13_R2.ChunkSection;
import net.minecraft.server.v1_13_R2.ChunkStatus;
import net.minecraft.server.v1_13_R2.DimensionManager;
import net.minecraft.server.v1_13_R2.Entity;
import net.minecraft.server.v1_13_R2.EntityTypes;
import net.minecraft.server.v1_13_R2.FluidTypes;
import net.minecraft.server.v1_13_R2.GeneratorAccess;
import net.minecraft.server.v1_13_R2.HeightMap;
import net.minecraft.server.v1_13_R2.IChunkAccess;
import net.minecraft.server.v1_13_R2.IChunkLoader;
import net.minecraft.server.v1_13_R2.IRegistry;
import net.minecraft.server.v1_13_R2.NBTBase;
import net.minecraft.server.v1_13_R2.NBTTagCompound;
import net.minecraft.server.v1_13_R2.NBTTagList;
import net.minecraft.server.v1_13_R2.PersistentCollection;
import net.minecraft.server.v1_13_R2.ProtoChunk;
import net.minecraft.server.v1_13_R2.ProtoChunkTickList;
import net.minecraft.server.v1_13_R2.TickList;
import net.minecraft.server.v1_13_R2.TileEntity;
import net.minecraft.server.v1_13_R2.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomChunkLoader
implements IChunkLoader {
    private static final Logger LOGGER = LogManager.getLogger((String)"SWM Chunk Loader");
    private final NBTTagCompound emptyWorldCompound = new NBTTagCompound();
    private final CraftSlimeWorld world;

    void loadAllChunks(CustomWorldServer server) {
        for (SlimeChunk chunk : new ArrayList<SlimeChunk>(this.world.getChunks().values())) {
            Object[] data = this.createChunk(server, chunk);
            this.world.updateChunk(new NMSSlimeChunk((Chunk)data[0], (NBTTagCompound)data[1]));
        }
    }

    private Object[] createChunk(CustomWorldServer server, SlimeChunk chunk) {
        int x = chunk.getX();
        int z = chunk.getZ();
        LOGGER.debug("Loading chunk (" + x + ", " + z + ") on world " + this.world.getName());
        Object[] data = new Object[2];
        NBTTagCompound levelCompound = new NBTTagCompound();
        NBTTagCompound globalCompound = new NBTTagCompound();
        globalCompound.set("Level", (NBTBase)levelCompound);
        data[1] = globalCompound;
        BlockPosition.MutableBlockPosition mutableBlockPosition = new BlockPosition.MutableBlockPosition();
        ProtoChunkTickList airChunkTickList = new ProtoChunkTickList(block -> block.getBlockData().isAir(), arg_0 -> ((IRegistry)IRegistry.BLOCK).getKey(arg_0), arg_0 -> ((IRegistry)IRegistry.BLOCK).getOrDefault(arg_0), new ChunkCoordIntPair(x, z));
        ProtoChunkTickList fluidChunkTickList = new ProtoChunkTickList(fluidType -> fluidType == FluidTypes.EMPTY, arg_0 -> ((IRegistry)IRegistry.FLUID).getKey(arg_0), arg_0 -> ((IRegistry)IRegistry.FLUID).getOrDefault(arg_0), new ChunkCoordIntPair(x, z));
        BiomeBase[] biomeBaseArray = new BiomeBase[256];
        int[] biomeIntArray = chunk.getBiomes();
        for (int i = 0; i < biomeIntArray.length; ++i) {
            biomeBaseArray[i] = (BiomeBase)IRegistry.BIOME.fromId(biomeIntArray[i]);
            if (biomeBaseArray[i] != null) continue;
            biomeBaseArray[i] = server.getChunkProvider().getChunkGenerator().getWorldChunkManager().getBiome((BlockPosition)mutableBlockPosition.c((i & 0xF) + (x << 4), 0, (i >> 4 & 0xF) + (z << 4)), Biomes.PLAINS);
        }
        CompoundTag upgradeDataTag = ((CraftSlimeChunk)chunk).getUpgradeData();
        Chunk nmsChunk = new Chunk(server.getMinecraftWorld(), x, z, biomeBaseArray, upgradeDataTag == null ? ChunkConverter.a : new ChunkConverter((NBTTagCompound)Converter.convertTag(upgradeDataTag)), (TickList)airChunkTickList, (TickList)fluidChunkTickList, 0L);
        nmsChunk.c("postprocessed");
        LOGGER.debug("Loading chunk sections for chunk (" + x + ", " + z + ") on world " + this.world.getName());
        ChunkSection[] sections = new ChunkSection[16];
        for (int sectionId = 0; sectionId < chunk.getSections().length; ++sectionId) {
            SlimeChunkSection slimeSection = chunk.getSections()[sectionId];
            if (slimeSection == null || slimeSection.getBlockStates().length <= 0) continue;
            ChunkSection section = new ChunkSection(sectionId << 4, true);
            LOGGER.debug("ChunkSection #" + sectionId + " - Chunk (" + x + ", " + z + ") - World " + this.world.getName() + ":");
            LOGGER.debug("Block palette:");
            LOGGER.debug(slimeSection.getPalette().toString());
            LOGGER.debug("Block states array:");
            LOGGER.debug((Object)slimeSection.getBlockStates());
            LOGGER.debug("Block light array:");
            LOGGER.debug(slimeSection.getBlockLight() != null ? (Object)slimeSection.getBlockLight().getBacking() : "Not present");
            LOGGER.debug("Sky light array:");
            LOGGER.debug(slimeSection.getSkyLight() != null ? (Object)slimeSection.getSkyLight().getBacking() : "Not present");
            NBTTagCompound sectionCompound = new NBTTagCompound();
            sectionCompound.set("Palette", Converter.convertTag(slimeSection.getPalette()));
            sectionCompound.a("BlockStates", slimeSection.getBlockStates());
            section.getBlocks().a(sectionCompound, "Palette", "BlockStates");
            if (slimeSection.getBlockLight() != null) {
                section.a(Converter.convertArray(slimeSection.getBlockLight()));
            }
            if (slimeSection.getSkyLight() != null) {
                section.b(Converter.convertArray(slimeSection.getSkyLight()));
            }
            section.recalcBlockCounts();
            sections[sectionId] = section;
        }
        nmsChunk.a(sections);
        ChunkSection heightMapTypes = HeightMap.Type.values();
        CompoundMap heightMaps = chunk.getHeightMaps().getValue();
        for (ChunkSection type : heightMapTypes) {
            if (type.c() != HeightMap.Use.LIVE_WORLD) continue;
            String name = type.b();
            if (heightMaps.containsKey(name)) {
                LongArrayTag heightMap = (LongArrayTag)heightMaps.get(name);
                nmsChunk.a((HeightMap.Type)type, heightMap.getValue());
                continue;
            }
            nmsChunk.b((HeightMap.Type)type).a();
        }
        if (chunk.getTileEntities() != null) {
            NBTTagList tileEntities = new NBTTagList();
            for (CompoundTag tileEntityTag : chunk.getTileEntities()) {
                tileEntities.add(Converter.convertTag(tileEntityTag));
            }
            levelCompound.set("TileEntities", (NBTBase)tileEntities);
        }
        if (chunk.getEntities() != null) {
            NBTTagList entities = new NBTTagList();
            for (CompoundTag entityTag : chunk.getEntities()) {
                entities.add(Converter.convertTag(entityTag));
            }
            levelCompound.set("Entities", (NBTBase)entities);
        }
        LOGGER.debug("Loaded chunk (" + x + ", " + z + ") on world " + this.world.getName());
        data[0] = nmsChunk;
        return data;
    }

    @Nullable
    public ProtoChunk b(GeneratorAccess generatorAccess, int x, int z, Consumer<IChunkAccess> consumer) {
        Chunk chunk = this.a(generatorAccess, x, z, null);
        consumer.accept((IChunkAccess)chunk);
        return null;
    }

    public Chunk a(GeneratorAccess generatorAccess, int x, int z, Consumer<Chunk> consumer) {
        Object[] chunkData = this.loadChunk(generatorAccess, x, z, consumer);
        Chunk chunk = (Chunk)chunkData[0];
        NBTTagCompound compound = (NBTTagCompound)chunkData[1];
        if (consumer != null) {
            consumer.accept(chunk);
        }
        this.loadEntities(compound.getCompound("Level"), chunk);
        return chunk;
    }

    public Object[] loadChunk(GeneratorAccess generatorAccess, int x, int z, Consumer<Chunk> consumer) {
        Object[] data;
        SlimeChunk slimeChunk = this.world.getChunk(x, z);
        if (slimeChunk == null) {
            data = new Object[2];
            BlockPosition.MutableBlockPosition mutableBlockPosition = new BlockPosition.MutableBlockPosition();
            BiomeBase[] biomeBaseArray = new BiomeBase[256];
            for (int i = 0; i < biomeBaseArray.length; ++i) {
                biomeBaseArray[i] = generatorAccess.getChunkProvider().getChunkGenerator().getWorldChunkManager().getBiome((BlockPosition)mutableBlockPosition.c((i & 0xF) + (x << 4), 0, (i >> 4 & 0xF) + (z << 4)), Biomes.PLAINS);
            }
            ProtoChunkTickList airChunkTickList = new ProtoChunkTickList(block -> block.getBlockData().isAir(), arg_0 -> ((IRegistry)IRegistry.BLOCK).getKey(arg_0), arg_0 -> ((IRegistry)IRegistry.BLOCK).getOrDefault(arg_0), new ChunkCoordIntPair(x, z));
            ProtoChunkTickList fluidChunkTickList = new ProtoChunkTickList(fluidType -> fluidType == FluidTypes.EMPTY, arg_0 -> ((IRegistry)IRegistry.FLUID).getKey(arg_0), arg_0 -> ((IRegistry)IRegistry.FLUID).getOrDefault(arg_0), new ChunkCoordIntPair(x, z));
            Chunk nmsChunk = new Chunk(generatorAccess.getMinecraftWorld(), x, z, biomeBaseArray, ChunkConverter.a, (TickList)airChunkTickList, (TickList)fluidChunkTickList, 0L);
            nmsChunk.c("postprocessed");
            data[0] = nmsChunk;
            data[1] = this.emptyWorldCompound;
        } else if (slimeChunk instanceof NMSSlimeChunk) {
            NMSSlimeChunk nmsSlimeChunk = (NMSSlimeChunk)slimeChunk;
            data = new Object[]{nmsSlimeChunk.getChunk(), nmsSlimeChunk.getCompound()};
        } else {
            throw new IllegalStateException("Chunk (" + x + ", " + z + ") has not been converted to a NMSSlimeChunk object!");
        }
        return data;
    }

    public void getPersistentStructureLegacy(DimensionManager manager, PersistentCollection collection) {
    }

    public void loadEntities(NBTTagCompound compound, Chunk chunk) {
        LOGGER.debug("Loading tile entities for chunk (" + chunk.locX + ", " + chunk.locZ + ") on world " + this.world.getName());
        int loadedEntities = 0;
        if (compound.hasKeyOfType("TileEntities", 9)) {
            NBTTagList tileEntities = compound.getList("TileEntities", 10);
            for (NBTBase tileEntity : tileEntities) {
                TileEntity entity = TileEntity.create((NBTTagCompound)((NBTTagCompound)tileEntity));
                if (entity == null) continue;
                chunk.a(entity);
                ++loadedEntities;
            }
        }
        LOGGER.debug("Loaded " + loadedEntities + " tile entities for chunk (" + chunk.locX + ", " + chunk.locZ + ") on world " + this.world.getName());
        LOGGER.debug("Loading entities for chunk (" + chunk.locX + ", " + chunk.locZ + ") on world " + this.world.getName());
        loadedEntities = 0;
        if (compound.hasKeyOfType("Entities", 9)) {
            NBTTagList entities = compound.getList("Entities", 10);
            for (NBTBase entity : entities) {
                this.loadEntity((NBTTagCompound)entity, chunk);
            }
        }
        LOGGER.debug("Loaded " + loadedEntities + " entities for chunk (" + chunk.locX + ", " + chunk.locZ + ") on world " + this.world.getName());
    }

    private Entity loadEntity(NBTTagCompound tag, Chunk chunk) {
        Entity entity = EntityTypes.a((NBTTagCompound)tag, (World)chunk.getWorld());
        chunk.f(true);
        if (entity != null) {
            chunk.a(entity);
            if (tag.hasKeyOfType("Passengers", 9)) {
                NBTTagList passengersList = tag.getList("Passengers", 10);
                for (NBTBase passengerTag : passengersList) {
                    Entity passenger = this.loadEntity((NBTTagCompound)passengerTag, chunk);
                    if (passengerTag == null) continue;
                    passenger.a(entity, true);
                }
            }
        }
        return entity;
    }

    public void saveChunk(World world, IChunkAccess chunkAccess) {
        this.saveChunk(world, chunkAccess, false);
    }

    public void saveChunk(World world, IChunkAccess chunkAccess, boolean unloaded) {
        if (chunkAccess.i().d() == ChunkStatus.Type.PROTOCHUNK) {
            return;
        }
        SlimeChunk slimeChunk = this.world.getChunk(chunkAccess.getPos().x, chunkAccess.getPos().z);
        if (slimeChunk instanceof NMSSlimeChunk) {
            ((NMSSlimeChunk)slimeChunk).setChunk((Chunk)chunkAccess);
        } else {
            this.world.updateChunk(new NMSSlimeChunk((Chunk)chunkAccess, this.emptyWorldCompound));
        }
    }

    public void b() {
    }

    public CustomChunkLoader(CraftSlimeWorld world) {
        this.emptyWorldCompound.set("Level", (NBTBase)new NBTTagCompound());
        this.world = world;
    }
}

