/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.nms.v1_13_R2;

import com.grinderwolf.swm.api.utils.NibbleArray;
import com.grinderwolf.swm.api.world.SlimeChunk;
import com.grinderwolf.swm.api.world.SlimeChunkSection;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundMap;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.ListTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.LongArrayTag;
import com.grinderwolf.swm.nms.CraftSlimeChunkSection;
import com.grinderwolf.swm.nms.v1_13_R2.Converter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.v1_13_R2.BiomeBase;
import net.minecraft.server.v1_13_R2.Chunk;
import net.minecraft.server.v1_13_R2.ChunkSection;
import net.minecraft.server.v1_13_R2.DataPaletteBlock;
import net.minecraft.server.v1_13_R2.Entity;
import net.minecraft.server.v1_13_R2.HeightMap;
import net.minecraft.server.v1_13_R2.IRegistry;
import net.minecraft.server.v1_13_R2.NBTBase;
import net.minecraft.server.v1_13_R2.NBTTagCompound;
import net.minecraft.server.v1_13_R2.NBTTagList;
import net.minecraft.server.v1_13_R2.TileEntity;

public class NMSSlimeChunk
implements SlimeChunk {
    private Chunk chunk;
    private NBTTagCompound compound;

    @Override
    public String getWorldName() {
        return this.chunk.getWorld().getWorldData().getName();
    }

    @Override
    public int getX() {
        return this.chunk.getPos().x;
    }

    @Override
    public int getZ() {
        return this.chunk.getPos().z;
    }

    @Override
    public SlimeChunkSection[] getSections() {
        SlimeChunkSection[] sections = new SlimeChunkSection[16];
        for (int sectionId = 0; sectionId < this.chunk.getSections().length; ++sectionId) {
            ChunkSection section = this.chunk.getSections()[sectionId];
            if (section == null) continue;
            section.recalcBlockCounts();
            if (section.a()) continue;
            NibbleArray blockLightArray = Converter.convertArray(section.getEmittedLightArray());
            NibbleArray skyLightArray = Converter.convertArray(section.getSkyLightArray());
            DataPaletteBlock dataPaletteBlock = section.getBlocks();
            NBTTagCompound blocksCompound = new NBTTagCompound();
            dataPaletteBlock.b(blocksCompound, "Palette", "BlockStates");
            NBTTagList paletteList = blocksCompound.getList("Palette", 10);
            ListTag palette = (ListTag)Converter.convertTag("", (NBTBase)paletteList);
            long[] blockStates = blocksCompound.o("BlockStates");
            sections[sectionId] = new CraftSlimeChunkSection(null, null, palette, blockStates, blockLightArray, skyLightArray);
        }
        return sections;
    }

    @Override
    public CompoundTag getHeightMaps() {
        CompoundMap heightMaps = new CompoundMap();
        for (HeightMap.Type type : this.chunk.heightMap.keySet()) {
            heightMaps.put(type.b(), new LongArrayTag(type.b(), this.chunk.b(type).b()));
        }
        return new CompoundTag("", heightMaps);
    }

    @Override
    public int[] getBiomes() {
        BiomeBase[] biomeBases = this.chunk.getBiomeIndex();
        int[] biomes = new int[biomeBases.length];
        for (int i = 0; i < biomeBases.length; ++i) {
            biomes[i] = IRegistry.BIOME.a((Object)biomeBases[i]);
        }
        return biomes;
    }

    @Override
    public List<CompoundTag> getTileEntities() {
        ArrayList<CompoundTag> tileEntities = new ArrayList<CompoundTag>();
        for (TileEntity entity : this.chunk.getTileEntities().values()) {
            NBTTagCompound entityNbt = new NBTTagCompound();
            entity.save(entityNbt);
            tileEntities.add((CompoundTag)Converter.convertTag("", (NBTBase)entityNbt));
        }
        return tileEntities;
    }

    @Override
    public List<CompoundTag> getEntities() {
        ArrayList<CompoundTag> entities = new ArrayList<CompoundTag>();
        for (int i = 0; i < this.chunk.getEntitySlices().length; ++i) {
            for (Entity entity : this.chunk.getEntitySlices()[i]) {
                NBTTagCompound entityNbt;
                if (!entity.d(entityNbt = new NBTTagCompound())) continue;
                this.chunk.f(true);
                entities.add((CompoundTag)Converter.convertTag("", (NBTBase)entityNbt));
            }
        }
        return entities;
    }

    public Chunk getChunk() {
        return this.chunk;
    }

    public NBTTagCompound getCompound() {
        return this.compound;
    }

    public void setChunk(Chunk chunk) {
        this.chunk = chunk;
    }

    public void setCompound(NBTTagCompound compound) {
        this.compound = compound;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NMSSlimeChunk)) {
            return false;
        }
        NMSSlimeChunk other = (NMSSlimeChunk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Chunk this$chunk = this.getChunk();
        Chunk other$chunk = other.getChunk();
        if (this$chunk == null ? other$chunk != null : !this$chunk.equals(other$chunk)) {
            return false;
        }
        NBTTagCompound this$compound = this.getCompound();
        NBTTagCompound other$compound = other.getCompound();
        return !(this$compound == null ? other$compound != null : !this$compound.equals(other$compound));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NMSSlimeChunk;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Chunk $chunk = this.getChunk();
        result = result * 59 + ($chunk == null ? 43 : $chunk.hashCode());
        NBTTagCompound $compound = this.getCompound();
        result = result * 59 + ($compound == null ? 43 : $compound.hashCode());
        return result;
    }

    public String toString() {
        return "NMSSlimeChunk(chunk=" + this.getChunk() + ", compound=" + this.getCompound() + ")";
    }

    public NMSSlimeChunk(Chunk chunk, NBTTagCompound compound) {
        this.chunk = chunk;
        this.compound = compound;
    }
}

