/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.nms.v1_15_R1;

import com.grinderwolf.swm.api.world.SlimeWorld;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundTag;
import com.grinderwolf.swm.nms.CraftSlimeWorld;
import com.grinderwolf.swm.nms.v1_15_R1.Converter;
import com.grinderwolf.swm.nms.v1_15_R1.CustomWorldData;
import java.io.File;
import java.util.UUID;
import net.minecraft.server.v1_15_R1.EntityHuman;
import net.minecraft.server.v1_15_R1.GameRules;
import net.minecraft.server.v1_15_R1.NBTBase;
import net.minecraft.server.v1_15_R1.NBTTagCompound;
import net.minecraft.server.v1_15_R1.WorldData;
import net.minecraft.server.v1_15_R1.WorldNBTStorage;

public class CustomNBTStorage
extends WorldNBTStorage {
    private static final GameRules EMPTY_GAMERULES = new GameRules();
    private final UUID uuid = UUID.randomUUID();
    private final SlimeWorld world;
    private WorldData worldData;

    public CustomNBTStorage(SlimeWorld world) {
        super(new File("temp_" + world.getName()), world.getName(), null, null);
        this.world = world;
    }

    public WorldData getWorldData() {
        if (this.worldData == null) {
            this.worldData = new CustomWorldData((CraftSlimeWorld)this.world);
        }
        return this.worldData;
    }

    public void checkSession() {
    }

    public void saveWorldData(WorldData worldData, NBTTagCompound nbtTagCompound) {
        CompoundTag gameRules = Converter.convertTag("gamerules", (NBTBase)worldData.v().a()).getAsCompoundTag().get();
        CompoundTag extraData = this.world.getExtraData();
        extraData.getValue().remove("gamerules");
        if (!gameRules.getValue().isEmpty()) {
            extraData.getValue().put("gamerules", gameRules);
        }
    }

    public void saveWorldData(WorldData worldData) {
        this.saveWorldData(worldData, null);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void save(EntityHuman entityHuman) {
    }

    public NBTTagCompound load(EntityHuman entityHuman) {
        return null;
    }

    public String[] getSeenPlayers() {
        return new String[0];
    }

    public SlimeWorld getWorld() {
        return this.world;
    }
}

