/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.nms.v1_15_R1;

import com.grinderwolf.swm.api.world.SlimeWorld;
import com.grinderwolf.swm.api.world.properties.SlimeProperties;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundTag;
import com.grinderwolf.swm.nms.CraftSlimeWorld;
import com.grinderwolf.swm.nms.SlimeNMS;
import com.grinderwolf.swm.nms.v1_15_R1.Converter;
import com.grinderwolf.swm.nms.v1_15_R1.CraftCLSMBridge;
import com.grinderwolf.swm.nms.v1_15_R1.CustomNBTStorage;
import com.grinderwolf.swm.nms.v1_15_R1.CustomWorldServer;
import com.mojang.datafixers.DataFixer;
import net.minecraft.server.v1_15_R1.BlockPosition;
import net.minecraft.server.v1_15_R1.ChunkCoordIntPair;
import net.minecraft.server.v1_15_R1.ChunkProviderServer;
import net.minecraft.server.v1_15_R1.DataConverterRegistry;
import net.minecraft.server.v1_15_R1.DataFixTypes;
import net.minecraft.server.v1_15_R1.DimensionManager;
import net.minecraft.server.v1_15_R1.GameProfileSerializer;
import net.minecraft.server.v1_15_R1.MinecraftServer;
import net.minecraft.server.v1_15_R1.NBTBase;
import net.minecraft.server.v1_15_R1.NBTTagCompound;
import net.minecraft.server.v1_15_R1.TicketType;
import net.minecraft.server.v1_15_R1.Unit;
import net.minecraft.server.v1_15_R1.WorldServer;
import net.minecraft.server.v1_15_R1.WorldSettings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_15_R1.CraftWorld;
import org.bukkit.event.Event;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;

public class v1_15_R1SlimeNMS
implements SlimeNMS {
    private static final Logger LOGGER = LogManager.getLogger((String)"SWM");
    private final byte worldVersion = (byte)5;
    private boolean loadingDefaultWorlds = true;
    private CustomWorldServer defaultWorld;
    private CustomWorldServer defaultNetherWorld;
    private CustomWorldServer defaultEndWorld;

    public v1_15_R1SlimeNMS() {
        try {
            CraftCLSMBridge.initialize(this);
        }
        catch (NoClassDefFoundError ex) {
            LOGGER.error("Failed to find ClassModifier classes. Are you sure you installed it correctly?");
            System.exit(1);
        }
    }

    @Override
    public void setDefaultWorlds(SlimeWorld normalWorld, SlimeWorld netherWorld, SlimeWorld endWorld) {
        World.Environment env;
        if (normalWorld != null) {
            env = World.Environment.valueOf((String)normalWorld.getPropertyMap().getString(SlimeProperties.ENVIRONMENT).toUpperCase());
            if (env != World.Environment.NORMAL) {
                LOGGER.warn("The environment for the default world must always be 'NORMAL'.");
            }
            this.defaultWorld = new CustomWorldServer((CraftSlimeWorld)normalWorld, new CustomNBTStorage(normalWorld), DimensionManager.OVERWORLD, World.Environment.NORMAL);
        }
        if (netherWorld != null) {
            env = World.Environment.valueOf((String)netherWorld.getPropertyMap().getString(SlimeProperties.ENVIRONMENT).toUpperCase());
            this.defaultNetherWorld = new CustomWorldServer((CraftSlimeWorld)netherWorld, new CustomNBTStorage(netherWorld), DimensionManager.a((int)env.getId()), env);
        }
        if (endWorld != null) {
            env = World.Environment.valueOf((String)endWorld.getPropertyMap().getString(SlimeProperties.ENVIRONMENT).toUpperCase());
            this.defaultEndWorld = new CustomWorldServer((CraftSlimeWorld)endWorld, new CustomNBTStorage(endWorld), DimensionManager.a((int)env.getId()), env);
        }
        this.loadingDefaultWorlds = false;
    }

    @Override
    public void generateWorld(SlimeWorld world) {
        String worldName = world.getName();
        if (Bukkit.getWorld((String)worldName) != null) {
            throw new IllegalArgumentException("World " + worldName + " already exists! Maybe it's an outdated SlimeWorld object?");
        }
        CustomNBTStorage dataManager = new CustomNBTStorage(world);
        MinecraftServer mcServer = MinecraftServer.getServer();
        int dimension = 10 + mcServer.worldServer.size();
        boolean used = false;
        block0: do {
            for (WorldServer server : mcServer.getWorlds()) {
                used = server.getWorldProvider().getDimensionManager().getDimensionID() + 1 == dimension;
                if (!used) continue;
                ++dimension;
                continue block0;
            }
        } while (used);
        World.Environment env = World.Environment.valueOf((String)world.getPropertyMap().getString(SlimeProperties.ENVIRONMENT).toUpperCase());
        DimensionManager actualDimension = DimensionManager.a((int)env.getId());
        DimensionManager dimensionManager = DimensionManager.register((String)worldName, (DimensionManager)new DimensionManager(dimension, actualDimension.getSuffix(), actualDimension.folder, actualDimension.providerFactory::apply, actualDimension.hasSkyLight(), actualDimension.getGenLayerZoomer(), actualDimension));
        CustomWorldServer server = new CustomWorldServer((CraftSlimeWorld)world, dataManager, dimensionManager, env);
        LOGGER.info("Loading world " + worldName);
        long startTime = System.currentTimeMillis();
        server.setReady(true);
        mcServer.initWorld((WorldServer)server, dataManager.getWorldData(), new WorldSettings(dataManager.getWorldData()));
        mcServer.server.addWorld((World)server.getWorld());
        mcServer.worldServer.put(dimensionManager, server);
        Bukkit.getPluginManager().callEvent((Event)new WorldInitEvent((World)server.getWorld()));
        if (server.getWorld().getKeepSpawnInMemory()) {
            LOGGER.debug("Preparing start region for dimension '{}'/{}", (Object)worldName, (Object)DimensionManager.a((int)0));
            BlockPosition spawn = server.getSpawn();
            ChunkProviderServer provider = server.getChunkProvider();
            provider.addTicket(TicketType.START, new ChunkCoordIntPair(spawn), 11, (Object)Unit.INSTANCE);
        }
        Bukkit.getPluginManager().callEvent((Event)new WorldLoadEvent((World)server.getWorld()));
        LOGGER.info("World " + worldName + " loaded in " + (System.currentTimeMillis() - startTime) + "ms.");
    }

    @Override
    public SlimeWorld getSlimeWorld(World world) {
        CraftWorld craftWorld = (CraftWorld)world;
        if (!(craftWorld.getHandle() instanceof CustomWorldServer)) {
            return null;
        }
        CustomWorldServer worldServer = (CustomWorldServer)craftWorld.getHandle();
        return worldServer.getSlimeWorld();
    }

    @Override
    public CompoundTag convertChunk(CompoundTag tag) {
        NBTTagCompound nmsTag = (NBTTagCompound)Converter.convertTag(tag);
        int version = nmsTag.getInt("DataVersion");
        NBTTagCompound newNmsTag = GameProfileSerializer.a((DataFixer)DataConverterRegistry.a(), (DataFixTypes)DataFixTypes.CHUNK, (NBTTagCompound)nmsTag, (int)version);
        return (CompoundTag)Converter.convertTag("", (NBTBase)newNmsTag);
    }

    @Override
    public byte getWorldVersion() {
        return this.worldVersion;
    }

    public boolean isLoadingDefaultWorlds() {
        return this.loadingDefaultWorlds;
    }

    public CustomWorldServer getDefaultWorld() {
        return this.defaultWorld;
    }

    public CustomWorldServer getDefaultNetherWorld() {
        return this.defaultNetherWorld;
    }

    public CustomWorldServer getDefaultEndWorld() {
        return this.defaultEndWorld;
    }
}

