/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.nms.v1_9_R1;

import com.grinderwolf.swm.api.utils.NibbleArray;
import com.grinderwolf.swm.api.world.SlimeChunk;
import com.grinderwolf.swm.api.world.SlimeChunkSection;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundMap;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.Tag;
import com.grinderwolf.swm.nms.CraftSlimeWorld;
import com.grinderwolf.swm.nms.v1_9_R1.Converter;
import com.grinderwolf.swm.nms.v1_9_R1.CustomWorldServer;
import com.grinderwolf.swm.nms.v1_9_R1.NMSSlimeChunk;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.v1_9_R1.Chunk;
import net.minecraft.server.v1_9_R1.ChunkSection;
import net.minecraft.server.v1_9_R1.Entity;
import net.minecraft.server.v1_9_R1.EntityTypes;
import net.minecraft.server.v1_9_R1.IChunkLoader;
import net.minecraft.server.v1_9_R1.MinecraftServer;
import net.minecraft.server.v1_9_R1.NBTTagCompound;
import net.minecraft.server.v1_9_R1.TileEntity;
import net.minecraft.server.v1_9_R1.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomChunkLoader
implements IChunkLoader {
    private static final Logger LOGGER = LogManager.getLogger((String)"SWM Chunk Loader");
    private final CraftSlimeWorld world;

    void loadAllChunks(CustomWorldServer server) {
        for (SlimeChunk chunk : new ArrayList<SlimeChunk>(this.world.getChunks().values())) {
            Chunk nmsChunk = this.createChunk(server, chunk);
            this.world.updateChunk(new NMSSlimeChunk(nmsChunk));
        }
    }

    private Chunk createChunk(CustomWorldServer server, SlimeChunk chunk) {
        int x = chunk.getX();
        int z = chunk.getZ();
        LOGGER.debug("Loading chunk (" + x + ", " + z + ") on world " + this.world.getName());
        Chunk nmsChunk = new Chunk((World)server, x, z);
        nmsChunk.d(true);
        nmsChunk.e(true);
        CompoundTag heightMapsCompound = chunk.getHeightMaps();
        int[] heightMap = heightMapsCompound.getIntArrayValue("heightMap").get();
        nmsChunk.a(heightMap);
        LOGGER.debug("Loading chunk sections for chunk (" + x + ", " + z + ") on world " + this.world.getName());
        ChunkSection[] sections = new ChunkSection[16];
        for (int sectionId = 0; sectionId < chunk.getSections().length; ++sectionId) {
            SlimeChunkSection slimeSection = chunk.getSections()[sectionId];
            if (slimeSection == null) continue;
            ChunkSection section = new ChunkSection(sectionId << 4, true);
            NibbleArray data = slimeSection.getData();
            byte[] blocks = slimeSection.getBlocks();
            LOGGER.debug("ChunkSection #" + sectionId + " - Chunk (" + x + ", " + z + ") - World " + this.world.getName() + ":");
            LOGGER.debug("Blocks:");
            LOGGER.debug((Object)blocks);
            LOGGER.debug("Block light array:");
            LOGGER.debug(slimeSection.getBlockLight() != null ? (Object)slimeSection.getBlockLight().getBacking() : "Not present");
            LOGGER.debug("Sky light array:");
            LOGGER.debug(slimeSection.getSkyLight() != null ? (Object)slimeSection.getSkyLight().getBacking() : "Not present");
            section.getBlocks().a(blocks, Converter.convertArray(data), new net.minecraft.server.v1_9_R1.NibbleArray());
            if (slimeSection.getBlockLight() != null) {
                section.a(Converter.convertArray(slimeSection.getBlockLight()));
            }
            if (slimeSection.getSkyLight() != null) {
                section.b(Converter.convertArray(slimeSection.getSkyLight()));
            }
            section.recalcBlockCounts();
            sections[sectionId] = section;
        }
        nmsChunk.a(sections);
        nmsChunk.a(this.toByteArray(chunk.getBiomes()));
        LOGGER.debug("Loading tile entities for chunk (" + x + ", " + z + ") on world " + this.world.getName());
        List<CompoundTag> tileEntities = chunk.getTileEntities();
        int loadedEntities = 0;
        if (tileEntities != null) {
            for (CompoundTag tag : tileEntities) {
                TileEntity entity = TileEntity.a((MinecraftServer)server.getMinecraftServer(), (NBTTagCompound)((NBTTagCompound)Converter.convertTag(tag)));
                if (entity == null) continue;
                nmsChunk.a(entity);
                ++loadedEntities;
            }
        }
        LOGGER.debug("Loaded " + loadedEntities + " tile entities for chunk (" + x + ", " + z + ") on world " + this.world.getName());
        LOGGER.debug("Loading entities for chunk (" + x + ", " + z + ") on world " + this.world.getName());
        List<CompoundTag> entities = chunk.getEntities();
        loadedEntities = 0;
        if (entities != null) {
            for (CompoundTag tag : entities) {
                this.loadEntity(tag, (World)server, nmsChunk);
            }
        }
        LOGGER.debug("Loaded " + loadedEntities + " entities for chunk (" + x + ", " + z + ") on world " + this.world.getName());
        LOGGER.debug("Loaded chunk (" + x + ", " + z + ") on world " + this.world.getName());
        return nmsChunk;
    }

    private byte[] toByteArray(int[] ints) {
        ByteBuffer buf = ByteBuffer.allocate(ints.length * 4).order(ByteOrder.LITTLE_ENDIAN);
        buf.asIntBuffer().put(ints);
        return buf.array();
    }

    private Entity loadEntity(CompoundTag tag, World world, Chunk chunk) {
        Entity entity = EntityTypes.a((NBTTagCompound)((NBTTagCompound)Converter.convertTag(tag)), (World)world);
        chunk.g(true);
        if (entity != null) {
            chunk.a(entity);
            CompoundMap map = tag.getValue();
            if (map.containsKey("Passengers")) {
                List passengersList = (List)((Tag)map.get("Passengers")).getValue();
                for (CompoundTag passengerTag : passengersList) {
                    Entity passenger = this.loadEntity(passengerTag, world, chunk);
                    if (passengerTag == null) continue;
                    passenger.a(entity, true);
                }
            }
        }
        return entity;
    }

    public Chunk a(World nmsWorld, int x, int z) {
        Chunk chunk;
        SlimeChunk slimeChunk = this.world.getChunk(x, z);
        if (slimeChunk == null) {
            chunk = new Chunk(nmsWorld, x, z);
            chunk.d(true);
            chunk.e(true);
        } else if (slimeChunk instanceof NMSSlimeChunk) {
            chunk = ((NMSSlimeChunk)slimeChunk).getChunk();
        } else {
            throw new IllegalStateException("Chunk (" + x + ", " + z + ") has not been converted to a NMSSlimeChunk object!");
        }
        return chunk;
    }

    public void a(World world, Chunk chunk) {
        SlimeChunk slimeChunk = this.world.getChunk(chunk.locX, chunk.locZ);
        if (slimeChunk instanceof NMSSlimeChunk) {
            ((NMSSlimeChunk)slimeChunk).setChunk(chunk);
        } else {
            this.world.updateChunk(new NMSSlimeChunk(chunk));
        }
    }

    public void b() {
    }

    public void b(World world, Chunk chunk) {
    }

    public void a() {
    }

    public CustomChunkLoader(CraftSlimeWorld world) {
        this.world = world;
    }
}

