/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.nms.v1_9_R1;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.grinderwolf.swm.api.exceptions.UnknownWorldException;
import com.grinderwolf.swm.api.world.properties.SlimeProperties;
import com.grinderwolf.swm.api.world.properties.SlimePropertyMap;
import com.grinderwolf.swm.nms.CraftSlimeWorld;
import com.grinderwolf.swm.nms.v1_9_R1.CustomChunkLoader;
import com.grinderwolf.swm.nms.v1_9_R1.CustomDataManager;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.server.v1_9_R1.BlockPosition;
import net.minecraft.server.v1_9_R1.EntityTracker;
import net.minecraft.server.v1_9_R1.EnumDifficulty;
import net.minecraft.server.v1_9_R1.ExceptionWorldConflict;
import net.minecraft.server.v1_9_R1.IDataManager;
import net.minecraft.server.v1_9_R1.IProgressUpdate;
import net.minecraft.server.v1_9_R1.IWorldAccess;
import net.minecraft.server.v1_9_R1.MinecraftServer;
import net.minecraft.server.v1_9_R1.WorldManager;
import net.minecraft.server.v1_9_R1.WorldServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.World;

public class CustomWorldServer
extends WorldServer {
    private static final Logger LOGGER = LogManager.getLogger((String)"SWM World");
    private static final ExecutorService WORLD_SAVER_SERVICE = Executors.newFixedThreadPool(4, new ThreadFactoryBuilder().setNameFormat("SWM Pool Thread #%1$d").build());
    private final CraftSlimeWorld slimeWorld;
    private final Object saveLock = new Object();
    private boolean ready = false;

    CustomWorldServer(CraftSlimeWorld world, IDataManager dataManager, int dimension) {
        super(MinecraftServer.getServer(), dataManager, dataManager.getWorldData(), dimension, MinecraftServer.getServer().methodProfiler, World.Environment.valueOf((String)world.getPropertyMap().getString(SlimeProperties.ENVIRONMENT).toUpperCase()), null);
        this.b();
        this.slimeWorld = world;
        this.tracker = new EntityTracker((WorldServer)this);
        this.addIWorldAccess((IWorldAccess)new WorldManager(MinecraftServer.getServer(), (WorldServer)this));
        SlimePropertyMap propertyMap = world.getPropertyMap();
        this.worldData.setDifficulty(EnumDifficulty.valueOf((String)propertyMap.getString(SlimeProperties.DIFFICULTY).toUpperCase()));
        this.worldData.setSpawn(new BlockPosition(propertyMap.getInt(SlimeProperties.SPAWN_X), propertyMap.getInt(SlimeProperties.SPAWN_Y), propertyMap.getInt(SlimeProperties.SPAWN_Z)));
        super.setSpawnFlags(propertyMap.getBoolean(SlimeProperties.ALLOW_MONSTERS).booleanValue(), propertyMap.getBoolean(SlimeProperties.ALLOW_ANIMALS).booleanValue());
        this.pvpMode = propertyMap.getBoolean(SlimeProperties.PVP);
        CustomChunkLoader chunkLoader = ((CustomDataManager)this.getDataManager()).getChunkLoader();
        chunkLoader.loadAllChunks(this);
    }

    public void save(boolean forceSave, IProgressUpdate progressUpdate) throws ExceptionWorldConflict {
        if (!this.slimeWorld.isReadOnly()) {
            super.save(forceSave, progressUpdate);
            if (MinecraftServer.getServer().isStopped()) {
                this.save();
                try {
                    this.slimeWorld.getLoader().unlockWorld(this.slimeWorld.getName());
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to unlock the world " + this.slimeWorld.getName() + ". Please unlock it manually by using the command /swm manualunlock. Stack trace:");
                    ex.printStackTrace();
                }
                catch (UnknownWorldException unknownWorldException) {}
            } else {
                WORLD_SAVER_SERVICE.execute(this::save);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        Object object = this.saveLock;
        synchronized (object) {
            try {
                LOGGER.info("Saving world " + this.slimeWorld.getName() + "...");
                long start = System.currentTimeMillis();
                byte[] serializedWorld = this.slimeWorld.serialize();
                this.slimeWorld.getLoader().saveWorld(this.slimeWorld.getName(), serializedWorld, false);
                LOGGER.info("World " + this.slimeWorld.getName() + " saved in " + (System.currentTimeMillis() - start) + "ms.");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public CraftSlimeWorld getSlimeWorld() {
        return this.slimeWorld;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }
}

