/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.nms.v1_9_R2;

import com.grinderwolf.swm.api.utils.NibbleArray;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.ByteArrayTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.ByteTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundMap;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.DoubleTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.FloatTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.IntArrayTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.IntTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.ListTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.LongTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.ShortTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.StringTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.Tag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.TagType;
import java.util.ArrayList;
import net.minecraft.server.v1_9_R2.NBTBase;
import net.minecraft.server.v1_9_R2.NBTTagByte;
import net.minecraft.server.v1_9_R2.NBTTagByteArray;
import net.minecraft.server.v1_9_R2.NBTTagCompound;
import net.minecraft.server.v1_9_R2.NBTTagDouble;
import net.minecraft.server.v1_9_R2.NBTTagFloat;
import net.minecraft.server.v1_9_R2.NBTTagInt;
import net.minecraft.server.v1_9_R2.NBTTagIntArray;
import net.minecraft.server.v1_9_R2.NBTTagList;
import net.minecraft.server.v1_9_R2.NBTTagLong;
import net.minecraft.server.v1_9_R2.NBTTagShort;
import net.minecraft.server.v1_9_R2.NBTTagString;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Converter {
    private static final Logger LOGGER = LogManager.getLogger((String)"SWM Converter");

    static net.minecraft.server.v1_9_R2.NibbleArray convertArray(NibbleArray array) {
        return new net.minecraft.server.v1_9_R2.NibbleArray(array.getBacking());
    }

    static NibbleArray convertArray(net.minecraft.server.v1_9_R2.NibbleArray array) {
        return new NibbleArray(array.asBytes());
    }

    static NBTBase convertTag(Tag tag) {
        try {
            switch (tag.getType()) {
                case TAG_BYTE: {
                    return new NBTTagByte(((ByteTag)tag).getValue().byteValue());
                }
                case TAG_SHORT: {
                    return new NBTTagShort(((ShortTag)tag).getValue().shortValue());
                }
                case TAG_INT: {
                    return new NBTTagInt(((IntTag)tag).getValue().intValue());
                }
                case TAG_LONG: {
                    return new NBTTagLong(((LongTag)tag).getValue().longValue());
                }
                case TAG_FLOAT: {
                    return new NBTTagFloat(((FloatTag)tag).getValue().floatValue());
                }
                case TAG_DOUBLE: {
                    return new NBTTagDouble(((DoubleTag)tag).getValue().doubleValue());
                }
                case TAG_BYTE_ARRAY: {
                    return new NBTTagByteArray(((ByteArrayTag)tag).getValue());
                }
                case TAG_STRING: {
                    return new NBTTagString(((StringTag)tag).getValue());
                }
                case TAG_INT_ARRAY: {
                    return new NBTTagIntArray(((IntArrayTag)tag).getValue());
                }
                case TAG_LIST: {
                    NBTTagList list = new NBTTagList();
                    ((ListTag)tag).getValue().stream().map(Converter::convertTag).forEach(arg_0 -> ((NBTTagList)list).add(arg_0));
                    return list;
                }
                case TAG_COMPOUND: {
                    NBTTagCompound compound = new NBTTagCompound();
                    ((CompoundTag)tag).getValue().forEach((key, value) -> compound.set(key, Converter.convertTag(value)));
                    return compound;
                }
            }
            throw new IllegalArgumentException("Invalid tag type " + tag.getType().name());
        }
        catch (Exception ex) {
            LOGGER.error("Failed to convert NBT object:");
            LOGGER.error(tag.toString());
            throw ex;
        }
    }

    static Tag convertTag(String name, NBTBase base) {
        switch (base.getTypeId()) {
            case 1: {
                return new ByteTag(name, ((NBTTagByte)base).f());
            }
            case 2: {
                return new ShortTag(name, ((NBTBase.NBTNumber)base).e());
            }
            case 3: {
                return new IntTag(name, ((NBTBase.NBTNumber)base).d());
            }
            case 4: {
                return new LongTag(name, ((NBTBase.NBTNumber)base).c());
            }
            case 5: {
                return new FloatTag(name, ((NBTBase.NBTNumber)base).h());
            }
            case 6: {
                return new DoubleTag(name, ((NBTBase.NBTNumber)base).g());
            }
            case 7: {
                return new ByteArrayTag(name, ((NBTTagByteArray)base).c());
            }
            case 8: {
                return new StringTag(name, ((NBTTagString)base).a_());
            }
            case 9: {
                ArrayList<Tag> list = new ArrayList<Tag>();
                NBTTagList originalList = (NBTTagList)base;
                for (int i = 0; i < originalList.size(); ++i) {
                    NBTBase entry = originalList.h(i);
                    list.add(Converter.convertTag("", entry));
                }
                return new ListTag(name, TagType.getById(originalList.d()), list);
            }
            case 10: {
                NBTTagCompound originalCompound = (NBTTagCompound)base;
                CompoundTag compound = new CompoundTag(name, new CompoundMap());
                for (String key : originalCompound.c()) {
                    compound.getValue().put(key, Converter.convertTag(key, originalCompound.get(key)));
                }
                return compound;
            }
            case 11: {
                return new IntArrayTag("", ((NBTTagIntArray)base).c());
            }
        }
        throw new IllegalArgumentException("Invalid tag type " + base.getTypeId());
    }
}

