/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.nms.v1_9_R2;

import com.grinderwolf.swm.api.world.SlimeWorld;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.StringTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.Tag;
import com.grinderwolf.swm.nms.CraftSlimeWorld;
import com.grinderwolf.swm.nms.v1_9_R2.Converter;
import com.grinderwolf.swm.nms.v1_9_R2.CustomChunkLoader;
import com.grinderwolf.swm.nms.v1_9_R2.CustomWorldData;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.server.v1_9_R2.EntityHuman;
import net.minecraft.server.v1_9_R2.GameRules;
import net.minecraft.server.v1_9_R2.IChunkLoader;
import net.minecraft.server.v1_9_R2.NBTBase;
import net.minecraft.server.v1_9_R2.NBTTagCompound;
import net.minecraft.server.v1_9_R2.WorldData;
import net.minecraft.server.v1_9_R2.WorldNBTStorage;
import net.minecraft.server.v1_9_R2.WorldProvider;

public class CustomDataManager
extends WorldNBTStorage {
    private static final Map<String, String> defaultValues;
    private final UUID uuid = UUID.randomUUID();
    private final SlimeWorld world;
    private final CustomChunkLoader chunkLoader;
    private WorldData worldData;

    CustomDataManager(SlimeWorld world) {
        super(new File("temp_" + world.getName()), world.getName(), false, null);
        File baseDir = new File("temp_" + world.getName(), world.getName());
        new File(baseDir, "session.lock").delete();
        new File(baseDir, "data").delete();
        baseDir.delete();
        baseDir.getParentFile().delete();
        this.world = world;
        this.chunkLoader = new CustomChunkLoader((CraftSlimeWorld)world);
    }

    public WorldData getWorldData() {
        if (this.worldData == null) {
            this.worldData = new CustomWorldData((CraftSlimeWorld)this.world);
        }
        return this.worldData;
    }

    public void checkSession() {
    }

    public IChunkLoader createChunkLoader(WorldProvider worldProvider) {
        return this.chunkLoader;
    }

    public void saveWorldData(WorldData worldData, NBTTagCompound nbtTagCompound) {
        CompoundTag gameRules = Converter.convertTag("gamerules", (NBTBase)worldData.w().a()).getAsCompoundTag().get();
        CompoundTag extraData = this.world.getExtraData();
        extraData.getValue().remove("gamerules");
        if (!gameRules.getValue().isEmpty()) {
            for (Map.Entry<String, Tag<?>> entry : new ArrayList(gameRules.getValue().entrySet())) {
                String rule = entry.getKey();
                StringTag valueTag = (StringTag)entry.getValue();
                String defaultValue = defaultValues.get(rule);
                if (!valueTag.getValue().equalsIgnoreCase(defaultValue)) continue;
                gameRules.getValue().remove(rule);
            }
            if (!gameRules.getValue().isEmpty()) {
                extraData.getValue().put("gamerules", gameRules);
            }
        }
    }

    public void saveWorldData(WorldData worldData) {
        this.saveWorldData(worldData, null);
    }

    public void a() {
    }

    public File getDataFile(String s2) {
        return null;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void save(EntityHuman entityHuman) {
    }

    public NBTTagCompound load(EntityHuman entityHuman) {
        return null;
    }

    public String[] getSeenPlayers() {
        return new String[0];
    }

    public SlimeWorld getWorld() {
        return this.world;
    }

    public CustomChunkLoader getChunkLoader() {
        return this.chunkLoader;
    }

    static {
        GameRules emptyRules = new GameRules();
        String[] rules = emptyRules.getGameRules();
        defaultValues = Arrays.stream(rules).collect(Collectors.toMap(rule -> rule, arg_0 -> ((GameRules)emptyRules).get(arg_0)));
    }
}

